/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.TestAssignmentStatement;
import org.teiid.query.sql.proc.TestCommandStatement;
import org.teiid.query.sql.proc.TestRaiseErrorStatement;

public class TestBlock {
    public static final Block sample1() {
        Block block = new Block();
        block.addStatement((Statement)TestAssignmentStatement.sample1());
        block.addStatement((Statement)TestCommandStatement.sample1());
        block.addStatement((Statement)TestRaiseErrorStatement.sample1());
        block.addStatement((Statement)TestAssignmentStatement.sample1());
        return block;
    }

    public static final Block sample2() {
        Block block = new Block();
        block.addStatement((Statement)TestAssignmentStatement.sample2());
        block.addStatement((Statement)TestCommandStatement.sample2());
        block.addStatement((Statement)TestRaiseErrorStatement.sample2());
        block.addStatement((Statement)TestAssignmentStatement.sample2());
        return block;
    }

    @Test
    public void testGetStatements1() {
        Block b1 = TestBlock.sample1();
        List stmts = b1.getStatements();
        Assert.assertTrue((String)"Incorrect number of statements in the Block", (stmts.size() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testGetStatements2() {
        Block b1 = TestBlock.sample1();
        Statement stmt = (Statement)b1.getStatements().get(1);
        Assert.assertTrue((String)"Incorrect statement in the Block", (boolean)stmt.equals(TestCommandStatement.sample1()));
    }

    @Test
    public void testaddStatement1() {
        Block b1 = TestBlock.sample1().clone();
        b1.addStatement((Statement)TestCommandStatement.sample2());
        Assert.assertTrue((String)"Incorrect number of statements in the Block", (b1.getStatements().size() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testaddStatement2() {
        Block b1 = TestBlock.sample2().clone();
        b1.addStatement((Statement)TestCommandStatement.sample2());
        Statement stmt = (Statement)b1.getStatements().get(4);
        Assert.assertTrue((String)"Incorrect statement in the Block", (boolean)stmt.equals(TestCommandStatement.sample2()));
    }

    @Test
    public void testSelfEquivalence() {
        Block b1 = TestBlock.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)b1, (Object)b1);
    }

    @Test
    public void testEquivalence() {
        Block b1 = TestBlock.sample1();
        Block b1a = TestBlock.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)b1, (Object)b1a);
    }

    @Test
    public void testNonEquivalence() {
        Block b1 = TestBlock.sample1();
        Block b2 = TestBlock.sample2();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)b1, (Object)b2);
    }

    @Test
    public void testClone() {
        Block b1 = TestBlock.sample1();
        Block b2 = b1.clone();
        UnitTestUtil.helpTestEquivalence((int)0, (Object)b1, (Object)b2);
        Assert.assertNotSame(b1.getStatements().get(0), b2.getStatements().get(0));
    }

    @Test
    public void testExceptionGroup() {
        Block b1 = TestBlock.sample1();
        Block b2 = b1.clone();
        b1.setExceptionGroup("x");
        b2.setExceptionGroup("y");
        Assert.assertFalse((boolean)b1.equals((Object)b2));
    }
}

