/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.transaction;

import java.sql.SQLException;
import org.teiid.test.framework.TransactionContainer;
import org.teiid.test.framework.TransactionQueryTestCase;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class LocalTransaction
extends TransactionContainer {
    @Override
    protected void before(TransactionQueryTestCase test) {
        test.getConnectionStrategy().setEnvironmentProperty("autoCommitTxn", "OFF");
        try {
            this.debug("Autocommit: " + test.getConnectionStrategy().getAutocommit());
            test.getConnection().setAutoCommit(test.getConnectionStrategy().getAutocommit());
        }
        catch (SQLException e) {
            throw new TransactionRuntimeException(e);
        }
    }

    @Override
    protected void after(TransactionQueryTestCase test) {
        boolean exception = false;
        try {
            if (test.rollbackAllways() || test.exceptionOccurred()) {
                test.getConnection().rollback();
            } else {
                test.getConnection().commit();
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
            exception = true;
            try {
                test.getConnection().rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new TransactionRuntimeException(se);
        }
        finally {
            if (!exception) {
                try {
                    test.getConnection().setAutoCommit(true);
                }
                catch (SQLException e) {
                    throw new TransactionRuntimeException(e);
                }
            }
        }
    }
}

