/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.TeiidComponentException;

public class SplittableStorageManager
implements StorageManager {
    public static final long DEFAULT_MAX_FILESIZE = 2048L;
    private long maxFileSize = 0x80000000L;
    private StorageManager storageManager;

    public SplittableStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @Override
    public FileStore createFileStore(String name) {
        return new SplittableFileStore(name);
    }

    @Override
    public void initialize() throws TeiidComponentException {
        this.storageManager.initialize();
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize * 1024L * 1024L;
    }

    public void setMaxFileSizeDirect(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public long getMaxStorageSpace() {
        return this.storageManager.getMaxStorageSpace();
    }

    public class SplittableFileStore
    extends FileStore {
        private String name;
        private List<FileStore> storageFiles = new ArrayList<FileStore>();
        private volatile long len;

        public SplittableFileStore(String name) {
            this.name = name;
        }

        @Override
        public long getLength() {
            return this.len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int readWrite(long fileOffset, byte[] b, int offSet, int length, boolean write) throws IOException {
            FileStore store = null;
            if (!write) {
                SplittableFileStore splittableFileStore = this;
                synchronized (splittableFileStore) {
                    if (fileOffset > this.len) {
                        throw new IOException("Invalid file position " + fileOffset + " length " + length);
                    }
                    store = this.storageFiles.get((int)(fileOffset / SplittableStorageManager.this.maxFileSize));
                }
                return store.read(fileOffset % SplittableStorageManager.this.maxFileSize, b, offSet, length);
            }
            SplittableFileStore splittableFileStore = this;
            synchronized (splittableFileStore) {
                this.ensureLength(fileOffset + (long)length);
                store = this.storageFiles.get((int)(fileOffset / SplittableStorageManager.this.maxFileSize));
            }
            long fileBegin = fileOffset % SplittableStorageManager.this.maxFileSize;
            length = Math.min(length, (int)Math.min(Integer.MAX_VALUE, SplittableStorageManager.this.maxFileSize - fileBegin));
            store.write(fileBegin, b, offSet, length);
            return length;
        }

        private void ensureLength(long length) throws IOException {
            if (length <= this.len) {
                return;
            }
            int numFiles = (int)(length / SplittableStorageManager.this.maxFileSize);
            long lastFileSize = length % SplittableStorageManager.this.maxFileSize;
            if (lastFileSize > 0L) {
                ++numFiles;
            }
            for (int i = this.storageFiles.size(); i < numFiles; ++i) {
                FileStore newFileInfo = SplittableStorageManager.this.storageManager.createFileStore(this.name + "_" + this.storageFiles.size());
                this.storageFiles.add(newFileInfo);
                if (lastFileSize != 0L && i == numFiles - 1) continue;
                newFileInfo.setLength(SplittableStorageManager.this.maxFileSize);
            }
            if (lastFileSize > 0L) {
                this.storageFiles.get(this.storageFiles.size() - 1).setLength(lastFileSize);
            }
            this.len = length;
        }

        @Override
        public synchronized void setLength(long length) throws IOException {
            if (length > this.len) {
                this.ensureLength(length);
            } else {
                int numFiles = (int)(length / SplittableStorageManager.this.maxFileSize);
                long lastFileSize = length % SplittableStorageManager.this.maxFileSize;
                if (lastFileSize > 0L) {
                    ++numFiles;
                }
                int toRemove = this.storageFiles.size() - numFiles;
                for (int i = 0; i < toRemove; ++i) {
                    FileStore store = this.storageFiles.remove(this.storageFiles.size() - 1);
                    store.remove();
                }
                if (lastFileSize > 0L) {
                    this.storageFiles.get(this.storageFiles.size() - 1).setLength(lastFileSize);
                }
            }
            this.len = length;
        }

        @Override
        public synchronized void removeDirect() {
            for (int i = this.storageFiles.size() - 1; i >= 0; --i) {
                this.storageFiles.remove(i).remove();
            }
        }
    }
}

