/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.gss;

import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.LogonResult;
import org.teiid.core.BundleUtil;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.TeiidSQLException;

class GssAction
implements PrivilegedAction {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    private final ILogon logon;
    private final String kerberosPrincipalName;
    private Properties props;
    private GSSCredential gssCredential;
    private String user;

    public GssAction(ILogon pgStream, String kerberosPrincipalName, Properties props, String user, GSSCredential gssCredential) {
        this.logon = pgStream;
        this.kerberosPrincipalName = kerberosPrincipalName;
        this.props = props;
        this.user = user;
        this.gssCredential = gssCredential;
    }

    public Object run() {
        byte[] outToken = null;
        try {
            Oid[] desiredMechs = new Oid[]{new Oid("1.2.840.113554.1.2.2")};
            GSSManager manager = GSSManager.getInstance();
            Oid KERBEROS_V5_PRINCIPAL_NAME = new Oid("1.2.840.113554.1.2.2.1");
            GSSName serverName = manager.createName(this.kerberosPrincipalName, KERBEROS_V5_PRINCIPAL_NAME);
            GSSCredential clientCreds = null;
            if (this.gssCredential != null) {
                clientCreds = this.gssCredential;
            }
            GSSContext secContext = manager.createContext(serverName, desiredMechs[0], clientCreds, 0);
            secContext.requestMutualAuth(true);
            secContext.requestConf(true);
            secContext.requestInteg(true);
            secContext.requestCredDeleg(true);
            byte[] inToken = new byte[]{};
            boolean established = false;
            LogonResult result = null;
            while (!established) {
                outToken = secContext.initSecContext(inToken, 0, inToken.length);
                if (outToken != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Sending Service Token to Server (GSS Authentication Token)");
                    }
                    result = this.logon.neogitiateGssLogin(this.props, outToken, true);
                    inToken = (byte[])result.getProperty("KRB5TOKEN");
                }
                if (!secContext.isEstablished()) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Authentication GSS Continue");
                    continue;
                }
                established = true;
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("Authentication GSS Established");
            }
            return result;
        }
        catch (GSSException gsse) {
            return TeiidSQLException.create(gsse, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20005, new Object[0]));
        }
        catch (Exception e) {
            return e;
        }
    }
}

