/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestProjectNode {
    public ProjectNode helpSetupProject(List elements, List[] data, List childElements, ProcessorDataManager dataMgr) {
        BufferManager mgr = BufferManagerFactory.getStandaloneBufferManager();
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, (Object)1);
        FakeRelationalNode dataNode = new FakeRelationalNode(2, data);
        dataNode.setElements(childElements);
        dataNode.initialize(context, mgr, null);
        ProjectNode projectNode = new ProjectNode(1);
        projectNode.setSelectSymbols(elements);
        projectNode.setElements(elements);
        projectNode.addChild((RelationalNode)dataNode);
        projectNode.initialize(context, mgr, dataMgr);
        return projectNode;
    }

    public void helpTestProject(List elements, List[] data, List childElements, List[] expected, ProcessorDataManager dataMgr) throws TeiidComponentException, TeiidProcessingException {
        ProjectNode projectNode = this.helpSetupProject(elements, data, childElements, dataMgr);
        projectNode.open();
        int currentRow = 1;
        block2: while (true) {
            try {
                while (true) {
                    TupleBatch batch = projectNode.nextBatch();
                    int row = currentRow;
                    while ((long)row <= batch.getEndRow()) {
                        Assert.assertEquals((String)("Rows don't match at " + row), (Object)expected[row - 1], (Object)batch.getTuple((long)row));
                        ++row;
                    }
                    if (batch.getTerminationFlag()) break block2;
                    currentRow += batch.getRowCount();
                }
            }
            catch (BlockedException blockedException) {
                continue;
            }
            break;
        }
    }

    public void helpTestProjectFails(List elements, List[] data, List childElements, String expectedError) throws TeiidComponentException, TeiidProcessingException {
        ProjectNode projectNode = this.helpSetupProject(elements, data, childElements, null);
        try {
            TupleBatch batch;
            projectNode.open();
            while (!(batch = projectNode.nextBatch()).getTerminationFlag()) {
            }
            Assert.fail((String)"Expected error but test succeeded");
        }
        catch (ExpressionEvaluationException e) {
            Assert.assertEquals((String)"Got unexpected exception", (Object)expectedError.toUpperCase(), (Object)e.getMessage().toUpperCase());
        }
    }

    @Test
    public void testNoProject() throws Exception {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol es2 = new ElementSymbol("e2");
        es2.setType(DataTypeManager.DefaultDataClasses.STRING);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        elements.add(es2);
        List[] data = new List[]{};
        ArrayList<ElementSymbol> projectElements = new ArrayList<ElementSymbol>();
        projectElements.add(es1);
        projectElements.add(es2);
        this.helpTestProject(elements, data, projectElements, data, null);
    }

    @Test
    public void testProjectPassThrough() throws Exception {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol es2 = new ElementSymbol("e2");
        es2.setType(DataTypeManager.DefaultDataClasses.STRING);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        elements.add(es2);
        ArrayList<ElementSymbol> projectElements = new ArrayList<ElementSymbol>();
        projectElements.add(es1);
        projectElements.add(es2);
        List[] data = new List[20];
        for (int i = 0; i < 20; ++i) {
            data[i] = new ArrayList();
            data[i].add(new Integer(i * 51 % 11));
            String str = "" + i * 3;
            str = str.substring(0, 1);
            data[i].add(str);
        }
        this.helpTestProject(elements, data, projectElements, data, null);
    }

    @Test
    public void testProjectReorder() throws Exception {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol es2 = new ElementSymbol("e2");
        es2.setType(DataTypeManager.DefaultDataClasses.STRING);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        elements.add(es2);
        ArrayList<ElementSymbol> projectElements = new ArrayList<ElementSymbol>();
        projectElements.add(es2);
        projectElements.add(es1);
        List[] data = new List[20];
        List[] expected = new List[20];
        for (int i = 0; i < 20; ++i) {
            data[i] = new ArrayList();
            expected[i] = new ArrayList();
            data[i].add(new Integer(i * 51 % 11));
            String str = "" + i * 3;
            str = str.substring(0, 1);
            data[i].add(str);
            expected[i].add(data[i].get(1));
            expected[i].add(data[i].get(0));
        }
        this.helpTestProject(elements, data, projectElements, expected, null);
    }

    @Test
    public void testProjectExpression() throws Exception {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.STRING);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        Function func = new Function("concat", new Expression[]{es1, new Constant((Object)"abc")});
        FunctionDescriptor fd = RealMetadataFactory.SFM.getSystemFunctionLibrary().findFunction("concat", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
        func.setFunctionDescriptor(fd);
        func.setType(DataTypeManager.DefaultDataClasses.STRING);
        ExpressionSymbol expr = new ExpressionSymbol("expr", (Expression)func);
        ArrayList<ExpressionSymbol> projectElements = new ArrayList<ExpressionSymbol>();
        projectElements.add(expr);
        List[] data = new List[]{Arrays.asList("1"), Arrays.asList("2")};
        List[] expected = new List[]{Arrays.asList("1abc"), Arrays.asList("2abc")};
        this.helpTestProject(projectElements, data, elements, expected, null);
    }

    @Test
    public void testProjectExpressionFunctionFails() throws Exception {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.STRING);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        Function func = new Function("convert", new Expression[]{es1, new Constant((Object)"integer")});
        FunctionDescriptor fd = RealMetadataFactory.SFM.getSystemFunctionLibrary().findFunction("convert", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
        func.setFunctionDescriptor(fd);
        func.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ExpressionSymbol expr = new ExpressionSymbol("expr", (Expression)func);
        ArrayList<ExpressionSymbol> projectElements = new ArrayList<ExpressionSymbol>();
        projectElements.add(expr);
        List[] data = new List[]{Arrays.asList("1"), Arrays.asList("2x")};
        String expectedMessage = "TEIID30328 UNABLE TO EVALUATE CONVERT(E1, INTEGER): TEIID30384 ERROR WHILE EVALUATING FUNCTION CONVERT";
        this.helpTestProjectFails(projectElements, data, elements, expectedMessage);
    }

    @Test
    public void testProjectWithLookupFunction() throws Exception {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.STRING);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        Function func = new Function("lookup", new Expression[]{new Constant((Object)"pm1.g1"), new Constant((Object)"e2"), new Constant((Object)"e1"), es1});
        FunctionDescriptor desc = RealMetadataFactory.SFM.getSystemFunctionLibrary().findFunction("lookup", new Class[]{String.class, String.class, String.class, String.class});
        func.setFunctionDescriptor(desc);
        func.setType(DataTypeManager.DefaultDataClasses.STRING);
        ExpressionSymbol expr = new ExpressionSymbol("expr", (Expression)func);
        ArrayList<ExpressionSymbol> projectElements = new ArrayList<ExpressionSymbol>();
        projectElements.add(expr);
        List[] data = new List[]{Arrays.asList("1"), Arrays.asList("2")};
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("b")};
        FakeDataManager dataMgr = new FakeDataManager();
        dataMgr.setThrowBlocked(true);
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("1", "a");
        valueMap.put("2", "b");
        dataMgr.defineCodeTable("pm1.g1", "e1", "e2", valueMap);
        this.helpTestProject(projectElements, data, elements, expected, dataMgr);
    }
}

