/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.client.RequestMessage;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.netty.handler.codec.serialization.CompactObjectInputStream;

public class TestRequestMessage {
    public static RequestMessage example() {
        RequestMessage message = new RequestMessage();
        message.setStatementType(RequestMessage.StatementType.CALLABLE);
        message.setFetchSize(100);
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(new Integer(100));
        params.add(new Integer(200));
        params.add(new Integer(300));
        params.add(new Integer(400));
        message.setParameterValues(params);
        message.setPartialResults(true);
        message.setStyleSheet("myStyleSheet");
        message.setExecutionPayload((Serializable)((Object)"myExecutionPayload"));
        try {
            message.setTxnAutoWrapMode("ON");
        }
        catch (TeiidProcessingException e) {
            throw new RuntimeException(e);
        }
        message.setValidationMode(true);
        message.setXMLFormat("xMLFormat");
        message.setShowPlan(RequestMessage.ShowPlan.ON);
        message.setRowLimit(1313);
        message.setReturnAutoGeneratedKeys(true);
        message.setDelaySerialization(true);
        return message;
    }

    @Test
    public void testSerialize() throws Exception {
        RequestMessage copy = (RequestMessage)UnitTestUtil.helpSerialize((Serializable)TestRequestMessage.example());
        Assert.assertTrue((boolean)copy.isCallableStatement());
        Assert.assertEquals((long)100L, (long)copy.getFetchSize());
        Assert.assertNotNull((Object)copy.getParameterValues());
        Assert.assertEquals((long)4L, (long)copy.getParameterValues().size());
        Assert.assertEquals((Object)new Integer(100), copy.getParameterValues().get(0));
        Assert.assertEquals((Object)new Integer(200), copy.getParameterValues().get(1));
        Assert.assertEquals((Object)new Integer(300), copy.getParameterValues().get(2));
        Assert.assertEquals((Object)new Integer(400), copy.getParameterValues().get(3));
        Assert.assertFalse((boolean)copy.isPreparedStatement());
        Assert.assertEquals((Object)"myStyleSheet", (Object)copy.getStyleSheet());
        Assert.assertEquals((Object)"myExecutionPayload", (Object)copy.getExecutionPayload());
        Assert.assertEquals((Object)"ON", (Object)copy.getTxnAutoWrapMode());
        Assert.assertTrue((boolean)copy.getValidationMode());
        Assert.assertEquals((Object)"xMLFormat", (Object)copy.getXMLFormat());
        Assert.assertEquals((Object)RequestMessage.ShowPlan.ON, (Object)copy.getShowPlan());
        Assert.assertEquals((long)1313L, (long)copy.getRowLimit());
        Assert.assertTrue((boolean)copy.isReturnAutoGeneratedKeys());
        Assert.assertTrue((boolean)copy.isDelaySerialization());
    }

    @Test
    public void testInvalidTxnAutoWrap() {
        RequestMessage rm = new RequestMessage();
        try {
            rm.setTxnAutoWrapMode("foo");
            Assert.fail((String)"exception expected");
        }
        catch (TeiidProcessingException e) {
            Assert.assertEquals((Object)"TEIID20000 'FOO' is an invalid transaction autowrap mode.", (Object)e.getMessage());
        }
    }

    @Test
    public void test83() throws FileNotFoundException, IOException, ClassNotFoundException {
        CompactObjectInputStream ois = new CompactObjectInputStream((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"req.ser")), RequestMessage.class.getClassLoader());
        RequestMessage rm = (RequestMessage)ois.readObject();
        ois.close();
        Assert.assertFalse((boolean)rm.isReturnAutoGeneratedKeys());
        Assert.assertFalse((boolean)rm.isDelaySerialization());
    }
}

