/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.client.RequestMessage;
import org.teiid.client.SourceWarning;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.FakeTransactionService;
import org.teiid.dqp.internal.process.CachingTupleSource;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.QueryProcessorFactoryImpl;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TestDQPCoreRequestHandling;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.dqp.service.FakeBufferService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.CacheDirective;

public class TestDataTierManager {
    private VDBMetaData vdb = RealMetadataFactory.exampleBQTVDB();
    private DQPCore rm;
    private DataTierManagerImpl dtm;
    private CommandContext context;
    private AutoGenDataService connectorManager = new AutoGenDataService();
    private RequestWorkItem workItem;
    private int limit = -1;
    private boolean serial = false;
    private int id;

    @Before
    public void setUp() {
        this.limit = -1;
        this.connectorManager = new AutoGenDataService();
        this.serial = false;
    }

    private static Command helpGetCommand(String sql, QueryMetadataInterface metadata) throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        return command;
    }

    private DataTierTupleSource helpSetup(int nodeId) throws Exception {
        return this.helpSetup("SELECT * FROM BQT1.SmallA", nodeId);
    }

    private DataTierTupleSource helpSetup(String sql, int nodeId) throws Exception {
        this.helpSetupDataTierManager();
        AtomicRequestMessage request = this.helpSetupRequest(sql, nodeId, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        request.setSerial(this.serial);
        return new DataTierTupleSource(request, this.workItem, this.connectorManager.registerRequest(request), this.dtm, this.limit);
    }

    private AtomicRequestMessage helpSetupRequest(String sql, int nodeId, QueryMetadataInterface metadata) throws Exception {
        DQPWorkContext workContext = RealMetadataFactory.buildWorkContext(metadata, this.vdb);
        Command command = TestDataTierManager.helpGetCommand(sql, metadata);
        RequestMessage original = new RequestMessage();
        original.setExecutionId((long)this.id++);
        original.setPartialResults(true);
        RequestID requestID = workContext.getRequestID(original.getExecutionId());
        this.context = new CommandContext();
        this.context.setSession(workContext.getSession());
        this.context.setVdbName("test");
        this.context.setVdbVersion((Object)1);
        this.context.setQueryProcessorFactory((QueryProcessor.ProcessorFactory)new QueryProcessorFactoryImpl(this.dtm.getBufferManager(), (ProcessorDataManager)this.dtm, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), null, metadata));
        this.workItem = TestDQPCoreRequestHandling.addRequest(this.rm, original, requestID, null, workContext);
        this.context.setWorkItem(this.workItem);
        AtomicRequestMessage request = new AtomicRequestMessage(original, workContext, nodeId);
        request.setCommand(command);
        request.setConnectorName("FakeConnectorID");
        request.setCommandContext(this.context);
        return request;
    }

    private void helpSetupDataTierManager() {
        FakeBufferService bs = new FakeBufferService();
        this.rm = new DQPCore();
        this.rm.setTransactionService((TransactionService)new FakeTransactionService());
        this.rm.setBufferManager(bs.getBufferManager());
        CacheConfiguration config = new CacheConfiguration();
        config.setMaxAgeInSeconds(-1);
        this.rm.setResultsetCache(new SessionAwareCache("resultset", (CacheFactory)new DefaultCacheFactory(config), SessionAwareCache.Type.RESULTSET, 0));
        this.rm.setPreparedPlanCache(new SessionAwareCache("preparedplan", (CacheFactory)new DefaultCacheFactory(config), SessionAwareCache.Type.PREPAREDPLAN, 0));
        this.rm.start(new DQPConfiguration());
        ConnectorManagerRepository repo = (ConnectorManagerRepository)Mockito.mock(ConnectorManagerRepository.class);
        Mockito.stub((Object)repo.getConnectorManager(Mockito.anyString())).toReturn((Object)this.connectorManager);
        this.vdb.addAttchment(ConnectorManagerRepository.class, (Object)repo);
        this.dtm = new DataTierManagerImpl(this.rm, bs.getBufferManager(), true);
    }

    @Test
    public void testDataTierTupleSource() throws Exception {
        DataTierTupleSource info = this.helpSetup(1);
        Assert.assertEquals((long)10L, (long)this.pullTuples((TupleSource)info, 10));
        Assert.assertNotNull((Object)this.workItem.getConnectorRequest(info.getAtomicRequestMessage().getAtomicRequestID()));
        Assert.assertNull((Object)info.nextTuple());
        info.closeSource();
        Assert.assertNull((Object)this.workItem.getConnectorRequest(info.getAtomicRequestMessage().getAtomicRequestID()));
    }

    @Test
    public void testDataTierTupleSourceWarnings() throws Exception {
        DataTierTupleSource info = this.helpSetup(1);
        this.connectorManager.addWarning = true;
        Assert.assertEquals((long)10L, (long)this.pullTuples((TupleSource)info, 10));
        Assert.assertNotNull((Object)this.workItem.getConnectorRequest(info.getAtomicRequestMessage().getAtomicRequestID()));
        Assert.assertNull((Object)info.nextTuple());
        List warnings = this.context.getAndClearWarnings();
        Assert.assertEquals((long)1L, (long)warnings.size());
        SourceWarning warning = (SourceWarning)warnings.get(0);
        Assert.assertFalse((boolean)warning.isPartialResultsError());
        info.closeSource();
        Assert.assertNull((Object)this.workItem.getConnectorRequest(info.getAtomicRequestMessage().getAtomicRequestID()));
    }

    @Test
    public void testDataTierTupleSourceLimit() throws Exception {
        this.limit = 1;
        DataTierTupleSource info = this.helpSetup(1);
        Assert.assertEquals((long)1L, (long)this.pullTuples((TupleSource)info, 1));
        Assert.assertNotNull((Object)this.workItem.getConnectorRequest(info.getAtomicRequestMessage().getAtomicRequestID()));
        Assert.assertNull((Object)info.nextTuple());
        info.closeSource();
        Assert.assertNull((Object)this.workItem.getConnectorRequest(info.getAtomicRequestMessage().getAtomicRequestID()));
    }

    private int pullTuples(TupleSource info, int l) throws TeiidComponentException, TeiidProcessingException, InterruptedException {
        int i = 0;
        while (true) {
            try {
                while (info.nextTuple() != null && ++i != l) {
                }
            }
            catch (BlockedException e) {
                Thread.sleep(50L);
                continue;
            }
            break;
        }
        return i;
    }

    @Test
    public void testPartialResults() throws Exception {
        DataTierTupleSource info = this.helpSetup(1);
        this.connectorManager.throwExceptionOnExecute = true;
        for (int i = 0; i < 10; ++i) {
            try {
                Assert.assertNull((Object)info.nextTuple());
                SourceWarning warning = (SourceWarning)this.context.getAndClearWarnings().get(0);
                Assert.assertTrue((boolean)warning.isPartialResultsError());
                return;
            }
            catch (BlockedException e) {
                Thread.sleep(50L);
                continue;
            }
        }
        Assert.fail();
    }

    @Test
    public void testNoRowsException() throws Exception {
        this.connectorManager.setRows(0);
        DataTierTupleSource info = this.helpSetup(3);
        while (true) {
            try {
                Assert.assertNull((Object)info.nextTuple());
            }
            catch (BlockedException e) {
                Thread.sleep(50L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testAsynch() throws Exception {
        this.connectorManager.dataNotAvailable = 10;
        this.serial = true;
        this.connectorManager.setRows(0);
        DataTierTupleSource info = this.helpSetup(3);
        boolean blocked = false;
        while (true) {
            try {
                Assert.assertNull((Object)info.nextTuple());
            }
            catch (BlockedException e) {
                blocked = true;
                try {
                    info.nextTuple();
                }
                catch (BlockedException be) {
                    Assert.fail();
                }
                Thread.sleep(50L);
                continue;
            }
            break;
        }
        Assert.assertTrue((boolean)blocked);
    }

    @Test
    public void testAsynchStrict() throws Exception {
        this.connectorManager.dataNotAvailable = 1000;
        this.serial = true;
        this.connectorManager.strict = true;
        this.connectorManager.setRows(0);
        DataTierTupleSource info = this.helpSetup(3);
        boolean blocked = false;
        try {
            Assert.assertNull((Object)info.nextTuple());
        }
        catch (BlockedException e) {
            blocked = true;
            try {
                info.nextTuple();
                Assert.fail();
            }
            catch (BlockedException blockedException) {
                // empty catch block
            }
        }
        Assert.assertTrue((boolean)blocked);
    }

    @Test
    public void testCachingScope() throws Exception {
        Assert.assertEquals((Object)FunctionMethod.Determinism.SESSION_DETERMINISTIC, (Object)CachingTupleSource.getDeterminismLevel((CacheDirective.Scope)CacheDirective.Scope.SESSION));
        Assert.assertEquals((Object)FunctionMethod.Determinism.SESSION_DETERMINISTIC, (Object)CachingTupleSource.getDeterminismLevel((CacheDirective.Scope)CacheDirective.Scope.NONE));
        Assert.assertEquals((Object)FunctionMethod.Determinism.USER_DETERMINISTIC, (Object)CachingTupleSource.getDeterminismLevel((CacheDirective.Scope)CacheDirective.Scope.USER));
        Assert.assertEquals((Object)FunctionMethod.Determinism.VDB_DETERMINISTIC, (Object)CachingTupleSource.getDeterminismLevel((CacheDirective.Scope)CacheDirective.Scope.VDB));
    }

    @Test
    public void testCaching() throws Exception {
        CacheDirective cd;
        Assert.assertEquals((long)0L, (long)this.connectorManager.getExecuteCount().get());
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        this.connectorManager.cacheDirective = cd = new CacheDirective();
        this.helpSetupDataTierManager();
        Command command = this.helpSetupRequest("SELECT stringkey from bqt1.smalla", 1, (QueryMetadataInterface)metadata).getCommand();
        RegisterRequestParameter rrp = new RegisterRequestParameter();
        rrp.connectorBindingId = "x";
        TupleSource ts = this.dtm.registerRequest(this.context, command, "foo", rrp);
        Assert.assertTrue((boolean)(ts instanceof CachingTupleSource));
        Assert.assertEquals((long)10L, (long)this.pullTuples(ts, -1));
        Assert.assertEquals((long)1L, (long)this.connectorManager.getExecuteCount().get());
        Assert.assertFalse((boolean)rrp.doNotCache);
        Assert.assertFalse((boolean)((CachingTupleSource)ts).dtts.errored);
        Assert.assertNull((Object)((CachingTupleSource)ts).dtts.scope);
        ts.closeSource();
        Assert.assertEquals((long)1L, (long)this.rm.getRsCache().getCachePutCount());
        Assert.assertEquals((long)1L, (long)this.rm.getRsCache().getTotalCacheEntries());
        command = this.helpSetupRequest("SELECT stringkey from bqt1.smalla", 1, (QueryMetadataInterface)metadata).getCommand();
        rrp = new RegisterRequestParameter();
        rrp.connectorBindingId = "x";
        ts = this.dtm.registerRequest(this.context, command, "foo", rrp);
        Assert.assertFalse((boolean)(ts instanceof CachingTupleSource));
        Assert.assertEquals((long)10L, (long)this.pullTuples(ts, -1));
        Assert.assertEquals((long)1L, (long)this.connectorManager.getExecuteCount().get());
        Assert.assertTrue((boolean)rrp.doNotCache);
        command = this.helpSetupRequest("SELECT stringkey from bqt1.smalla", 1, (QueryMetadataInterface)metadata).getCommand();
        this.context.getSession().setSessionId("different");
        rrp = new RegisterRequestParameter();
        rrp.connectorBindingId = "x";
        ts = this.dtm.registerRequest(this.context, command, "foo", rrp);
        Assert.assertTrue((boolean)(ts instanceof CachingTupleSource));
        Assert.assertEquals((long)9L, (long)this.pullTuples(ts, 9));
        Assert.assertEquals((long)2L, (long)this.connectorManager.getExecuteCount().get());
        Assert.assertFalse((boolean)rrp.doNotCache);
        ts.closeSource();
        Assert.assertFalse((boolean)((CachingTupleSource)ts).dtts.errored);
        Assert.assertNull((Object)((CachingTupleSource)ts).dtts.scope);
        Assert.assertEquals((long)2L, (long)this.rm.getRsCache().getCachePutCount());
        Assert.assertEquals((long)2L, (long)this.rm.getRsCache().getTotalCacheEntries());
        command = this.helpSetupRequest("SELECT stringkey from bqt1.smalla", 1, (QueryMetadataInterface)metadata).getCommand();
        cd.setInvalidation(CacheDirective.Invalidation.IMMEDIATE);
        rrp = new RegisterRequestParameter();
        rrp.connectorBindingId = "x";
        ts = this.dtm.registerRequest(this.context, command, "foo", rrp);
        Assert.assertTrue((boolean)(ts instanceof CachingTupleSource));
        Assert.assertEquals((long)10L, (long)this.pullTuples(ts, -1));
        Assert.assertEquals((long)3L, (long)this.connectorManager.getExecuteCount().get());
        Assert.assertFalse((boolean)rrp.doNotCache);
    }

    @Test
    public void testCancelWithCaching() throws Exception {
        CacheDirective cd;
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        this.connectorManager.cacheDirective = cd = new CacheDirective();
        this.helpSetupDataTierManager();
        Command command = this.helpSetupRequest("SELECT stringkey from bqt1.smalla", 1, (QueryMetadataInterface)metadata).getCommand();
        this.context.getSession().setSessionId("different");
        RegisterRequestParameter rrp = new RegisterRequestParameter();
        rrp.connectorBindingId = "x";
        TupleSource ts = this.dtm.registerRequest(this.context, command, "foo", rrp);
        Assert.assertTrue((boolean)(ts instanceof CachingTupleSource));
        Assert.assertEquals((long)4L, (long)this.pullTuples(ts, 4));
        ((CachingTupleSource)ts).item.requestCancel();
        Assert.assertEquals((long)1L, (long)this.connectorManager.getExecuteCount().get());
        Assert.assertFalse((boolean)rrp.doNotCache);
        ts.closeSource();
        Assert.assertFalse((boolean)((CachingTupleSource)ts).dtts.errored);
        Assert.assertNull((Object)((CachingTupleSource)ts).dtts.scope);
        Assert.assertEquals((long)0L, (long)this.rm.getRsCache().getCachePutCount());
    }

    @Test
    public void testCheckForUpdatesWithBatched() throws Exception {
        this.helpSetupDataTierManager();
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        AtomicRequestMessage request = this.helpSetupRequest("delete from bqt1.smalla", 1, (QueryMetadataInterface)metadata);
        Command command = TestDataTierManager.helpGetCommand("insert into bqt1.smalla (stringkey) values ('1')", (QueryMetadataInterface)metadata);
        BatchedUpdateCommand bac = new BatchedUpdateCommand(Arrays.asList(request.getCommand(), command));
        request.setCommand((Command)bac);
        DataTierTupleSource dtts = new DataTierTupleSource(request, this.workItem, this.connectorManager.registerRequest(request), this.dtm, this.limit);
        this.pullTuples((TupleSource)dtts, 2);
    }
}

