/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.BatchedUpdatePlan;
import org.teiid.query.processor.FakeProcessorPlan;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestBatchedUpdatePlan {
    private void helpTestNextBatch(int[] commandsPerPlan) throws Exception {
        ArrayList<FakeProcessorPlan> plans = new ArrayList<FakeProcessorPlan>(commandsPerPlan.length);
        int totalCommands = 0;
        for (int i = 0; i < commandsPerPlan.length; ++i) {
            totalCommands += commandsPerPlan[i];
            plans.add(new FakeProcessorPlan(commandsPerPlan[i]));
        }
        BatchedUpdatePlan plan = new BatchedUpdatePlan(plans, totalCommands, null, false);
        plan.initialize(new CommandContext(), null, null);
        TupleBatch batch = plan.nextBatch();
        Assert.assertEquals((long)totalCommands, (long)batch.getRowCount());
        for (int i = 1; i <= totalCommands; ++i) {
            Assert.assertEquals((Object)new Integer(1), batch.getTuple((long)i).get(0));
        }
    }

    @Test
    public void testOpen() throws Exception {
        FakeProcessorPlan[] plans = new FakeProcessorPlan[4];
        for (int i = 0; i < plans.length; ++i) {
            plans[i] = new FakeProcessorPlan(1);
        }
        BatchedUpdatePlan plan = new BatchedUpdatePlan(Arrays.asList(plans), plans.length, null, false);
        plan.initialize(new CommandContext(), null, null);
        plan.open();
        for (int i = 1; i < plans.length; ++i) {
            Assert.assertFalse((boolean)plans[i].isOpened());
        }
    }

    @Test
    public void testMultipleBatches() throws Exception {
        int i;
        FakeProcessorPlan[] plans = new FakeProcessorPlan[4];
        for (int i2 = 0; i2 < plans.length; ++i2) {
            TupleBatch last = new TupleBatch(2L, Arrays.asList(Arrays.asList(1)));
            last.setTerminationFlag(true);
            plans[i2] = new FakeProcessorPlan(Arrays.asList(Command.getUpdateCommandSymbol()), Arrays.asList(new Object[]{new TupleBatch(1L, Arrays.asList(Arrays.asList(1))), BlockedException.INSTANCE, last}));
        }
        BatchedUpdatePlan plan = new BatchedUpdatePlan(Arrays.asList(plans), plans.length * 2, null, false);
        plan.initialize(new CommandContext(), null, null);
        plan.open();
        for (i = 1; i < plans.length; ++i) {
            Assert.assertFalse((boolean)plans[i].isOpened());
        }
        for (i = 0; i < 4; ++i) {
            try {
                plan.nextBatch();
                Assert.fail();
                continue;
            }
            catch (BlockedException blockedException) {
                // empty catch block
            }
        }
        TupleBatch batch = plan.nextBatch();
        Assert.assertEquals((long)8L, (long)batch.getRowCount());
        Assert.assertTrue((boolean)batch.getTerminationFlag());
    }

    @Test
    public void testNextBatch1() throws Exception {
        this.helpTestNextBatch(new int[]{1, 5, 2, 1, 10, 1, 1});
    }

    @Test
    public void testNextBatch2() throws Exception {
        this.helpTestNextBatch(new int[]{5, 4, 10, 7, 22, 9, 12, 8, 11});
    }

    @Test
    public void testNextBatch3() throws Exception {
        this.helpTestNextBatch(new int[]{1, 1, 1, 1});
    }

    @Test
    public void testRequiresTransaction() throws Exception {
        ProcessorPlan[] plans = new ProcessorPlan[]{new FakeProcessorPlan(1), new FakeProcessorPlan(1){

            public Boolean requiresTransaction(boolean transactionalReads) {
                return true;
            }
        }};
        BatchedUpdatePlan plan = new BatchedUpdatePlan(Arrays.asList(plans), plans.length, null, true);
        Assert.assertTrue((boolean)plan.requiresTransaction(false));
    }

    @Test
    public void testCommandLevelTransaction() throws Exception {
        int i;
        CommandContext context = new CommandContext((Object)"pID", null, null, null, (Object)1);
        context.setMetadata((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TransactionContext tc = new TransactionContext();
        TransactionService ts = (TransactionService)Mockito.mock(TransactionService.class);
        context.setTransactionService(ts);
        context.setTransactionContext(tc);
        ProcessorPlan[] plans = new ProcessorPlan[4];
        for (i = 0; i < plans.length - 2; ++i) {
            plans[i] = new FakeProcessorPlan(1);
        }
        for (i = 2; i < plans.length; ++i) {
            plans[i] = new FakeProcessorPlan(1){

                public Boolean requiresTransaction(boolean transactionalReads) {
                    return true;
                }
            };
        }
        BatchedUpdatePlan plan = new BatchedUpdatePlan(Arrays.asList(plans), plans.length, null, false);
        plan.requiresTransaction(false);
        plan.initialize(context, null, null);
        plan.open();
        TupleBatch batch = plan.nextBatch();
        Assert.assertEquals((long)4L, (long)batch.getRowCount());
        ((TransactionService)Mockito.verify((Object)ts, (VerificationMode)Mockito.times((int)2))).begin(tc);
        ((TransactionService)Mockito.verify((Object)ts, (VerificationMode)Mockito.times((int)2))).commit(tc);
    }
}

