/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.RuleAssignOutputElements;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RuleMergeCriteria;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.optimizer.relational.rules.RulePushAggregates;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleMergeVirtual
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean beforeDecomposeJoin = rules.contains(RuleConstants.DECOMPOSE_JOIN);
        for (PlanNode sourceNode : NodeEditor.findAllNodes(plan, 64)) {
            if (sourceNode.getChildCount() <= 0) continue;
            plan = RuleMergeVirtual.doMerge(sourceNode, plan, beforeDecomposeJoin, metadata, capFinder);
        }
        return plan;
    }

    static PlanNode doMerge(PlanNode frame, PlanNode root, boolean beforeDecomposeJoin, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        if (frame.hasBooleanProperty(NodeConstants.Info.NO_UNNEST)) {
            return root;
        }
        GroupSymbol virtualGroup = frame.getGroups().iterator().next();
        if (virtualGroup.isProcedure()) {
            return root;
        }
        List<PlanNode> sources = NodeEditor.findAllNodes(frame.getFirstChild(), 64, 64);
        SymbolMap references = (SymbolMap)frame.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
        if (references != null && !sources.isEmpty()) {
            return root;
        }
        PlanNode parentProject = NodeEditor.findParent(frame, 8);
        if (parentProject.getProperty(NodeConstants.Info.INTO_GROUP) != null) {
            return root;
        }
        if (!FrameUtil.canConvertAccessPatterns(frame)) {
            return root;
        }
        PlanNode projectNode = frame.getFirstChild();
        if (FrameUtil.isProcedure(projectNode)) {
            return root;
        }
        SymbolMap symbolMap = (SymbolMap)frame.getProperty(NodeConstants.Info.SYMBOL_MAP);
        PlanNode sortNode = NodeEditor.findParent(parentProject, 32, 64);
        if (sortNode != null && sortNode.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT)) {
            OrderBy sortOrder = (OrderBy)sortNode.getProperty(NodeConstants.Info.SORT_ORDER);
            boolean unrelated = false;
            for (OrderByItem item : sortOrder.getOrderByItems()) {
                if (!item.isUnrelated()) continue;
                Collection<ElementSymbol> collection = ElementCollectorVisitor.getElements((LanguageObject)item.getSymbol(), true);
                for (ElementSymbol elementSymbol : collection) {
                    if (!virtualGroup.equals(elementSymbol.getGroupSymbol())) continue;
                    unrelated = true;
                }
            }
            if (unrelated && NodeEditor.findNodePreOrder(frame, 2, 8) != null || NodeEditor.findNodePreOrder(frame, 256, 64) != null || NodeEditor.findNodePreOrder(frame, 128, 64) != null) {
                return root;
            }
        }
        PlanNode parentJoin = NodeEditor.findParent(frame, 4, 192);
        if (projectNode.getType() != 8 || NodeEditor.findNodePreOrder(frame.getFirstChild(), 128, 68) != null || sources.isEmpty()) {
            PlanNode parentSource = NodeEditor.findParent(parentProject, 64);
            if (beforeDecomposeJoin && parentSource != null && parentSource.hasProperty(NodeConstants.Info.PARTITION_INFO) && !NodeEditor.findAllNodes(frame.getFirstChild(), 256, 64).isEmpty()) {
                return root;
            }
            root = RuleMergeVirtual.checkForSimpleProjection(frame, root, parentProject, metadata, capFinder);
            if (frame.getParent() == null || !sources.isEmpty() || projectNode.getType() != 8 || parentJoin == null) {
                return root;
            }
            if (sources.isEmpty() && parentJoin != null) {
                JoinType jt = (JoinType)parentJoin.getProperty(NodeConstants.Info.JOIN_TYPE);
                if (jt.isOuter()) {
                    return root;
                }
                Object joinToTest = parentJoin;
                while (joinToTest != null) {
                    if (FrameUtil.findJoinSourceNode(((PlanNode)joinToTest).getFirstChild()).getGroups().contains(virtualGroup)) {
                        for (PlanNode node : NodeEditor.findAllNodes(((PlanNode)joinToTest).getLastChild(), 64, 64)) {
                            SymbolMap map = (SymbolMap)node.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
                            if (map == null || !GroupsUsedByElementsVisitor.getGroups(map.getValues()).contains(virtualGroup)) continue;
                            return root;
                        }
                    }
                    joinToTest = NodeEditor.findParent((PlanNode)joinToTest, 4, 192);
                }
            }
        }
        if (!RuleMergeVirtual.checkJoinCriteria(frame.getFirstChild(), virtualGroup, parentJoin)) {
            return root;
        }
        if (!RuleMergeVirtual.checkProjectedSymbols(projectNode, virtualGroup, parentJoin, metadata, sources, !sources.isEmpty() || frame.getParent() != parentJoin)) {
            return root;
        }
        Set<GroupSymbol> groups = Collections.emptySet();
        if (!sources.isEmpty()) {
            groups = FrameUtil.findJoinSourceNode(projectNode).getGroups();
        } else if (references != null) {
            RuleMergeCriteria.ReferenceReplacementVisitor rrv = new RuleMergeCriteria.ReferenceReplacementVisitor(references);
            for (Map.Entry entry : symbolMap.asUpdatableMap().entrySet()) {
                if (entry.getValue() instanceof Reference) {
                    Expression ex = references.getMappedExpression(((Reference)entry.getValue()).getExpression());
                    if (ex == null) continue;
                    entry.setValue(ex);
                    continue;
                }
                PreOrPostOrderNavigator.doVisit((LanguageObject)entry.getValue(), rrv, true);
            }
        }
        FrameUtil.convertFrame(frame, virtualGroup, groups, symbolMap.asMap(), metadata);
        PlanNode parentBottom = frame.getParent();
        RuleMergeVirtual.prepareFrame(frame);
        if (sources.isEmpty() && parentJoin != null) {
            PlanNode parent = frame;
            ArrayList<PlanNode> arrayList = new ArrayList<PlanNode>();
            while (parent.getParent() != parentJoin) {
                if ((parent = parent.getParent()).hasBooleanProperty(NodeConstants.Info.IS_PHANTOM)) continue;
                arrayList.add(parent);
            }
            PlanNode parentNode = parentJoin.getParent();
            parentJoin.removeChild(parent);
            PlanNode other = parentJoin.getFirstChild();
            NodeEditor.removeChildNode(parentNode, parentJoin);
            JoinType jt = (JoinType)parentJoin.getProperty(NodeConstants.Info.JOIN_TYPE);
            if (!jt.isOuter()) {
                List joinCriteria = (List)parentJoin.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                if (joinCriteria != null) {
                    for (Criteria crit : joinCriteria) {
                        PlanNode critNode = RelationalPlanner.createSelectNode(crit, false);
                        arrayList.add(critNode);
                    }
                }
                if (!arrayList.isEmpty()) {
                    for (PlanNode selectNode : arrayList) {
                        selectNode.removeAllChildren();
                        selectNode.removeFromParent();
                        other.addAsParent(selectNode);
                    }
                }
            }
        } else {
            NodeEditor.removeChildNode(parentBottom, frame);
            NodeEditor.removeChildNode(parentBottom, projectNode);
        }
        return root;
    }

    private static void prepareFrame(PlanNode frame) {
        PlanNode newRoot = FrameUtil.findJoinSourceNode(frame.getFirstChild());
        if (newRoot != null) {
            Collection ap = (Collection)frame.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
            if (ap != null) {
                Collection newAp = (Collection)newRoot.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
                if (newAp == null) {
                    newRoot.setProperty(NodeConstants.Info.ACCESS_PATTERNS, ap);
                } else {
                    newAp.addAll(ap);
                }
            }
            RulePlaceAccess.copyProperties(frame, newRoot);
        }
    }

    private static PlanNode checkForSimpleProjection(PlanNode frame, PlanNode root, PlanNode parentProject, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        PlanNode nodeToCheck;
        for (nodeToCheck = parentProject.getFirstChild(); nodeToCheck != frame; nodeToCheck = nodeToCheck.getFirstChild()) {
            if (nodeToCheck.getType() == 16 && nodeToCheck.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM)) continue;
            return root;
        }
        if (frame.getFirstChild().getType() == 1024 && NodeEditor.findParent(parentProject, 34, 320) != null) {
            return root;
        }
        List<? extends Expression> requiredElements = RuleAssignOutputElements.determineSourceOutput(frame, new ArrayList<Expression>(), metadata, null);
        List selectSymbols = (List)parentProject.getProperty(NodeConstants.Info.PROJECT_COLS);
        LinkedHashSet<Expression> symbols = new LinkedHashSet<Expression>();
        for (Expression symbol : selectSymbols) {
            Expression expr = SymbolMap.getExpression(symbol);
            if (expr instanceof Constant) {
                if (symbols.add(new ExpressionSymbol("const" + symbols.size(), expr))) continue;
                return root;
            }
            if (!(expr instanceof ElementSymbol)) {
                return root;
            }
            requiredElements.remove(expr);
            if (symbols.add(expr)) continue;
            return root;
        }
        if (!requiredElements.isEmpty()) {
            return root;
        }
        PlanNode sort = NodeEditor.findParent(parentProject, 32, 64);
        if (sort != null && sort.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT)) {
            return root;
        }
        RuleAssignOutputElements.filterVirtualElements(frame, new ArrayList<Expression>(symbols), metadata);
        for (nodeToCheck = parentProject.getFirstChild(); nodeToCheck != frame; nodeToCheck = nodeToCheck.getFirstChild()) {
            PlanNode current = nodeToCheck;
            NodeEditor.removeChildNode(current.getParent(), current);
        }
        if (NodeEditor.findParent(parentProject, 2, 64) != null) {
            PlanNode setOp;
            PlanNode lowerDup = NodeEditor.findNodePreOrder(frame.getFirstChild(), 2, 8);
            if (lowerDup != null) {
                NodeEditor.removeChildNode(lowerDup.getParent(), lowerDup);
            }
            if ((setOp = NodeEditor.findNodePreOrder(frame.getFirstChild(), 256, 64)) != null) {
                setOp.setProperty(NodeConstants.Info.USE_ALL, Boolean.FALSE);
                RuleMergeVirtual.distributeDupRemove(metadata, capFinder, setOp);
                if (parentProject.getParent().getParent() != null) {
                    NodeEditor.removeChildNode(parentProject.getParent().getParent(), parentProject.getParent());
                } else {
                    parentProject.removeFromParent();
                    root = parentProject;
                }
            }
        }
        RuleMergeVirtual.correctOrderBy(frame, sort, selectSymbols, parentProject);
        PlanNode parentSource = NodeEditor.findParent(frame, 64);
        if (parentSource != null && NodeEditor.findNodePreOrder(parentSource, 8) == parentProject) {
            FrameUtil.correctSymbolMap(((SymbolMap)frame.getProperty(NodeConstants.Info.SYMBOL_MAP)).asMap(), parentSource);
        }
        RuleMergeVirtual.prepareFrame(frame);
        NodeEditor.removeChildNode(parentProject, frame);
        if (parentProject.getParent() == null) {
            root = parentProject.getFirstChild();
            parentProject.removeChild(root);
            return root;
        }
        NodeEditor.removeChildNode(parentProject.getParent(), parentProject);
        return root;
    }

    private static void correctOrderBy(PlanNode frame, PlanNode sort, List<Expression> selectSymbols, PlanNode parentProject) {
        if (sort == null || NodeEditor.findNodePreOrder(sort, 8, 64) != parentProject) {
            return;
        }
        List childProject = (List)NodeEditor.findNodePreOrder(frame, 8).getProperty(NodeConstants.Info.PROJECT_COLS);
        OrderBy elements = (OrderBy)sort.getProperty(NodeConstants.Info.SORT_ORDER);
        for (OrderByItem item : elements.getOrderByItems()) {
            item.setSymbol((Expression)childProject.get(selectSymbols.indexOf(item.getSymbol())));
        }
        sort.getGroups().clear();
        sort.addGroups(GroupsUsedByElementsVisitor.getGroups(elements));
    }

    private static boolean checkProjectedSymbols(PlanNode projectNode, GroupSymbol virtualGroup, PlanNode parentJoin, QueryMetadataInterface metadata, List<PlanNode> sources, boolean checkForNullDependent) {
        if (projectNode.hasBooleanProperty(NodeConstants.Info.HAS_WINDOW_FUNCTIONS)) {
            return false;
        }
        List selectSymbols = (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        for (PlanNode sourceNode : sources) {
            groups.addAll(sourceNode.getGroups());
        }
        return RuleMergeVirtual.checkProjectedSymbols(virtualGroup, parentJoin, metadata, selectSymbols, groups, checkForNullDependent);
    }

    static boolean checkProjectedSymbols(GroupSymbol virtualGroup, PlanNode parentJoin, QueryMetadataInterface metadata, List<? extends Expression> selectSymbols, Set<GroupSymbol> groups, boolean checkForNullDependent) {
        if (checkForNullDependent) {
            checkForNullDependent = false;
            if (parentJoin != null) {
                PlanNode joinToTest = parentJoin;
                while (joinToTest != null) {
                    JoinType joinType = (JoinType)joinToTest.getProperty(NodeConstants.Info.JOIN_TYPE);
                    if (joinType == JoinType.JOIN_FULL_OUTER) {
                        checkForNullDependent = true;
                        break;
                    }
                    if (joinType == JoinType.JOIN_LEFT_OUTER && FrameUtil.findJoinSourceNode(joinToTest.getLastChild()).getGroups().contains(virtualGroup)) {
                        checkForNullDependent = true;
                        break;
                    }
                    joinToTest = NodeEditor.findParent(joinToTest.getParent(), 4, 64);
                }
            }
        }
        for (int i = 0; i < selectSymbols.size(); ++i) {
            Expression symbol = selectSymbols.get(i);
            List<SubqueryContainer<?>> scalarSubqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(symbol);
            if (!scalarSubqueries.isEmpty()) {
                return false;
            }
            if (checkForNullDependent && JoinUtil.isNullDependent(metadata, groups, SymbolMap.getExpression(symbol))) {
                return false;
            }
            if (!FunctionCollectorVisitor.isNonDeterministic(symbol)) continue;
            return false;
        }
        return true;
    }

    static boolean checkJoinCriteria(PlanNode frameRoot, GroupSymbol virtualGroup, PlanNode parentJoin) {
        if (parentJoin != null) {
            List<PlanNode> selectNodes = NodeEditor.findAllNodes(frameRoot, 16, 64);
            HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
            groups.add(virtualGroup);
            for (PlanNode selectNode : selectNodes) {
                JoinType jt;
                if (selectNode.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM) || (jt = JoinUtil.getJoinTypePreventingCriteriaOptimization(parentJoin, groups)) == null || jt != JoinType.JOIN_FULL_OUTER && selectNode.getGroups().size() != 0) continue;
                return false;
            }
        }
        return true;
    }

    static void distributeDupRemove(QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, PlanNode unionNode) throws QueryMetadataException, TeiidComponentException {
        Object mid;
        PlanNode unionParentSource = NodeEditor.findParent(unionNode, 320);
        if (unionNode.hasBooleanProperty(NodeConstants.Info.USE_ALL) || unionParentSource == null || unionParentSource.getType() != 64 || !unionParentSource.hasProperty(NodeConstants.Info.PARTITION_INFO)) {
            return;
        }
        PlanNode accessNode = NodeEditor.findParent(unionNode, 1);
        if (accessNode != null && !CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, mid = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata), metadata, capabilitiesFinder)) {
            return;
        }
        LinkedList<PlanNode> unionChildren = new LinkedList<PlanNode>();
        RulePushAggregates.findUnionChildren(unionChildren, false, unionNode);
        unionNode.setProperty(NodeConstants.Info.USE_ALL, true);
        for (PlanNode node : unionChildren) {
            if (node.getType() == 256) {
                node.setProperty(NodeConstants.Info.USE_ALL, false);
                continue;
            }
            PlanNode projectNode = NodeEditor.findNodePreOrder(node, 10, 64);
            if (projectNode == null || projectNode.getType() != 8) continue;
            accessNode = NodeEditor.findParent(projectNode, 1);
            PlanNode dup = NodeFactory.getNewNode(2);
            if (accessNode == null) {
                projectNode.addAsParent(dup);
                continue;
            }
            Object mid2 = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
            if (CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, mid2, metadata, capabilitiesFinder)) {
                projectNode.addAsParent(dup);
                continue;
            }
            accessNode.addAsParent(dup);
        }
    }

    public String toString() {
        return "MergeVirtual";
    }
}

