/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.teiid.client.xa.XATransactionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.util.CommandContext;

public class ForEachRowPlan
extends ProcessorPlan {
    private ProcessorPlan queryPlan;
    private ProcedurePlan rowProcedure;
    private Map<ElementSymbol, Expression> params;
    private Map<Expression, Integer> lookupMap;
    private boolean singleRow;
    private ProcessorDataManager dataMgr;
    private BufferManager bufferMgr;
    private QueryProcessor queryProcessor;
    private TupleSource tupleSource;
    private QueryProcessor rowProcessor;
    private List<?> currentTuple;
    private long updateCount;
    private TransactionContext planContext;
    private List<?> nextTuple;
    private boolean first = true;
    private boolean nextNull = false;

    @Override
    public ProcessorPlan clone() {
        ForEachRowPlan clone = new ForEachRowPlan();
        clone.setQueryPlan(this.queryPlan.clone());
        clone.setRowProcedure((ProcedurePlan)this.rowProcedure.clone());
        clone.setParams(this.params);
        clone.setLookupMap(this.lookupMap);
        return clone;
    }

    @Override
    public void close() throws TeiidComponentException {
        if (this.queryProcessor != null) {
            this.queryProcessor.closeProcessing();
            if (this.rowProcessor != null) {
                this.rowProcessor.closeProcessing();
            }
        }
        if (this.planContext != null) {
            TransactionService ts = this.getContext().getTransactionServer();
            try {
                ts.resume(this.planContext);
                ts.rollback(this.planContext);
                this.planContext = null;
            }
            catch (XATransactionException e) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30165, (Throwable)e);
            }
        }
    }

    @Override
    public List<Expression> getOutputElements() {
        return Command.getUpdateCommandSymbol();
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.setContext(context);
        this.dataMgr = dataMgr;
        this.bufferMgr = bufferMgr;
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.planContext != null) {
            this.getContext().getTransactionServer().resume(this.planContext);
        }
        try {
            while (true) {
                if (this.currentTuple == null) {
                    if (this.nextTuple != null) {
                        this.currentTuple = this.nextTuple;
                    } else if (!this.nextNull) {
                        this.currentTuple = this.tupleSource.nextTuple();
                    }
                    if (this.currentTuple == null) {
                        if (this.planContext != null) {
                            TransactionService ts = this.getContext().getTransactionServer();
                            ts.commit(this.planContext);
                            this.planContext = null;
                        }
                        TupleBatch result = new TupleBatch(1L, new List[]{Arrays.asList((int)Math.min(Integer.MAX_VALUE, this.updateCount))});
                        result.setTerminationFlag(true);
                        TupleBatch tupleBatch = result;
                        return tupleBatch;
                    }
                }
                if (this.first) {
                    TransactionContext tc = this.getContext().getTransactionContext();
                    if (this.planContext == null && tc != null && tc.getTransactionType() == TransactionContext.Scope.NONE) {
                        Boolean txnRequired = this.rowProcedure.requiresTransaction(false);
                        boolean start = false;
                        if (txnRequired == null) {
                            this.nextTuple = this.tupleSource.nextTuple();
                            if (this.nextTuple != null) {
                                start = true;
                            } else {
                                this.nextNull = true;
                            }
                        } else if (Boolean.TRUE.equals(txnRequired)) {
                            start = true;
                        }
                        if (start) {
                            this.getContext().getTransactionServer().begin(tc);
                            this.planContext = tc;
                        }
                    }
                    this.first = false;
                }
                if (this.rowProcessor == null) {
                    this.rowProcedure.reset();
                    CommandContext context = this.getContext().clone();
                    this.rowProcessor = new QueryProcessor(this.rowProcedure, context, this.bufferMgr, this.dataMgr);
                    Evaluator eval = new Evaluator(this.lookupMap, this.dataMgr, context);
                    for (Map.Entry<ElementSymbol, Expression> entry : this.params.entrySet()) {
                        Integer index = this.lookupMap.get(entry.getValue());
                        if (index != null) {
                            this.rowProcedure.getCurrentVariableContext().setValue(entry.getKey(), this.currentTuple.get(index));
                            continue;
                        }
                        this.rowProcedure.getCurrentVariableContext().setValue(entry.getKey(), eval.evaluate(entry.getValue(), this.currentTuple));
                    }
                }
                this.rowProcessor.nextBatch();
                this.rowProcessor.closeProcessing();
                this.rowProcessor = null;
                this.currentTuple = null;
                ++this.updateCount;
            }
        }
        finally {
            if (this.planContext != null) {
                this.getContext().getTransactionServer().suspend(this.planContext);
            }
        }
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        TransactionContext tc = this.getContext().getTransactionContext();
        if (tc != null && tc.getTransactionType() == TransactionContext.Scope.NONE && this.queryPlan != null && !Boolean.FALSE.equals(this.queryPlan.requiresTransaction(false))) {
            this.getContext().getTransactionServer().begin(tc);
            this.planContext = tc;
        }
        if (this.queryPlan != null) {
            this.queryProcessor = new QueryProcessor(this.queryPlan, this.getContext().clone(), this.bufferMgr, this.dataMgr);
            this.tupleSource = new BatchCollector.BatchProducerTupleSource(this.queryProcessor);
        }
    }

    public void setQueryPlan(ProcessorPlan queryPlan) {
        this.queryPlan = queryPlan;
    }

    public void setRowProcedure(ProcedurePlan rowProcedure) {
        this.rowProcedure = rowProcedure;
    }

    public void setParams(Map<ElementSymbol, Expression> params) {
        this.params = params;
    }

    public void setLookupMap(Map<Expression, Integer> symbolMap) {
        this.lookupMap = symbolMap;
    }

    @Override
    public void reset() {
        super.reset();
        this.queryPlan.reset();
        this.updateCount = 0L;
        this.currentTuple = null;
        this.rowProcessor = null;
        this.queryProcessor = null;
        this.tupleSource = null;
        this.planContext = null;
        this.first = true;
        this.nextTuple = null;
        this.nextNull = false;
    }

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        Boolean requiresTxn = this.queryPlan.requiresTransaction(transactionalReads);
        if (!Boolean.FALSE.equals(requiresTxn)) {
            return true;
        }
        Boolean forEach = this.rowProcedure.requiresTransaction(transactionalReads);
        if (Boolean.TRUE.equals(forEach)) {
            return true;
        }
        if (forEach == null) {
            if (!this.singleRow) {
                return true;
            }
            return null;
        }
        return false;
    }

    public String toString() {
        StringBuilder val = new StringBuilder("ForEach ");
        val.append(this.queryPlan).append("\n{\n");
        val.append(this.rowProcedure);
        val.append("}\n");
        return val.toString();
    }

    public void setTupleSource(TupleSource tupleSource) {
        this.tupleSource = tupleSource;
    }

    public void setSingleRow(boolean singleRow) {
        this.singleRow = singleRow;
    }
}

