/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.List;
import java.util.Map;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.JoinStrategy;
import org.teiid.query.processor.relational.SourceState;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.SymbolMap;

public class NestedTableJoinStrategy
extends JoinStrategy {
    private SymbolMap rightMap;
    private Evaluator eval;
    private boolean outerMatched;

    @Override
    public NestedTableJoinStrategy clone() {
        NestedTableJoinStrategy clone = new NestedTableJoinStrategy();
        clone.rightMap = this.rightMap;
        return clone;
    }

    @Override
    public void initialize(JoinNode joinNode) {
        super.initialize(joinNode);
        this.eval = new Evaluator(null, joinNode.getDataManager(), joinNode.getContext());
    }

    public void setRightMap(SymbolMap rightMap) {
        this.rightMap = rightMap;
    }

    @Override
    protected void openRight() throws TeiidComponentException, TeiidProcessingException {
        if (this.rightMap == null) {
            super.openRight();
            this.rightSource.setImplicitBuffer(SourceState.ImplicitBuffer.FULL);
        }
    }

    @Override
    protected void process() throws TeiidComponentException, TeiidProcessingException {
        IndexedTupleSource its = this.leftSource.getIterator();
        while (its.hasNext() || this.leftSource.getCurrentTuple() != null) {
            List leftTuple = this.leftSource.getCurrentTuple();
            if (leftTuple == null) {
                leftTuple = this.leftSource.saveNext();
            }
            this.updateContext(leftTuple, this.leftSource.getSource().getElements());
            if (this.rightMap != null && !this.rightSource.open) {
                for (Map.Entry<ElementSymbol, Expression> entry : this.rightMap.asMap().entrySet()) {
                    this.joinNode.getContext().getVariableContext().setValue(entry.getKey(), this.eval.evaluate(entry.getValue(), null));
                }
                this.rightSource.getSource().reset();
                super.openRight();
            }
            IndexedTupleSource right = this.rightSource.getIterator();
            while (right.hasNext() || this.rightSource.getCurrentTuple() != null) {
                List rightTuple = this.rightSource.getCurrentTuple();
                if (rightTuple == null) {
                    rightTuple = this.rightSource.saveNext();
                }
                List outputTuple = this.outputTuple(this.leftSource.getCurrentTuple(), this.rightSource.getCurrentTuple());
                boolean matches = this.joinNode.matchesCriteria(outputTuple);
                this.rightSource.saveNext();
                if (!matches) continue;
                this.outerMatched = true;
                this.joinNode.addBatchRow(outputTuple);
            }
            if (!this.outerMatched && this.joinNode.getJoinType() == JoinType.JOIN_LEFT_OUTER) {
                this.joinNode.addBatchRow(this.outputTuple(this.leftSource.getCurrentTuple(), this.rightSource.getOuterVals()));
            }
            this.outerMatched = false;
            if (this.rightMap == null) {
                this.rightSource.getIterator().setPosition(1L);
            } else {
                this.rightSource.close();
                for (Map.Entry<ElementSymbol, Expression> entry : this.rightMap.asMap().entrySet()) {
                    this.joinNode.getContext().getVariableContext().remove(entry.getKey());
                }
            }
            this.leftSource.saveNext();
            this.updateContext(null, this.leftSource.getSource().getElements());
        }
    }

    private void updateContext(List<?> tuple, List<? extends Expression> elements) {
        for (int i = 0; i < elements.size(); ++i) {
            Expression element = elements.get(i);
            if (!(element instanceof ElementSymbol)) continue;
            if (tuple == null) {
                this.joinNode.getContext().getVariableContext().remove((ElementSymbol)element);
                continue;
            }
            this.joinNode.getContext().getVariableContext().setValue((ElementSymbol)element, tuple.get(i));
        }
    }

    public String toString() {
        return "NESTED TABLE JOIN";
    }
}

