/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.dqp.internal.datamgr.TestDeleteImpl;
import org.teiid.dqp.internal.datamgr.TestInsertImpl;
import org.teiid.dqp.internal.datamgr.TestUpdateImpl;
import org.teiid.dqp.internal.datamgr.TstLanguageBridgeFactory;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.Delete;
import org.teiid.language.Insert;
import org.teiid.language.Update;
import org.teiid.query.sql.lang.BatchedUpdateCommand;

public class TestBatchedUpdatesImpl {
    public static BatchedUpdateCommand helpExample() {
        ArrayList<Object> updates = new ArrayList<Object>();
        updates.add(TestInsertImpl.helpExample("a.b"));
        updates.add(TestUpdateImpl.helpExample());
        updates.add(TestDeleteImpl.helpExample());
        return new BatchedUpdateCommand(updates);
    }

    public static BatchedUpdates example() throws Exception {
        return TstLanguageBridgeFactory.factory.translate(TestBatchedUpdatesImpl.helpExample());
    }

    @Test
    public void testGetUpdateCommands() throws Exception {
        List updates = TestBatchedUpdatesImpl.example().getUpdateCommands();
        Assert.assertEquals((long)3L, (long)updates.size());
        Assert.assertTrue((boolean)(updates.get(0) instanceof Insert));
        Assert.assertTrue((boolean)(updates.get(1) instanceof Update));
        Assert.assertTrue((boolean)(updates.get(2) instanceof Delete));
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertEquals((Object)"INSERT INTO b (e1, e2, e3, e4) VALUES (1, 2, 3, 4);\nUPDATE g1 SET e1 = 1, e2 = 1, e3 = 1, e4 = 1 WHERE 1 = 1;\nDELETE FROM g1 WHERE 100 >= 200 AND 500 < 600;", (Object)TestBatchedUpdatesImpl.example().toString());
    }
}

