/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.source;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.TimeZone;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stax.StAXSource;
import net.sf.saxon.trans.XPathException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.query.util.CommandContext;

public class TestXMLSystemFunctions {
    public String getContentOfTestFile(String testFilePath) throws IOException {
        File file = UnitTestUtil.getTestDataFile((String)testFilePath);
        return ObjectConverterUtil.convertFileToString((File)file);
    }

    public String helpTestXpathValue(String xmlFilePath, String xpath, String expected) throws XPathException, TeiidProcessingException, IOException {
        String actual = this.helpGetNode(xmlFilePath, xpath);
        Assert.assertEquals((Object)expected, (Object)actual);
        return actual;
    }

    public String helpGetNode(String xmlFilePath, String xpath) throws XPathException, TeiidProcessingException, IOException {
        String xmlContent = this.getContentOfTestFile(xmlFilePath);
        return XMLSystemFunctions.xpathValue((Object)xmlContent, (String)xpath);
    }

    @Test
    public void testElement() throws Exception {
        String doc = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>";
        String xpath = "a/b/c";
        String value = XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
        Assert.assertEquals((Object)"test", (Object)value);
    }

    @Test
    public void testAttribute() throws Exception {
        String doc = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b c=\"test\"></b></a>";
        String xpath = "a/b/@c";
        String value = XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
        Assert.assertEquals((Object)"test", (Object)value);
    }

    @Test
    public void testText() throws Exception {
        String doc = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>";
        String xpath = "a/b/c/text()";
        String value = XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
        Assert.assertEquals((Object)"test", (Object)value);
    }

    @Test
    public void testNoMatch() throws Exception {
        String doc = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>";
        String xpath = "x";
        String value = XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
        Assert.assertEquals(null, (Object)value);
    }

    @Test
    public void testNoXMLHeader() throws Exception {
        String doc = "<a><b><c>test</c></b></a>";
        String xpath = "a/b/c/text()";
        String value = XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
        Assert.assertEquals((Object)"test", (Object)value);
    }

    @Test
    public void testXMLInput() throws Exception {
        XMLType doc = new XMLType((SQLXML)new SQLXMLImpl("<foo/>"));
        String xpath = "a/b/c";
        String value = XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
        Assert.assertNull((Object)value);
    }

    @Test(expected=XPathException.class)
    public void testBadXPath() throws Exception {
        String doc = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>";
        String xpath = ":BOGUS:";
        XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
    }

    @Test(expected=XPathException.class)
    public void testValidateXpath_Defect15088() throws Exception {
        String xpath = "//*[local-name()='bookName\"]";
        XMLSystemFunctions.validateXpath((String)"//*[local-name()='bookName\"]");
    }

    @Test
    public void testValidateXpath_null() throws Exception {
        XMLSystemFunctions.validateXpath(null);
    }

    @Test
    public void testValidateXpath_valid() throws Exception {
        XMLSystemFunctions.validateXpath((String)"//shipTo/@country");
    }

    @Test
    public void testGetSingleMatch_01_001() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//shipTo/@country";
        String expectedValue = "US";
        this.helpTestXpathValue("testdoc.xml", "//shipTo/@country", "US");
    }

    @Test
    public void testGetSingleMatch_01_002() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//@partNum";
        String expectedValue = "872-AA";
        this.helpTestXpathValue("testdoc.xml", "//@partNum", "872-AA");
    }

    @Test
    public void testGetSingleMatch_01_003() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//productName";
        String expectedValue = "Lawnmower";
        this.helpTestXpathValue("testdoc.xml", "//productName", "Lawnmower");
    }

    @Test
    public void testGetSingleMatch_03() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//*[local-name()=\"ReadOnly\"]";
        this.helpTestXpathValue("testdoc.xml", "//*[local-name()=\"ReadOnly\"]", "false");
    }

    @Test
    public void testGetSingleMatch_04() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//*:ReadOnly";
        this.helpTestXpathValue("testdoc.xml", "//*:ReadOnly", "false");
    }

    @Test
    public void testAtomicValueTimestamp() throws Exception {
        Assert.assertEquals((Object)"1910-04-01T07:01:02.000055Z", (Object)XMLSystemFunctions.convertToAtomicValue((Object)TimestampUtil.createTimestamp((int)10, (int)3, (int)1, (int)1, (int)1, (int)2, (int)55001)).getStringValue());
    }

    @Test
    public void testAtomicValueTime() throws Exception {
        Assert.assertEquals((Object)"16:03:01Z", (Object)XMLSystemFunctions.convertToAtomicValue((Object)TimestampUtil.createTime((int)10, (int)3, (int)1)).getStringValue());
    }

    @Test
    public void testAtomicValueDate() throws Exception {
        Assert.assertEquals((Object)"1920-03-03Z", (Object)XMLSystemFunctions.convertToAtomicValue((Object)TimestampUtil.createDate((int)20, (int)2, (int)3)).getStringValue());
    }

    @Test
    public void testNameEscaping() throws Exception {
        Assert.assertEquals((Object)"_u003A_b", (Object)XMLSystemFunctions.escapeName((String)":b", (boolean)true));
    }

    @Test
    public void testNameEscaping1() throws Exception {
        Assert.assertEquals((Object)"a_u005F_x", (Object)XMLSystemFunctions.escapeName((String)"a_x", (boolean)true));
    }

    @Test
    public void testNameEscaping2() throws Exception {
        Assert.assertEquals((Object)"_u000A_", (Object)XMLSystemFunctions.escapeName((String)new String(new char[]{'\n'}), (boolean)true));
    }

    @Test
    public void testJsonToXml() throws Exception {
        String json = "[0,{\"1\":{\"2\":{\"3\":{\"4\":[5,{\"6\":7}]}}}}]";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Array xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Array xsi:type=\"decimal\">0</Array><Array><_u0031_><_u0032_><_u0033_><_u0034_ xsi:type=\"decimal\">5</_u0034_><_u0034_><_u0036_ xsi:type=\"decimal\">7</_u0036_></_u0034_></_u0033_></_u0032_></_u0031_></Array></Array>";
        this.helpTestJson(json, "Array", expected);
    }

    private void helpTestJson(String json, String rootName, String expected) throws SQLException, TeiidComponentException, TeiidProcessingException, SerialException, IOException {
        CommandContext cc = new CommandContext();
        cc.setBufferManager(BufferManagerFactory.getStandaloneBufferManager());
        SQLXML xml = XMLSystemFunctions.jsonToXml((CommandContext)cc, (String)rootName, (Clob)new SerialClob(json.toCharArray()));
        Assert.assertEquals((Object)expected, (Object)xml.getString());
        xml = XMLSystemFunctions.jsonToXml((CommandContext)cc, (String)rootName, (Blob)new SerialBlob(json.getBytes(Charset.forName("UTF-8"))));
        Assert.assertEquals((Object)expected, (Object)xml.getString());
        xml = XMLSystemFunctions.jsonToXml((CommandContext)cc, (String)rootName, (Blob)new SerialBlob(json.getBytes(Charset.forName("UTF-32BE"))));
        Assert.assertEquals((Object)expected, (Object)xml.getString());
    }

    @Test
    public void testJsonToXml1() throws Exception {
        String json = "{ \"firstName\": \"John\", \"lastName\": \"Smith\", \"age\": 25, \"address\": { \"streetAddress\": \"21 2nd Street\", \"city\": \"New York\", \"state\": \"NY\", \"postalCode\": \"10021\" }, \"phoneNumber\": [ { \"type\": \"home\", \"number\": \"212 555-1234\" }, { \"type\": \"fax\", \"number\": \"646 555-4567\" } ] }";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><firstName>John</firstName><lastName>Smith</lastName><age xsi:type=\"decimal\">25</age><address><streetAddress>21 2nd Street</streetAddress><city>New York</city><state>NY</state><postalCode>10021</postalCode></address><phoneNumber><type>home</type><number>212 555-1234</number></phoneNumber><phoneNumber><type>fax</type><number>646 555-4567</number></phoneNumber></Person>";
        this.helpTestJson(json, "Person", expected);
    }

    @Test
    public void testJsonToXml2() throws Exception {
        String json = "{ \"firstName\": null }";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><firstName xsi:nil=\"true\"></firstName></Person>";
        this.helpTestJson(json, "Person", expected);
    }

    @Test
    public void testJsonToXml3() throws Exception {
        String json = "{ \"kids\":[{ \"firstName\" : \"George\" }, { \"firstName\" : \"Jerry\" }]}";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><kids><firstName>George</firstName></kids><kids><firstName>Jerry</firstName></kids></Person>";
        this.helpTestJson(json, "Person", expected);
    }

    @Test
    public void testJsonToXml4() throws Exception {
        String json = "{ \"kids\":[[{ \"firstName\" : \"George\" }, { \"firstName\" : \"Jerry\" }]]}";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><kids><kids><firstName>George</firstName></kids><kids><firstName>Jerry</firstName></kids></kids></Person>";
        this.helpTestJson(json, "Person", expected);
    }

    @Test
    public void testJsonToXml4a() throws Exception {
        String json = "{ \"kids\":[[{ \"firstName\" : \"George\" }], [{ \"firstName\" : \"Jerry\" }]]}";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><kids><kids><firstName>George</firstName></kids></kids><kids><kids><firstName>Jerry</firstName></kids></kids></Person>";
        this.helpTestJson(json, "Person", expected);
    }

    @Test
    public void testJsonToXml5() throws Exception {
        String json = "[[],{\"x\": 1},[]]";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Person></Person><Person><x xsi:type=\"decimal\">1</x></Person><Person></Person></Person>";
        this.helpTestJson(json, "Person", expected);
    }

    @Test
    public void testRepairingNamespaces() throws Exception {
        XMLOutputFactory factory = XMLSystemFunctions.getOutputFactory((boolean)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEventWriter writer = factory.createXMLEventWriter(baos);
        XMLEventReader reader = XMLType.getXmlInputFactory().createXMLEventReader(new StringReader("<a xmlns:x=\"http://foo\"><b x:y=\"1\"/></a>"));
        reader.nextTag();
        reader = XMLType.getXmlInputFactory().createFilteredReader(reader, new EventFilter(){

            @Override
            public boolean accept(XMLEvent arg0) {
                if (arg0.isStartDocument() || arg0.isEndDocument()) {
                    return false;
                }
                return !arg0.isEndElement() || !((EndElement)arg0).getName().getLocalPart().equals("a");
            }
        });
        writer.add(reader);
        writer.close();
        Assert.assertEquals((Object)"<b xmlns=\"\" xmlns:x=\"http://foo\" x:y=\"1\"></b>", (Object)new String(baos.toByteArray(), "UTF-8"));
    }

    @Test
    public void testJsonEvents() throws Exception {
        String json = "{ \"firstName\": null }";
        CommandContext cc = new CommandContext();
        cc.setBufferManager(BufferManagerFactory.getStandaloneBufferManager());
        SQLXML xml = XMLSystemFunctions.jsonToXml((CommandContext)cc, (String)"x", (Clob)new SerialClob(json.toCharArray()), (boolean)true);
        StAXSource source = xml.getSource(StAXSource.class);
        XMLEventReader reader = source.getXMLEventReader();
        Assert.assertTrue((boolean)reader.nextEvent().isStartDocument());
        StartElement start = reader.nextEvent().asStartElement();
        Assert.assertTrue((boolean)start.getNamespaces().hasNext());
        Assert.assertFalse((boolean)start.getAttributes().hasNext());
        start = reader.nextEvent().asStartElement();
        Assert.assertFalse((boolean)start.getNamespaces().hasNext());
        Assert.assertTrue((boolean)start.getAttributes().hasNext());
        Assert.assertTrue((boolean)reader.nextEvent().isEndElement());
        Assert.assertTrue((boolean)reader.nextEvent().isEndElement());
    }

    @BeforeClass
    public static void setUpOnce() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-6:00"));
    }

    @AfterClass
    public static void tearDownOnce() {
        TimeZone.setDefault(null);
    }
}

