/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorReport;

public class TestValidator {
    public static TransformationMetadata exampleMetadata() {
        MetadataStore metadataStore = new MetadataStore();
        Schema modelObj = RealMetadataFactory.createPhysicalModel("test", metadataStore);
        Schema vModelObj2 = RealMetadataFactory.createVirtualModel("vTest", metadataStore);
        Table groupObj = RealMetadataFactory.createPhysicalGroup("group", modelObj);
        Column elemObj0 = RealMetadataFactory.createElement("e0", groupObj, "integer");
        elemObj0.setNullType(BaseColumn.NullType.No_Nulls);
        Column elemObj1 = RealMetadataFactory.createElement("e1", groupObj, "string");
        elemObj1.setSelectable(false);
        Column elemObj2 = RealMetadataFactory.createElement("e2", groupObj, "string");
        elemObj2.setSearchType(Column.SearchType.Like_Only);
        Column elemObj3 = RealMetadataFactory.createElement("e3", groupObj, "string");
        elemObj3.setSearchType(Column.SearchType.All_Except_Like);
        Table group2Obj = RealMetadataFactory.createPhysicalGroup("group2", modelObj);
        Column elemObj2_0 = RealMetadataFactory.createElement("e0", group2Obj, "integer");
        elemObj2_0.setUpdatable(false);
        RealMetadataFactory.createElement("e1", group2Obj, "string");
        Column elemObj2_2 = RealMetadataFactory.createElement("e2", group2Obj, "string");
        elemObj2_2.setUpdatable(false);
        Table group3Obj = RealMetadataFactory.createPhysicalGroup("group3", modelObj);
        group3Obj.setSupportsUpdate(false);
        RealMetadataFactory.createElement("e0", group3Obj, "integer");
        RealMetadataFactory.createElement("e1", group3Obj, "string");
        RealMetadataFactory.createElement("e2", group3Obj, "string");
        QueryNode vNode = new QueryNode("SELECT * FROM test.group WHERE e2 = 'x'");
        Table vGroup = RealMetadataFactory.createVirtualGroup("vGroup", vModelObj2, vNode);
        RealMetadataFactory.createElements(vGroup, new String[]{"e0", "e1", "e2", "e3"}, new String[]{"integer", "string", "string", "string"});
        QueryNode vNode2 = new QueryNode("SELECT * FROM test.group");
        Table vGroup2 = RealMetadataFactory.createVirtualGroup("vMap", vModelObj2, vNode2);
        List<Column> vGroupE2 = RealMetadataFactory.createElements(vGroup2, new String[]{"e0", "e1", "e2", "e3"}, new String[]{"integer", "string", "string", "string"});
        vGroupE2.get(0).setNullType(BaseColumn.NullType.No_Nulls);
        vGroupE2.get(1).setSelectable(false);
        vGroupE2.get(2).setSearchType(Column.SearchType.Like_Only);
        vGroupE2.get(3).setSearchType(Column.SearchType.All_Except_Like);
        MappingDocument doc = new MappingDocument(false);
        MappingElement complexRoot = doc.addChildElement(new MappingElement("a0"));
        MappingElement sourceNode = complexRoot.addChildElement(new MappingElement("a1"));
        sourceNode.setSource("test.group");
        sourceNode.addChildElement(new MappingElement("a2", "test.group.e1"));
        sourceNode.addChildElement(new MappingElement("b2", "test.group.e2"));
        sourceNode.addChildElement(new MappingElement("c2", "test.group.e3"));
        Schema docModel = RealMetadataFactory.createVirtualModel("vm1", metadataStore);
        RealMetadataFactory.createXmlDocument("doc1", docModel, doc);
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "example", new FunctionTree[0]);
    }

    public TransformationMetadata exampleMetadata1() {
        MetadataStore metadataStore = new MetadataStore();
        Schema modelObj = RealMetadataFactory.createPhysicalModel("test", metadataStore);
        Table groupObj = RealMetadataFactory.createPhysicalGroup("group", modelObj);
        Column elemObj0 = RealMetadataFactory.createElement("e0", groupObj, "integer");
        Column elemObj1 = RealMetadataFactory.createElement("e1", groupObj, "string");
        Column elemObj2 = RealMetadataFactory.createElement("e2", groupObj, "string");
        RealMetadataFactory.createElement("e3", groupObj, "string");
        elemObj0.setNullType(BaseColumn.NullType.No_Nulls);
        elemObj1.setNullType(BaseColumn.NullType.Nullable);
        elemObj1.setDefaultValue(Boolean.TRUE.toString());
        elemObj2.setNullType(BaseColumn.NullType.Nullable);
        elemObj2.setDefaultValue(Boolean.FALSE.toString());
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "example1", new FunctionTree[0]);
    }

    public static TransformationMetadata exampleMetadata2() {
        MetadataStore metadataStore = new MetadataStore();
        Schema modelObj = RealMetadataFactory.createPhysicalModel("test", metadataStore);
        Table groupObj = RealMetadataFactory.createPhysicalGroup("group", modelObj);
        RealMetadataFactory.createElements(groupObj, new String[]{"e0", "e1", "e2", "e3", "e4", "e5"}, new String[]{"integer", "string", "object", "blob", "clob", "xml"});
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "example2", new FunctionTree[0]);
    }

    public static TransformationMetadata exampleMetadata3() {
        MetadataStore metadataStore = new MetadataStore();
        Schema modelObj = RealMetadataFactory.createPhysicalModel("test", metadataStore);
        Table groupObj = RealMetadataFactory.createPhysicalGroup("group", modelObj);
        RealMetadataFactory.createElement("e0", groupObj, "integer");
        Column elemObj1 = RealMetadataFactory.createElement("e1", groupObj, "string");
        elemObj1.setNullType(BaseColumn.NullType.No_Nulls);
        elemObj1.setDefaultValue(Boolean.FALSE.toString());
        elemObj1.setAutoIncremented(true);
        elemObj1.setNameInSource("e1:SEQUENCE=MYSEQUENCE.nextVal");
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "example3", new FunctionTree[0]);
    }

    public static TransformationMetadata exampleMetadata4() {
        MetadataStore metadataStore = new MetadataStore();
        Schema modelObj = RealMetadataFactory.createPhysicalModel("test", metadataStore);
        Table groupObj = RealMetadataFactory.createPhysicalGroup("group", modelObj);
        RealMetadataFactory.createElement("e0", groupObj, "integer");
        RealMetadataFactory.createElement("e1", groupObj, "string");
        RealMetadataFactory.createElement("e2", groupObj, "string");
        Schema vModelObj = RealMetadataFactory.createVirtualModel("vTest", metadataStore);
        QueryNode vNode = new QueryNode("SELECT * FROM test.group");
        Table vGroupObj = RealMetadataFactory.createVirtualGroup("vGroup", vModelObj, vNode);
        Column vElemObj0 = RealMetadataFactory.createElement("e0", vGroupObj, "integer");
        Column vElemObj1 = RealMetadataFactory.createElement("e1", vGroupObj, "string");
        RealMetadataFactory.createElement("e2", vGroupObj, "string");
        ArrayList<Object> elements = new ArrayList<Column>(2);
        elements.add(vElemObj0);
        elements.add(vElemObj1);
        RealMetadataFactory.createAccessPattern("ap1", vGroupObj, elements);
        QueryNode vNode2 = new QueryNode("SELECT * FROM vTest.vGroup");
        Table vGroupObj2 = RealMetadataFactory.createVirtualGroup("vGroup2", vModelObj, vNode2);
        Column vElemObj20 = RealMetadataFactory.createElement("e0", vGroupObj2, "integer");
        Column vElemObj21 = RealMetadataFactory.createElement("e1", vGroupObj2, "string");
        RealMetadataFactory.createElement("e2", vGroupObj2, "string");
        elements = new ArrayList(2);
        elements.add(vElemObj20);
        elements.add(vElemObj21);
        RealMetadataFactory.createAccessPattern("vTest.vGroup2.ap1", vGroupObj2, elements);
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "example4", new FunctionTree[0]);
    }

    static Command helpResolve(String sql, QueryMetadataInterface metadata) {
        Command command = null;
        try {
            command = QueryParser.getQueryParser().parseCommand(sql);
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        return command;
    }

    static Command helpResolve(String sql, GroupSymbol container, int type, QueryMetadataInterface metadata) throws QueryParserException, QueryResolverException, TeiidComponentException {
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (GroupSymbol)container, (int)type, (QueryMetadataInterface)metadata, (boolean)false);
        return command;
    }

    public static ValidatorReport helpValidate(String sql, String[] expectedStringArray, QueryMetadataInterface metadata) {
        Command command = TestValidator.helpResolve(sql, metadata);
        return TestValidator.helpRunValidator(command, expectedStringArray, metadata);
    }

    public static ValidatorReport helpRunValidator(Command command, String[] expectedStringArray, QueryMetadataInterface metadata) {
        try {
            ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
            TestValidator.examineReport(command, expectedStringArray, report);
            return report;
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private static void examineReport(Object command, String[] expectedStringArray, ValidatorReport report) {
        ArrayList actualObjs = new ArrayList();
        report.collectInvalidObjects(actualObjs);
        HashSet<String> expectedStrings = new HashSet<String>(Arrays.asList(expectedStringArray));
        HashSet<String> actualStrings = new HashSet<String>();
        for (LanguageObject obj : actualObjs) {
            actualStrings.add(SQLStringVisitor.getSQLString((LanguageObject)obj));
        }
        if (expectedStrings.size() == 0 && actualStrings.size() > 0) {
            Assert.fail((String)("Expected no failures but got some: " + report.getFailureMessage()));
        } else if (actualStrings.size() == 0 && expectedStrings.size() > 0) {
            Assert.fail((String)("Expected some failures but got none for sql = " + command));
        } else {
            Assert.assertEquals((String)"Expected and actual sets of strings are not the same: ", expectedStrings, actualStrings);
        }
    }

    private void helpValidateProcedure(String procedure, String userUpdateStr, Table.TriggerEvent procedureType) {
        TransformationMetadata metadata = RealMetadataFactory.exampleUpdateProc(procedureType, procedure);
        try {
            this.validateProcedure(userUpdateStr, (QueryMetadataInterface)metadata);
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private void validateProcedure(String userUpdateStr, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException, QueryValidatorException {
        ProcedureContainer command = (ProcedureContainer)TestValidator.helpResolve(userUpdateStr, metadata);
        Command proc = QueryResolver.expandCommand((ProcedureContainer)command, (QueryMetadataInterface)metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
        ValidatorReport report = Validator.validate((LanguageObject)proc, (QueryMetadataInterface)metadata);
        if (report.hasItems()) {
            throw new QueryValidatorException(report.getFailureMessage());
        }
        report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        if (report.hasItems()) {
            throw new QueryValidatorException(report.getFailureMessage());
        }
    }

    private void helpFailProcedure(String procedure, String userUpdateStr, Table.TriggerEvent procedureType) {
        TransformationMetadata metadata = RealMetadataFactory.exampleUpdateProc(procedureType, procedure);
        try {
            this.validateProcedure(userUpdateStr, (QueryMetadataInterface)metadata);
            Assert.fail((String)("Expected failures for " + procedure));
        }
        catch (QueryValidatorException queryValidatorException) {
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testSelectStarWhereNoElementsAreNotSelectable() {
        TestValidator.helpValidate("SELECT * FROM pm1.g5", new String[]{"SELECT * FROM pm1.g5"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateSelect1() {
        TestValidator.helpValidate("SELECT e1, e2 FROM test.group", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateSelect2() {
        TestValidator.helpValidate("SELECT e2 FROM test.group", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompare1() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap WHERE e2 = 'a'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompare4() {
        TestValidator.helpValidate("SELECT e3 FROM vTest.vMap WHERE e3 LIKE 'a'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompare6() {
        TestValidator.helpValidate("SELECT e0 FROM vTest.vMap WHERE e0 BETWEEN 1000 AND 2000", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompareInHaving2() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap GROUP BY e2 HAVING e2 IS NULL", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompareInHaving3() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap GROUP BY e2 HAVING e2 IN ('a')", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompareInHaving4() {
        TestValidator.helpValidate("SELECT e3 FROM vTest.vMap GROUP BY e3 HAVING e3 LIKE 'a'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompareInHaving5() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap GROUP BY e2 HAVING e2 BETWEEN 1000 AND 2000", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidAggregate1() {
        TestValidator.helpValidate("SELECT SUM(e3) FROM test.group GROUP BY e2", new String[]{"SUM(e3)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidAggregate2() {
        TestValidator.helpValidate("SELECT e3 FROM test.group GROUP BY e2", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidAggregate3() {
        TestValidator.helpValidate("SELECT SUM(e2) FROM test.group GROUP BY e2", new String[]{"SUM(e2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidAggregate4() {
        TestValidator.helpValidate("SELECT AVG(e2) FROM test.group GROUP BY e2", new String[]{"AVG(e2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidAggregate5() {
        TestValidator.helpValidate("SELECT e1 || 'x' frOM pm1.g1 GROUP BY e2 + 1", new String[]{"e1"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidAggregate6() {
        TestValidator.helpValidate("SELECT e2 + 1 frOM pm1.g1 GROUP BY e2 + 1 HAVING e1 || 'x' > 0", new String[]{"e1"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidAggregate7() {
        TestValidator.helpValidate("SELECT StringKey, SUM(length(StringKey || 'x')) + 1 AS x FROM BQT1.SmallA GROUP BY StringKey || 'x' HAVING space(MAX(length((StringKey || 'x') || 'y'))) = '   '", new String[]{"StringKey"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testInvalidAggregate8() {
        TestValidator.helpValidate("SELECT max(ObjectValue) FROM BQT1.SmallA GROUP BY StringKey", new String[]{"MAX(ObjectValue)"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testInvalidAggregate9() {
        TestValidator.helpValidate("SELECT count(distinct ObjectValue) FROM BQT1.SmallA GROUP BY StringKey", new String[]{"COUNT(DISTINCT ObjectValue)"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testInvalidAggregate10() {
        TestValidator.helpValidate("SELECT xmlparse(document stringkey) FROM BQT1.SmallA GROUP BY xmlparse(document stringkey)", new String[]{"XMLPARSE(DOCUMENT stringkey)"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testInvalidAggregateIssue190644() {
        TestValidator.helpValidate("SELECT e3 + 1 from pm1.g1 GROUP BY e2 + 1 HAVING e2 + 1 = 5", new String[]{"e3"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidAggregate1() {
        TestValidator.helpValidate("SELECT (e2 + 1) * 2 frOM pm1.g1 GROUP BY e2 + 1", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidAggregate2() {
        TestValidator.helpValidate("SELECT e2 + 1 frOM pm1.g1 GROUP BY e2 + 1", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidAggregate3() {
        TestValidator.helpValidate("SELECT sum (IntKey), case when IntKey>=5000 then '5000 +' else '0-999' end FROM BQT1.SmallA GROUP BY case when IntKey>=5000 then '5000 +' else '0-999' end", new String[0], (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testValidAggregate4() {
        TestValidator.helpValidate("SELECT max(e1), e2 is null from pm1.g1 GROUP BY e2 is null", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidHaving1() {
        TestValidator.helpValidate("SELECT e3 FROM test.group HAVING e3 > 0", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidHaving2() {
        TestValidator.helpValidate("SELECT e3 FROM test.group HAVING concat(e3,'a') > 0", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testNestedAggregateInHaving() {
        TestValidator.helpValidate("SELECT e0 FROM test.group GROUP BY e0 HAVING SUM(COUNT(e0)) > 0", new String[]{"COUNT(e0)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testNestedAggregateInSelect() {
        TestValidator.helpValidate("SELECT SUM(COUNT(e0)) FROM test.group GROUP BY e0", new String[]{"COUNT(e0)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCaseInGroupBy() {
        TestValidator.helpValidate("SELECT SUM(e2) FROM pm1.g1 GROUP BY CASE e2 WHEN 0 THEN 1 ELSE 2 END", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateFunctionInGroupBy() {
        TestValidator.helpValidate("SELECT SUM(e2) FROM pm1.g1 GROUP BY (e2 + 1)", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidScalarSubqueryInGroupBy() {
        TestValidator.helpValidate("SELECT COUNT(*) FROM pm1.g1 GROUP BY (SELECT 1)", new String[]{"(SELECT 1)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidConstantInGroupBy() {
        TestValidator.helpValidate("SELECT COUNT(*) FROM pm1.g1 GROUP BY 1", new String[]{"1"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidReferenceInGroupBy() {
        TestValidator.helpValidate("SELECT COUNT(*) FROM pm1.g1 GROUP BY ?", new String[]{"?"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateObjectType1() {
        TestValidator.helpValidate("SELECT DISTINCT * FROM test.group", new String[]{"test.\"group\".e2", "test.\"group\".e3", "test.\"group\".e4", "test.\"group\".e5"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateObjectType2() {
        TestValidator.helpValidate("SELECT * FROM test.group ORDER BY e1, e2", new String[]{"e2"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateObjectType3() {
        TestValidator.helpValidate("SELECT e2 AS x FROM test.group ORDER BY x", new String[]{"x"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNonComparableType() {
        TestValidator.helpValidate("SELECT e3 FROM test.group ORDER BY e3", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNonComparableType1() {
        TestValidator.helpValidate("SELECT e3 FROM test.group union SELECT e3 FROM test.group", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNonComparableType2() {
        TestValidator.helpValidate("SELECT e3 FROM test.group GROUP BY e3", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNonComparableType3() {
        TestValidator.helpValidate("SELECT e3 FROM test.group intersect SELECT e3 FROM test.group", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNonComparableType4() {
        TestValidator.helpValidate("SELECT e3 FROM test.group except SELECT e3 FROM test.group", new String[]{"e3"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateIntersectAll() {
        TestValidator.helpValidate("SELECT e3 FROM pm1.g1 intersect all SELECT e3 FROM pm1.g1", new String[]{"SELECT e3 FROM pm1.g1 INTERSECT ALL SELECT e3 FROM pm1.g1"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateSetSelectInto() {
        TestValidator.helpValidate("SELECT e3 into #temp FROM pm1.g1 intersect all SELECT e3 FROM pm1.g1", new String[]{"SELECT e3 INTO #temp FROM pm1.g1 INTERSECT ALL SELECT e3 FROM pm1.g1"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInsert1() {
        TestValidator.helpValidate("INSERT INTO test.group (e0) VALUES (null)", new String[]{"e0"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInsert4() throws Exception {
        TransformationMetadata metadata = this.exampleMetadata1();
        Command command = QueryParser.getQueryParser().parseCommand("INSERT INTO test.group (e0) VALUES (2)");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[0], (QueryMetadataInterface)metadata);
    }

    @Test
    public void testInsert5() throws Exception {
        TransformationMetadata metadata = this.exampleMetadata1();
        Command command = QueryParser.getQueryParser().parseCommand("INSERT INTO test.group (e1, e2) VALUES ('x', 'y')");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[]{"test.\"group\".e0"}, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testValidateInsertElements1() throws Exception {
        TransformationMetadata metadata = TestValidator.exampleMetadata();
        Command command = QueryParser.getQueryParser().parseCommand("INSERT INTO test.group2 (e0, e1, e2) VALUES (5, 'x', 'y')");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[]{"e2", "e0"}, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testValidateInsertElements2() throws Exception {
        TransformationMetadata metadata = TestValidator.exampleMetadata();
        Command command = QueryParser.getQueryParser().parseCommand("INSERT INTO test.group2 (e1) VALUES ('y')");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[0], (QueryMetadataInterface)metadata);
    }

    @Test
    public void testValidateInsertElements3_autoIncNotRequired() throws Exception {
        TestValidator.helpValidate("INSERT INTO test.group (e0) VALUES (1)", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata3());
    }

    @Test
    public void testUpdate1() {
        TestValidator.helpValidate("UPDATE test.group SET e0=null", new String[]{"e0"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testUpdate2() {
        TestValidator.helpValidate("UPDATE test.group SET e0=1, e0=2", new String[]{"e0"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateUpdateElements1() throws Exception {
        TransformationMetadata metadata = TestValidator.exampleMetadata();
        Command command = QueryParser.getQueryParser().parseCommand("UPDATE test.group2 SET e0 = 5, e1 = 'x', e2 = 'y'");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[]{"e2", "e0"}, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testValidateUpdateElements2() throws Exception {
        TransformationMetadata metadata = TestValidator.exampleMetadata();
        Command command = QueryParser.getQueryParser().parseCommand("UPDATE test.group2 SET e1 = 'x'");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[0], (QueryMetadataInterface)metadata);
    }

    @Test
    public void testXMLSerializeEncoding() {
        TestValidator.helpValidate("SELECT xmlserialize(? AS CLOB ENCODING \"UTF-8\")", new String[]{"XMLSERIALIZE(? AS CLOB ENCODING \"UTF-8\")"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLSerializeEncoding1() {
        TestValidator.helpValidate("SELECT xmlserialize(? AS BLOB ENCODING \"UTF-8\" INCLUDING XMLDECLARATION)", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLSerializeEncoding2() {
        TestValidator.helpValidate("SELECT xmlserialize(? AS BLOB ENCODING \"UTF-75\" INCLUDING XMLDECLARATION)", new String[]{"XMLSERIALIZE(? AS BLOB ENCODING \"UTF-75\" INCLUDING XMLDECLARATION)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLQuery1() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQuery2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where a2='x'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQuery3() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 order by a2", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQuery6() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 UNION SELECT * FROM vm1.doc1", new String[]{"\"xml\"", "SELECT * FROM vm1.doc1 UNION SELECT * FROM vm1.doc1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryWithLimit() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 limit 1", new String[]{"SELECT * FROM vm1.doc1 LIMIT 1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where 2 = RowLimit(a2)", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit1() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimit(a2)=-1", new String[]{"RowLimit(a2) = -1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimit(a2)='x'", new String[]{"RowLimit(a2) = 'x'"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitNested() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimit(a2)=a2", new String[]{"RowLimit(a2) = a2"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitNested2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where convert(RowLimit(a2), string)=a2", new String[]{"convert(RowLimit(a2), string) = a2"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit3a() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimit(a2) = convert(a2, integer)", new String[]{"RowLimit(a2) = convert(a2, integer)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit3b() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where convert(a2, integer) = RowLimit(a2)", new String[]{"convert(a2, integer) = RowLimit(a2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit4() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit('x') = 3", new String[]{"rowlimit('x')"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimit5() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(concat(a2, 'x')) = 3", new String[]{"rowlimit(concat(a2, 'x'))"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitConjunct() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = 3 OR a2 = 'x'", new String[]{"(rowlimit(a2) = 3) OR (a2 = 'x')"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitCompound() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = 3 AND a2 = 'x'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitCompound2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = 3 AND concat(a2, 'y') = 'xy'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitCompound3() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = 3 AND (concat(a2, 'y') = 'xy' OR concat(a2, 'y') = 'zy')", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitCompound4() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = 3 AND rowlimit(c2) = 4", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitCompound5() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = 3 AND rowlimit(a2) = 4", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where not(rowlimit(a2) = 3)", new String[]{"NOT (rowlimit(a2) = 3)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) IN (3)", new String[]{"rowlimit(a2) IN (3)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria3() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) LIKE 'x'", new String[]{"rowlimit(a2) LIKE 'x'"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria4() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) IS NULL", new String[]{"rowlimit(a2) IS NULL"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria5() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) IN (SELECT e0 FROM vTest.vMap)", new String[]{"rowlimit(a2) IN (SELECT e0 FROM vTest.vMap)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria6() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where 2 = CASE WHEN rowlimit(a2) = 2 THEN 2 END", new String[]{"2 = CASE WHEN rowlimit(a2) = 2 THEN 2 END"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria6a() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where 2 = CASE rowlimit(a2) WHEN 2 THEN 2 END", new String[]{"2 = CASE rowlimit(a2) WHEN 2 THEN 2 END"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria7() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) BETWEEN 2 AND 3", new String[]{"rowlimit(a2) BETWEEN 2 AND 3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitInvalidCriteria8() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimit(a2) = ANY (SELECT e0 FROM vTest.vMap)", new String[]{"rowlimit(a2) = ANY (SELECT e0 FROM vTest.vMap)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testNonXMLQueryRowLimit() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap WHERE rowlimit(e1) = 2", new String[]{"rowlimit(e1)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where 2 = RowLimitException(a2)", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException1() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimitException(a2)=-1", new String[]{"RowLimitException(a2) = -1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimitException(a2)='x'", new String[]{"RowLimitException(a2) = 'x'"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionNested() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimitException(a2)=a2", new String[]{"RowLimitException(a2) = a2"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionNested2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where convert(RowLimitException(a2), string)=a2", new String[]{"convert(RowLimitException(a2), string) = a2"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException3a() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where RowLimitException(a2) = convert(a2, integer)", new String[]{"RowLimitException(a2) = convert(a2, integer)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException3b() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where convert(a2, integer) = RowLimitException(a2)", new String[]{"convert(a2, integer) = RowLimitException(a2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException4() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception('x') = 3", new String[]{"rowlimitexception('x')"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitException5() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(concat(a2, 'x')) = 3", new String[]{"rowlimitexception(concat(a2, 'x'))"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionConjunct() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = 3 OR a2 = 'x'", new String[]{"(rowlimitexception(a2) = 3) OR (a2 = 'x')"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionCompound() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = 3 AND a2 = 'x'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionCompound2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = 3 AND concat(a2, 'y') = 'xy'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionCompound3() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = 3 AND (concat(a2, 'y') = 'xy' OR concat(a2, 'y') = 'zy')", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionCompound4() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = 3 AND rowlimitexception(c2) = 4", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionCompound5() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = 3 AND rowlimitexception(a2) = 4", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where not(rowlimitexception(a2) = 3)", new String[]{"NOT (rowlimitexception(a2) = 3)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria2() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) IN (3)", new String[]{"rowlimitexception(a2) IN (3)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria3() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) LIKE 'x'", new String[]{"rowlimitexception(a2) LIKE 'x'"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria4() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) IS NULL", new String[]{"rowlimitexception(a2) IS NULL"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria5() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) IN (SELECT e0 FROM vTest.vMap)", new String[]{"rowlimitexception(a2) IN (SELECT e0 FROM vTest.vMap)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria6() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where 2 = CASE WHEN rowlimitexception(a2) = 2 THEN 2 END", new String[]{"2 = CASE WHEN rowlimitexception(a2) = 2 THEN 2 END"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria6a() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where 2 = CASE rowlimitexception(a2) WHEN 2 THEN 2 END", new String[]{"2 = CASE rowlimitexception(a2) WHEN 2 THEN 2 END"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria7() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) BETWEEN 2 AND 3", new String[]{"rowlimitexception(a2) BETWEEN 2 AND 3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testXMLQueryRowLimitExceptionInvalidCriteria8() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where rowlimitexception(a2) = ANY (SELECT e0 FROM vTest.vMap)", new String[]{"rowlimitexception(a2) = ANY (SELECT e0 FROM vTest.vMap)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testNonXMLQueryRowLimitException() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap WHERE rowlimitexception(e1) = 2", new String[]{"rowlimitexception(e1)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testNonXMLQueryContextOperator() {
        TestValidator.helpValidate("SELECT e2 FROM vTest.vMap WHERE context(e1, e1) = 2", new String[]{"context(e1, e1)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateSubquery1() {
        TestValidator.helpValidate("SELECT e2 FROM (SELECT e2 FROM vTest.vMap WHERE e2 = 'a') AS x", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateSubquery2() {
        TestValidator.helpValidate("SELECT e2 FROM (SELECT e3 FROM vTest.vMap) AS x, vTest.vMap WHERE e2 = 'a'", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateSubquery3() {
        TestValidator.helpValidate("SELECT * FROM pm1.g1, (EXEC pm1.sq1( )) AS alias", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateUnionWithSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 union all SELECT e3 FROM test.group union all select * from (SELECT e1 FROM test.group) as subquery1", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateExistsSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE EXISTS (SELECT e2 FROM vTest.vMap WHERE e2 = 'a')", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateScalarSubquery() {
        TestValidator.helpValidate("SELECT e2, (SELECT e1 FROM vTest.vMap WHERE e2 = '3') FROM test.group2", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateAnyCompareSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE e1 < ANY (SELECT e1 FROM test.group)", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateAllCompareSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE e1 = ALL (SELECT e1 FROM test.group)", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateSomeCompareSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE e1 <= SOME (SELECT e1 FROM test.group)", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateCompareSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE e1 >= (SELECT e1 FROM test.group WHERE e1 = 1)", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateInClauseSubquery() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE e1 IN (SELECT e1 FROM test.group)", new String[]{"e1"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateInClauseSubqueryPasses() {
        TestValidator.helpValidate("SELECT e2 FROM test.group2 WHERE e1 IN (SELECT e2 FROM test.group)", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateInClauseSubqueryArray() {
        TestValidator.helpValidate("SELECT e2 FROM pm1.g1 WHERE (e2, e3) IN (SELECT e2, e3 FROM pm1.g2)", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateExec1() {
        TestValidator.helpValidate("EXEC pm1.sq1()", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testCreateUpdateProcedure4() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpValidateProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure11() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2, pm1.g1.e1 from pm1.g1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure12() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2, pm1.g1.e1 from pm1.g1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailProcedure(procedure, userUpdateStr, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure31() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string MaxTran;\n";
        procedure = procedure + "MaxTran = SELECT MAX(e1) FROM pm1.g1;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpValidateProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testCreateUpdateProcedure32() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string var;\n";
        procedure = procedure + "var = null;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpValidateProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testDefect13643() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "LOOP ON (SELECT * FROM pm1.g1) AS myCursor\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var1 = SELECT COUNT(*) FROM myCursor;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testValidHaving() {
        TestValidator.helpValidate("SELECT intnum FROM bqt1.smalla GROUP BY intnum HAVING SUM(floatnum) > 1", new String[0], (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testValidHaving2() {
        String sql = "SELECT intkey FROM bqt1.smalla WHERE intkey = 1 GROUP BY intkey HAVING intkey = 1";
        TestValidator.helpValidate(sql, new String[0], (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testVirtualProcedure() {
        TestValidator.helpValidate("EXEC pm1.vsp1()", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testSelectWithNoFrom() {
        TestValidator.helpValidate("SELECT 5", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testSelectIntoTempGroup() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, e2, e3, e4 INTO #myTempTable FROM pm1.g2;\n";
        procedure = procedure + "SELECT COUNT(*) FROM #myTempTable;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpValidateProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testInvalidSelectIntoTempGroup() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, e2, e3, e4 INTO #myTempTable FROM pm1.g2;\n";
        procedure = procedure + "SELECT e1, e2, e3 INTO #myTempTable FROM pm1.g2;\n";
        procedure = procedure + "SELECT COUNT(*) FROM #myTempTable;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testInvalidSelectIntoTempGroup1() {
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "create local temporary table #myTempTable (e1 integer);\n";
        procedure = procedure + "SELECT e1 INTO #myTempTable FROM pm1.g2;\n";
        procedure = procedure + "SELECT COUNT(*) FROM #myTempTable;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testSelectIntoPhysicalGroup() {
        TestValidator.helpValidate("SELECT e1, e2, e3, e4 INTO pm1.g1 FROM pm1.g2", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, e2, e3, e4 INTO pm1.g1 FROM pm1.g2;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpValidateProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testSelectIntoPhysicalGroupNotUpdateable_Defect16857() {
        TestValidator.helpValidate("SELECT e0, e1, e2 INTO test.group3 FROM test.group2", new String[]{"test.group3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testSelectIntoElementsNotUpdateable() {
        TestValidator.helpValidate("SELECT e0, e1, e2 INTO test.group2 FROM test.group3", new String[]{"test.group2"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidSelectIntoTooManyElements() {
        TestValidator.helpValidate("SELECT e1, e2, e3, e4, 'val' INTO pm1.g1 FROM pm1.g2", new String[]{"SELECT e1, e2, e3, e4, 'val' INTO pm1.g1 FROM pm1.g2"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, e2, e3, e4, 'val' INTO pm1.g1 FROM pm1.g2;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testInvalidSelectIntoTooFewElements() {
        TestValidator.helpValidate("SELECT e1, e2, e3 INTO pm1.g1 FROM pm1.g2", new String[]{"SELECT e1, e2, e3 INTO pm1.g1 FROM pm1.g2"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, e2, e3 INTO pm1.g1 FROM pm1.g2;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testInvalidSelectIntoIncorrectTypes() {
        TestValidator.helpValidate("SELECT e1, convert(e2, string), e3, e4 INTO pm1.g1 FROM pm1.g2", new String[]{"SELECT e1, convert(e2, string), e3, e4 INTO pm1.g1 FROM pm1.g2"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, convert(e2, string), e3, e4 INTO pm1.g1 FROM pm1.g2;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testSelectIntoWithStar() {
        TestValidator.helpResolve("SELECT * INTO pm1.g1 FROM pm1.g2", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidSelectIntoWithStar() {
        TestValidator.helpValidate("SELECT * INTO pm1.g1 FROM pm1.g2, pm1.g1", new String[]{"SELECT * INTO pm1.g1 FROM pm1.g2, pm1.g1"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT * INTO pm1.g1 FROM pm1.g2, pm1.g1;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpFailProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testSelectIntoVirtualGroup() {
        TestValidator.helpValidate("SELECT e1, e2, e3, e4 INTO vm1.g1 FROM pm1.g2", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        String procedure = "FOR EACH ROW ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT e1, e2, e3, e4 INTO vm1.g1 FROM pm1.g2;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where y = 1";
        this.helpValidateProcedure(procedure, userQuery, Table.TriggerEvent.UPDATE);
    }

    @Test
    public void testVirtualProcedure2() {
        TestValidator.helpValidate("EXEC pm1.vsp13()", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedure3() {
        TestValidator.helpValidate("EXEC pm1.vsp27()", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testNonEmbeddedSubcommand_defect11000() {
        TestValidator.helpValidate("SELECT e0 FROM vTest.vGroup", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidateObjectInComparison() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE ObjectValue = 5";
        ValidatorReport report = TestValidator.helpValidate(sql, new String[]{"ObjectValue = 5"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        Assert.assertEquals((Object)"Non-comparable expression of type object cannot be used in comparison: ObjectValue = 5.", (Object)report.toString());
    }

    @Test
    public void testValidateAssignmentWithFunctionOnParameter_InServer() throws Exception {
        String sql = "EXEC pm1.vsp36(5)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Command command = new QueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)0L, (long)report.getItems().size());
    }

    @Test
    public void testDefect9917() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        String sql = "SELECT lookup('pm1.g1', 'e1a', 'e2', e2) AS x, lookup('pm1.g1', 'e4', 'e3', e3) AS y FROM pm1.g1";
        Command command = new QueryParser().parseCommand(sql);
        try {
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
            Assert.fail((String)"Did not get exception");
        }
        catch (QueryResolverException queryResolverException) {
            // empty catch block
        }
        sql = "SELECT lookup('pm1.g1a', 'e1', 'e2', e2) AS x, lookup('pm1.g1', 'e4', 'e3', e3) AS y FROM pm1.g1";
        command = new QueryParser().parseCommand(sql);
        try {
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
            Assert.fail((String)"Did not get exception");
        }
        catch (QueryResolverException queryResolverException) {
            // empty catch block
        }
    }

    @Test
    public void testLookupKeyElementComparable() throws Exception {
        TransformationMetadata metadata = TestValidator.exampleMetadata2();
        String sql = "SELECT lookup('test.group', 'e2', 'e3', convert(e2, blob)) AS x FROM test.group";
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        Assert.assertEquals((Object)"Non-comparable expression of type blob cannot be used as LOOKUP key columns: test.\"group\".e3.", (Object)report.toString());
    }

    @Test
    public void testDefect12107() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        String sql = "SELECT SUM(DISTINCT lookup('pm1.g1', 'e2', 'e2', e2)) FROM pm1.g1";
        Command command = TestValidator.helpResolve(sql, (QueryMetadataInterface)metadata);
        sql = "SELECT SUM(DISTINCT lookup('pm1.g1', 'e3', 'e2', e2)) FROM pm1.g1";
        command = TestValidator.helpResolve(sql, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        Assert.assertEquals((Object)"The aggregate function SUM cannot be used with non-numeric expressions: SUM(DISTINCT lookup('pm1.g1', 'e3', 'e2', e2))", (Object)report.toString());
    }

    private ValidatorReport helpValidateInModeler(String procName, String procSql, QueryMetadataInterface metadata) throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand(procSql);
        GroupSymbol group = new GroupSymbol(procName);
        QueryResolver.resolveCommand((Command)command, (GroupSymbol)group, (int)6, (QueryMetadataInterface)metadata, (boolean)true);
        return Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testValidateDynamicCommandWithNonTempGroup_InModeler() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN execute string 'select ' || '1' as X integer into pm1.g3; END";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp36", sql, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)1L, (long)report.getItems().size());
        Assert.assertEquals((Object)"Wrong number of elements being SELECTed INTO the target table. Expected 4 elements, but was 1.", (Object)report.toString());
    }

    @Test
    public void testValidateInModeler() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN select 1, 2; END";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        GroupSymbol group = new GroupSymbol("pm1.vsp36");
        QueryResolver.resolveCommand((Command)command, (GroupSymbol)group, (int)6, (QueryMetadataInterface)metadata, (boolean)true);
        Assert.assertEquals((long)2L, (long)command.getResultSetColumns().size());
    }

    @Test
    public void testDynamicDupUsing() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN execute string 'select ' || '1' as X integer into #temp using id=1, id=2; END";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp36", sql, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)1L, (long)report.getItems().size());
        Assert.assertEquals((Object)"Elements cannot appear more than once in a SET or USING clause.  The following elements are duplicated: [DVARS.id]", (Object)report.toString());
    }

    @Test
    public void testValidateAssignmentWithFunctionOnParameter_InModeler() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x = pm1.vsp36.param1 * 2; SELECT x; END";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp36", sql, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)0L, (long)report.getItems().size());
    }

    @Test
    public void testDefect12533() {
        String sql = "SELECT BQT1.SmallA.DateValue, BQT2.SmallB.ObjectValue FROM BQT1.SmallA, BQT2.SmallB WHERE BQT1.SmallA.DateValue = BQT2.SmallB.DateValue AND BQT1.SmallA.ObjectValue = BQT2.SmallB.ObjectValue AND BQT1.SmallA.IntKey < 30 AND BQT2.SmallB.IntKey < 30 ORDER BY BQT1.SmallA.DateValue";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        TestValidator.helpValidate(sql, new String[]{"BQT1.SmallA.ObjectValue = BQT2.SmallB.ObjectValue"}, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDefect16772() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN IF (pm1.vsp42.param1 > 0) SELECT 1 AS x; ELSE SELECT 0 AS x; END";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp42", sql, (QueryMetadataInterface)metadata);
        Assert.assertEquals((String)"Expected report to have no validation failures", (Object)false, (Object)report.hasItems());
    }

    @Test
    public void testDupLabel() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN IF (pm1.vsp42.param1 > 0) x : begin SELECT 1 AS x; x: begin atomic select 2 as x; end end END";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp42", sql, (QueryMetadataInterface)metadata);
        TestValidator.examineReport(sql, new String[]{"x : BEGIN ATOMIC\nSELECT 2 AS x;\nEND"}, report);
    }

    @Test
    public void testInvalidContinue() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN continue; END";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp42", sql, (QueryMetadataInterface)metadata);
        TestValidator.examineReport(sql, new String[]{"CONTINUE;"}, report);
    }

    @Test
    public void testInvalidLabel() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN IF (pm1.vsp42.param1 > 0) x : begin continue y; end END";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp42", sql, (QueryMetadataInterface)metadata);
        TestValidator.examineReport(sql, new String[]{"CONTINUE y;"}, report);
    }

    @Test
    public void testNonQueryAgg() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN IF (max(pm1.vsp42.param1) > 0) SELECT 1 AS x; ELSE SELECT 0 AS x; END";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp42", sql, (QueryMetadataInterface)metadata);
        TestValidator.examineReport(sql, new String[]{"MAX(pm1.vsp42.param1)"}, report);
    }

    @Test
    public void testDefect14886() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN END";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Command command = new QueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)0L, (long)report.getItems().size());
    }

    @Test
    public void testDefect21389() throws Exception {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN SELECT * INTO #temptable FROM pm1.g1; INSERT INTO #temptable (e1) VALUES ('a'); END";
        TransformationMetadata metadata = RealMetadataFactory.example1();
        Column c = metadata.getElementID("pm1.g1.e1");
        c.setUpdatable(false);
        Command command = new QueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)0L, (long)report.getItems().size());
    }

    @Test
    public void testMakeNotDep() {
        TestValidator.helpValidate("select group2.e1, group3.e2 from group2, group3 WHERE group2.e0 = group3.e0 OPTION MAKENOTDEP group2, group3", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInvalidMakeNotDep() {
        TestValidator.helpValidate("select group2.e1, group3.e2 from group2, group3 WHERE group2.e0 = group3.e0 OPTION MAKEDEP group2 MAKENOTDEP group2, group3", new String[]{"OPTION MAKEDEP group2 MAKENOTDEP group2, group3"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testCase4237() throws Exception {
        TransformationMetadata metadata = this.helpCreateCase4237VirtualProcedureMetadata();
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN EXEC pm1.sp(vm1.sp.in1); END";
        Command command = TestValidator.helpResolve(sql, new GroupSymbol("vm1.sp"), 6, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[0], (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCase4237InlineView() throws Exception {
        TransformationMetadata metadata = this.helpCreateCase4237VirtualProcedureMetadata();
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN SELECT * FROM (EXEC pm1.sp(vm1.sp.in1)) AS FOO; END";
        Command command = TestValidator.helpResolve(sql, new GroupSymbol("vm1.sp"), 6, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[0], (QueryMetadataInterface)metadata);
    }

    private TransformationMetadata helpCreateCase4237VirtualProcedureMetadata() {
        MetadataStore metadataStore = new MetadataStore();
        Schema physicalModel = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        ColumnSet<Procedure> resultSet = RealMetadataFactory.createResultSet("pm1.rs", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ProcedureParameter inParam = RealMetadataFactory.createParameter("in", 1, "string");
        Procedure storedProcedure = RealMetadataFactory.createStoredProcedure("sp", physicalModel, Arrays.asList(inParam));
        storedProcedure.setResultSet(resultSet);
        Schema virtualModel = RealMetadataFactory.createVirtualModel("vm1", metadataStore);
        ColumnSet<Procedure> virtualResultSet = RealMetadataFactory.createResultSet("vm1.rs", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ProcedureParameter virtualInParam = RealMetadataFactory.createParameter("in1", 1, "string");
        QueryNode queryNode = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN EXEC pm1.sp(vm1.sp.in1); END");
        Procedure virtualStoredProcedure = RealMetadataFactory.createVirtualProcedure("sp", virtualModel, Arrays.asList(virtualInParam), queryNode);
        virtualStoredProcedure.setResultSet(virtualResultSet);
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "case4237", new FunctionTree[0]);
    }

    @Test
    public void testSelectIntoWithNull() {
        TestValidator.helpValidate("SELECT null, null, null, null INTO pm1.g1 FROM pm1.g2", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testCreateWithNonSortablePrimaryKey() {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Command command = TestValidator.helpResolve("create local temporary table x (column1 string, column2 clob, primary key (column2))", (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[]{"column2"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testDropNonTemporary() {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Command command = TestValidator.helpResolve("drop table pm1.g1", (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[]{command.toString()}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testNestedContexts() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where context(a0, context(a0, a2))='x'", new String[]{"context(a0, context(a0, a2))"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testValidContextElement() {
        TestValidator.helpValidate("SELECT * FROM vm1.doc1 where context(1, a2)='x'", new String[]{"context(1, a2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
    }

    @Test
    public void testInsertIntoVirtualWithQuery() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Command command = TestValidator.helpResolve("insert into vm1.g1 select 1, 2, true, 3", (QueryMetadataInterface)metadata);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        Assert.assertTrue((boolean)report.getItems().isEmpty());
    }

    @Test
    public void testDynamicIntoDeclaredTemp() throws Exception {
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE  ").append("BEGIN\n").append("CREATE LOCAL TEMPORARY TABLE x (column1 string);").append("execute string 'SELECT e1 FROM pm1.g2' as e1 string INTO x;\n").append("select cast(column1 as integer) from x;\n").append("END\n");
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp36", procedure.toString(), (QueryMetadataInterface)metadata);
        Assert.assertEquals((String)report.toString(), (long)0L, (long)report.getItems().size());
    }

    @Test
    public void testVariablesGroupSelect() {
        String procedure = "CREATE VIRTUAL PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer VARIABLES.var1 = 1;\n";
        procedure = procedure + "select * from variables;\n";
        procedure = procedure + "END\n";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Command command = TestValidator.helpResolve(procedure, (QueryMetadataInterface)metadata);
        TestValidator.helpRunValidator(command, new String[]{"variables"}, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testClobEquals() {
        TestValidator.helpValidate("SELECT * FROM test.group where e4 = '1'", new String[]{"e4 = '1'"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testUpdateWithClob() {
        TestValidator.helpValidate("update test.group set e4 = ?", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testBlobLessThan() {
        TestValidator.helpValidate("SELECT * FROM test.group where e3 < ?", new String[]{"e3 < ?"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateCompare2() {
        TestValidator.helpValidate("SELECT e2 FROM test.group WHERE e4 IS NULL", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateCompare3() {
        TestValidator.helpValidate("SELECT e2 FROM test.group WHERE e4 IN ('a')", new String[]{"e4 IN ('a')"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateCompare5() {
        TestValidator.helpValidate("SELECT e2 FROM test.group WHERE e4 BETWEEN '1' AND '2'", new String[]{"e4 BETWEEN '1' AND '2'"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateCompareInHaving1() {
        TestValidator.helpValidate("SELECT e1 FROM test.group GROUP BY e1 HAVING convert(e1, clob) = 'a'", new String[]{"convert(e1, clob) = 'a'"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNoExpressionName() {
        TestValidator.helpValidate("SELECT xmlelement(name a, xmlattributes('1'))", new String[]{"XMLATTRIBUTES('1')"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testValidateNoExpressionName1() {
        TestValidator.helpValidate("SELECT xmlforest('1')", new String[]{"XMLFOREST('1')"}, (QueryMetadataInterface)TestValidator.exampleMetadata2());
    }

    @Test
    public void testXpathValueValid_defect15088() {
        String userSql = "SELECT xpathValue('<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>', 'a/b/c')";
        TestValidator.helpValidate(userSql, new String[0], (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testXpathValueInvalid_defect15088() throws Exception {
        String userSql = "SELECT xpathValue('<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>', '//*[local-name()=''bookName\"]')";
        TestValidator.helpValidate(userSql, new String[]{"xpathValue('<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>', '//*[local-name()=''bookName\"]')"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testTextTableNoWidth() {
        TestValidator.helpValidate("SELECT * from texttable(null columns x string width 1, y integer) as x", new String[]{"TEXTTABLE(null COLUMNS x string WIDTH 1, y integer) AS x"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testTextTableInvalidDelimiter() {
        TestValidator.helpValidate("SELECT * from texttable(null columns x string width 1 DELIMITER 'z') as x", new String[]{"TEXTTABLE(null COLUMNS x string WIDTH 1 DELIMITER 'z') AS x"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testTextTableNoRowDelimiter() {
        TestValidator.helpValidate("SELECT * from texttable(null columns x string NO ROW DELIMITER) as x", new String[]{"TEXTTABLE(null COLUMNS x string NO ROW DELIMITER) AS x"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testTextTableFixedSelector() {
        TestValidator.helpValidate("SELECT * from texttable(null SELECTOR 'a' columns x string width 1) as x", new String[0], (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testXMLNamespaces() {
        TestValidator.helpValidate("select xmlforest(xmlnamespaces(no default, default 'http://foo'), e1 as \"table\") from pm1.g1", new String[]{"XMLNAMESPACES(NO DEFAULT, DEFAULT 'http://foo')"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLNamespacesInvalid() {
        TestValidator.helpValidate("select xmlforest(xmlnamespaces('http://foo' as \"1\"), e1 as \"table\") from pm1.g1", new String[]{"XMLNAMESPACES('http://foo' AS \"1\")"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLNamespacesReserved() {
        TestValidator.helpValidate("select xmlforest(xmlnamespaces('http://foo' as xmlns), e1 as \"table\") from pm1.g1", new String[]{"XMLNAMESPACES('http://foo' AS xmlns)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLTablePassingMultipleContext() {
        TestValidator.helpValidate("select * from pm1.g1, xmltable('/' passing xmlparse(DOCUMENT '<a/>'), xmlparse(DOCUMENT '<b/>')) as x", new String[]{"XMLTABLE('/' PASSING XMLPARSE(DOCUMENT '<a/>'), XMLPARSE(DOCUMENT '<b/>')) AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidDefault() {
        TestValidator.helpValidate("select * from pm1.g1, xmltable('/' passing xmlparse(DOCUMENT '<a/>') columns y string default 'a', x string default (select e1 from pm1.g1)) as x", new String[]{"XMLTABLE('/' PASSING XMLPARSE(DOCUMENT '<a/>') COLUMNS y string DEFAULT 'a', x string DEFAULT (SELECT e1 FROM pm1.g1)) AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Ignore(value="this is actually handled by saxon and will show up during resolving")
    @Test
    public void testXMLTablePassingSameName() {
        TestValidator.helpValidate("select * from pm1.g1, xmltable('/' passing {x '<a/>'} as a, {x '<b/>'} as a) as x", new String[]{"xmltable('/' passing e1, e1 || 'x') as x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLTablePassingContextType() {
        TestValidator.helpValidate("select * from pm1.g1, xmltable('/' passing 2) as x", new String[]{"XMLTABLE('/' PASSING 2) AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLTableMultipleOrdinals() {
        TestValidator.helpValidate("select * from pm1.g1, xmltable('/' passing XMLPARSE(DOCUMENT '<a/>') columns x for ordinality, y for ordinality) as x", new String[]{"XMLTABLE('/' PASSING XMLPARSE(DOCUMENT '<a/>') COLUMNS x FOR ORDINALITY, y FOR ORDINALITY) AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLTableContextRequired() {
        TestValidator.helpValidate("select * from xmltable('/a/b' passing convert('<a/>', xml) as a columns x for ordinality, c integer path '.') as x", new String[]{"XMLTABLE('/a/b' PASSING convert('<a/>', xml) AS a COLUMNS x FOR ORDINALITY, c integer PATH '.') AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testObjectTablePassing() {
        TestValidator.helpValidate("select * from objecttable('x' passing 'a' columns c integer 'row') as x", new String[]{"OBJECTTABLE('x' PASSING 'a' COLUMNS c integer 'row') AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testObjectTablePassingSameName() {
        TestValidator.helpValidate("select * from objecttable('x' passing 'a' AS X, 'b' AS x columns c integer 'row') as x", new String[]{"OBJECTTABLE('x' PASSING 'a' AS X, 'b' AS x COLUMNS c integer 'row') AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testObjectTableLanguage() {
        TestValidator.helpValidate("select * from objecttable(language 'foo!' 'x' columns c integer 'row') as x", new String[]{"OBJECTTABLE(LANGUAGE 'foo!' 'x' COLUMNS c integer 'row') AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testObjectTableScript() {
        TestValidator.helpValidate("select * from objecttable('this. is not valid' columns c integer 'row') as x", new String[]{"OBJECTTABLE('this. is not valid' COLUMNS c integer 'row') AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXMLQueryPassingContextType() {
        TestValidator.helpValidate("select xmlquery('/' passing 2)", new String[]{"XMLQUERY('/' PASSING 2)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testQueryString() {
        TestValidator.helpValidate("select querystring('/', '1')", new String[]{"QUERYSTRING('/', '1')"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXmlNameValidation() throws Exception {
        TestValidator.helpValidate("select xmlelement(\":\")", new String[]{"XMLELEMENT(NAME \":\")"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testXmlParse() throws Exception {
        TestValidator.helpValidate("select xmlparse(content e2) from pm1.g1", new String[]{"XMLPARSE(CONTENT e2)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testDecode() throws Exception {
        TestValidator.helpValidate("select to_bytes(e1, '?') from pm1.g1", new String[]{"to_bytes(e1, '?')"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateXMLAGG() {
        TestValidator.helpValidate("SELECT XMLAGG(e1) from pm1.g1", new String[]{"XMLAGG(e1)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateBooleanAgg() {
        TestValidator.helpValidate("SELECT EVERY(e1) from pm1.g1", new String[]{"EVERY(e1)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateStatAgg() {
        TestValidator.helpValidate("SELECT stddev_pop(distinct e2) from pm1.g1", new String[]{"STDDEV_POP(DISTINCT e2)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testValidateScalarSubqueryTooManyColumns() {
        TestValidator.helpValidate("SELECT e2, (SELECT e1, e2 FROM pm1.g1 WHERE e2 = '3') FROM pm1.g2", new String[]{"SELECT e1, e2 FROM pm1.g1 WHERE e2 = '3'"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidIntoSubquery() {
        TestValidator.helpValidate("SELECT e2, (SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3') FROM pm1.g2", new String[]{"SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3'"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidIntoSubquery1() {
        TestValidator.helpValidate("SELECT e2 FROM pm1.g2 WHERE EXISTS (SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3')", new String[]{"SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3'"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidIntoSubquery2() {
        TestValidator.helpValidate("SELECT * FROM (SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3') x", new String[]{"SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3'"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidIntoSubquery3() {
        TestValidator.helpValidate("SELECT e2 FROM pm1.g2 WHERE e2 in (SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3')", new String[]{"SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3'"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidIntoSubquery4() throws Exception {
        StringBuffer procedure = new StringBuffer("CREATE VIRTUAL PROCEDURE\n").append("BEGIN\n").append("loop on (SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3') as x\n").append("BEGIN\nSELECT 1;\nEND\nSELECT 1\n;END\n");
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp36", procedure.toString(), (QueryMetadataInterface)metadata);
        TestValidator.examineReport(procedure, new String[]{"SELECT e1, e2 INTO #x FROM pm1.g1 WHERE e2 = '3'"}, report);
    }

    @Test
    public void testDisallowUpdateOnMultisourceElement() throws Exception {
        HashSet<String> models = new HashSet<String>();
        models.add("pm1");
        ValidatorReport report = this.helpValidateInModeler("pm1.vsp36", "UPDATE PM1.G1 set SOURCE_NAME='blah'", (QueryMetadataInterface)new MultiSourceMetadataWrapper((QueryMetadataInterface)RealMetadataFactory.example1(), models));
        Assert.assertEquals((String)report.toString(), (long)1L, (long)report.getItems().size());
    }

    @Test
    public void testMultiSourceInsert() throws Exception {
        HashSet<String> models = new HashSet<String>();
        models.add("pm1");
        TestValidator.helpValidate("insert into pm1.g1 (e1) values (1)", new String[]{"pm1.g1", "pm1.g1.SOURCE_NAME"}, (QueryMetadataInterface)new MultiSourceMetadataWrapper((QueryMetadataInterface)RealMetadataFactory.example1(), models));
    }

    @Test
    public void testDisallowProjectIntoMultiSource() throws Exception {
        HashSet<String> models = new HashSet<String>();
        models.add("pm1");
        TestValidator.helpValidate("insert into pm1.g1 select pm1.g1.*, 1 from pm1.g1", new String[]{"pm1.g1"}, (QueryMetadataInterface)new MultiSourceMetadataWrapper((QueryMetadataInterface)RealMetadataFactory.example1(), models));
    }

    @Test
    public void testTextAggEncoding() throws Exception {
        TestValidator.helpValidate("select textagg(for e1 encoding abc) from pm1.g1", new String[]{"TEXTAGG(FOR e1 ENCODING abc)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testTextAggHeader() throws Exception {
        TestValidator.helpValidate("select textagg(for e1 || 1 HEADER) from pm1.g1", new String[]{"TEXTAGG(FOR (e1 || 1) HEADER)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testMultiSourceProcValue() throws Exception {
        HashSet<String> models = new HashSet<String>();
        models.add("MultiModel");
        TestValidator.helpValidate("exec MultiModel.proc('a', (select 1))", new String[0], (QueryMetadataInterface)new MultiSourceMetadataWrapper((QueryMetadataInterface)RealMetadataFactory.exampleMultiBinding(), models));
    }

    @Test
    public void testFailAggregateInGroupBy() {
        TestValidator.helpValidate("SELECT max(e1) FROM pm1.g1 GROUP BY count(e2)", new String[]{"COUNT(e2)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testFailAggregateInWhere() {
        TestValidator.helpValidate("SELECT e1 FROM pm1.g1 where count(e2) = 1", new String[]{"COUNT(e2)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testFailAggregateInFrom() {
        TestValidator.helpValidate("SELECT g2.e1 FROM pm1.g1 inner join pm1.g2 on (avg(g1.e2) = g2.e2)", new String[]{"AVG(g1.e2)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testFailAggregateFilterSubquery() {
        TestValidator.helpValidate("SELECT min(g1.e1) filter (where (select 1) = 1) from pm1.g1", new String[]{"(SELECT 1) = 1"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testNestedAgg() {
        TestValidator.helpValidate("SELECT min(g1.e1) filter (where max(e2) = 1) from pm1.g1", new String[]{"MAX(e2)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testWindowFunction() {
        TestValidator.helpValidate("SELECT e1 from pm1.g1 where row_number() over (order by e2) = 1", new String[]{"ROW_NUMBER() OVER (ORDER BY e2)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testWindowFunction1() {
        TestValidator.helpValidate("SELECT 1 from pm1.g1 having row_number() over (order by e2) = 1", new String[]{"e2", "ROW_NUMBER() OVER (ORDER BY e2)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testWindowFunctionWithoutOrdering() {
        TestValidator.helpValidate("SELECT row_number() over () from pm1.g1", new String[]{"ROW_NUMBER() OVER ()"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testWindowFunctionWithNestedOrdering() {
        TestValidator.helpValidate("SELECT xmlagg(xmlelement(name x, e1) order by e2) over () from pm1.g1", new String[]{"XMLAGG(XMLELEMENT(NAME x, e1) ORDER BY e2) OVER ()"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testWindowFunctionWithNestedaggAllowed() {
        TestValidator.helpValidate("SELECT max(e1) over (order by max(e2)) from pm1.g1 group by e1", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testWindowFunctionWithNestedaggAllowed1() {
        TestValidator.helpValidate("SELECT max(min(e1)) over (order by max(e2)) from pm1.g1 group by e1", new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testWindowFunctionWithoutFrom() {
        TestValidator.helpValidate("select count(*) over () as y", new String[]{"COUNT(*) OVER ()"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testWindowFunctionOrderedDistinct() {
        TestValidator.helpValidate("select count(distinct e1) over (order by e2) as y from pm1.g1", new String[]{"COUNT(DISTINCT e1) OVER (ORDER BY e2)"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidCorrelation() {
        TestValidator.helpValidate("SELECT XMLELEMENT(NAME metadata, XMLFOREST(e1 AS objectName), (SELECT XMLAGG(XMLELEMENT(NAME subTypes, XMLFOREST(e1))) FROM pm1.g2 AS b WHERE b.e2 = a.e2)) FROM pm1.g1 AS a GROUP BY e1", new String[]{"a.e2"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testUpdateError() {
        String userUpdateStr = "UPDATE vm1.g2 SET e1='x'";
        TestValidator.helpValidate(userUpdateStr, new String[]{"vm1.g2", "UPDATE vm1.g2 SET e1 = 'x'"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInsertError() {
        String userUpdateStr = "INSERT into vm1.g2 (e1) values ('x')";
        TestValidator.helpValidate(userUpdateStr, new String[]{"vm1.g2", "INSERT INTO vm1.g2 (e1) VALUES ('x')"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testMergeNoKey() {
        String userUpdateStr = "MERGE into pm1.g2 (e1) values ('x')";
        TestValidator.helpValidate(userUpdateStr, new String[]{"UPSERT INTO pm1.g2 (e1) VALUES ('x')"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testUpsertWithNonUpdatableKey() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.fromDDL("create foreign table g1 (e1 integer not null auto_increment primary key options (updatable false), e2 integer) options (updatable true)", "x", "y");
        String userUpdateStr = "UPSERT into g1 (e1, e2) values (1, 1)";
        TestValidator.helpValidate(userUpdateStr, new String[0], (QueryMetadataInterface)metadata);
        userUpdateStr = "UPSERT into g1 (e1, e2) values (null, 1)";
        TestValidator.helpValidate(userUpdateStr, new String[0], (QueryMetadataInterface)metadata);
    }

    @Test
    public void testDeleteError() {
        String userUpdateStr = "DELETE from vm1.g2 where e1='x'";
        TestValidator.helpValidate(userUpdateStr, new String[]{"vm1.g2"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testJsonArrayBlob() {
        String sql = "select jsonArray(to_bytes('hello', 'us-ascii'))";
        TestValidator.helpValidate(sql, new String[]{"jsonArray(to_bytes('hello', 'us-ascii'))"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testJsonArrayClob() {
        String sql = "select jsonArray(cast('hello' as clob))";
        TestValidator.helpValidate(sql, new String[0], (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testJsonObject() {
        String sql = "select jsonObject(to_bytes('hello', 'us-ascii'))";
        TestValidator.helpValidate(sql, new String[]{"JSONOBJECT(to_bytes('hello', 'us-ascii'))"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testWithValidation() {
        String sql = "with a as (select jsonObject(to_bytes('hello', 'us-ascii')) as x) select a.x from a";
        TestValidator.helpValidate(sql, new String[]{"JSONOBJECT(to_bytes('hello', 'us-ascii'))"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInsertIntoVirtualWithQueryExpression() {
        TransformationMetadata qmi = RealMetadataFactory.example1Cached();
        String sql = "select * from vm1.g1 as x";
        TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)qmi);
        sql = "insert into vm1.g1 (e1, e2, e3, e4) select * from pm1.g1";
        TestValidator.helpValidate(sql, new String[0], (QueryMetadataInterface)qmi);
    }

    @Test
    public void testInsertDuplicateVariable() {
        TransformationMetadata qmi = RealMetadataFactory.example1Cached();
        String sql = "insert into pm1.g1 (e1, e1) values ('a', 'b')";
        TestValidator.helpValidate(sql, new String[]{"e1"}, (QueryMetadataInterface)qmi);
    }

    @Test
    public void testAlterAfterTrigger() {
        String userUpdateStr = "ALTER TRIGGER tr ON pm1.g2 AFTER INSERT DISABLED;";
        TestValidator.helpValidate(userUpdateStr, new String[]{"ALTER TRIGGER tr ON pm1.g2 AFTER INSERT DISABLED"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidValueFunctions() {
        TestValidator.helpValidate("SELECT FIRST_VALUE(e3) over () FROM test.group", new String[]{"FIRST_VALUE(e3) OVER ()"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
        TestValidator.helpValidate("SELECT FIRST_VALUE(e3 order by e2) over (order by e2) FROM test.group", new String[]{"FIRST_VALUE(e3 ORDER BY e2) OVER (ORDER BY e2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
        TestValidator.helpValidate("SELECT LAST_VALUE(e3, e2) over (order by e2) FROM test.group", new String[]{"LAST_VALUE(e3, e2) OVER (ORDER BY e2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
        TestValidator.helpValidate("SELECT LAST_VALUE() over (order by e2) FROM test.group", new String[]{"LAST_VALUE() OVER (ORDER BY e2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
        TestValidator.helpValidate("SELECT LAG() over (order by e2) FROM test.group", new String[]{"LAG() OVER (ORDER BY e2)"}, (QueryMetadataInterface)TestValidator.exampleMetadata());
        TestValidator.helpValidate("SELECT LAG(e3) over (order by e2) FROM test.group", new String[0], (QueryMetadataInterface)TestValidator.exampleMetadata());
    }
}

