/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.juddi.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.as.juddi.service.JUDDIConfiguration;
import org.jboss.as.juddi.service.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;

public class JUDDIConfigurationService
extends AbstractService<JUDDIConfiguration> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"juddi", "configuration"});
    private final Logger log = Logger.getLogger(JUDDIConfigurationService.class);
    private final JUDDIConfiguration config = new JUDDIConfiguration();

    public static ServiceController<?> addService(ServiceTarget target, ServiceListener<Object> ... listeners) {
        JUDDIConfigurationService service = new JUDDIConfigurationService();
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addListener(listeners);
        return builder.install();
    }

    private JUDDIConfigurationService() {
    }

    public void start(StartContext context) throws StartException {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("/WEB-INF/juddi.properties");
        try {
            Properties props = new Properties();
            props.load(inputStream);
            String defaultbinding = props.getProperty("juddi.dataSource");
            this.config.setDataSourceBinding(SecurityActions.getSystemProperty("juddi.dataSource", defaultbinding));
            this.config.setDropOnStart(Boolean.parseBoolean(props.getProperty("juddi.drop-on-start")));
            this.config.setCreateOnStart(Boolean.parseBoolean(props.getProperty("juddi.create-on-start")));
            this.config.setDropOnStop(Boolean.parseBoolean(props.getProperty("juddi.drop-on-stop")));
        }
        catch (IOException e) {
            throw new StartException("Cannot load juddi.properties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JUDDIConfiguration getValue() throws IllegalStateException {
        JUDDIConfiguration jUDDIConfiguration = this.config;
        synchronized (jUDDIConfiguration) {
            return this.config;
        }
    }
}

