/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.juddi.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.Servlet;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.juddi.registry.RegistryServlet;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.juddi.service.JUDDIConfiguration;
import org.jboss.as.juddi.service.JUDDIConfigurationService;
import org.jboss.as.juddi.service.JUDDIServlet;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class JUDDIWebContextService
implements Service<Context> {
    static final ServiceName JUDDI_CONTEXT_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"juddi", "context"});
    private final Logger log = Logger.getLogger(JUDDIWebContextService.class);
    private final StandardContext context;
    private final InjectedValue<VirtualHost> hostInjector = new InjectedValue();
    private final InjectedValue<HttpManagement> httpManagementInjector = new InjectedValue();
    private final InjectedValue<JUDDIConfiguration> injectedConfig = new InjectedValue();

    public static ServiceController<?> addService(ServiceTarget target, ServiceListener<Object> ... listeners) {
        JUDDIWebContextService service = new JUDDIWebContextService();
        ServiceBuilder builder = target.addService(JUDDI_CONTEXT_SERVICE_NAME, (Service)service);
        builder.addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{"default-host"}), VirtualHost.class, service.hostInjector);
        builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, HttpManagementService.SERVICE_NAME, HttpManagement.class, service.httpManagementInjector);
        builder.addDependency(JUDDIConfigurationService.SERVICE_NAME, JUDDIConfiguration.class, service.injectedConfig);
        builder.addListener(listeners);
        return builder.install();
    }

    private JUDDIWebContextService() {
        this.context = new StandardContext(){
            private DirContext resources;

            public DirContext getResources() {
                DirContext orgdirctx;
                if (this.resources == null && (orgdirctx = super.getResources()) != null) {
                    JUDDIConfiguration config = (JUDDIConfiguration)JUDDIWebContextService.this.injectedConfig.getValue();
                    this.resources = new DirContextHack(config, new Hashtable<String, Object>(), orgdirctx);
                }
                return this.resources;
            }
        };
    }

    public synchronized void start(StartContext startContext) throws StartException {
        JUDDIConfiguration config = (JUDDIConfiguration)this.injectedConfig.getValue();
        if (config.getDataSourceBinding() != null) {
            HttpManagement httpManagement = (HttpManagement)this.httpManagementInjector.getOptionalValue();
            try {
                this.context.setPath("/juddi");
                this.context.addLifecycleListener((LifecycleListener)new ContextConfig());
                this.context.setDocBase("");
                WebCtxLoader loader = new WebCtxLoader(this.getClass().getClassLoader());
                Host host = ((VirtualHost)this.hostInjector.getValue()).getHost();
                loader.setContainer((Container)host);
                this.context.setLoader((Loader)loader);
                this.context.setInstanceManager((InstanceManager)new LocalInstanceManager(httpManagement));
                JUDDIServlet servlet = new JUDDIServlet();
                Wrapper wrapper = this.context.createWrapper();
                wrapper.setName("JUDDIServlet");
                wrapper.setServlet((Servlet)servlet);
                wrapper.setServletClass(((Object)((Object)servlet)).getClass().getName());
                this.context.addChild((Container)wrapper);
                this.context.addServletMapping("/publish", "JUDDIServlet");
                this.context.addServletMapping("/inquiry", "JUDDIServlet");
                servlet = new RegistryServlet();
                wrapper = this.context.createWrapper();
                wrapper.setName("JUDDIRegistryServlet");
                wrapper.setServlet((Servlet)servlet);
                wrapper.setServletClass(((Object)((Object)servlet)).getClass().getName());
                wrapper.setLoadOnStartup(1);
                this.context.addChild((Container)wrapper);
                host.addChild((Container)this.context);
                this.context.create();
            }
            catch (Exception e) {
                throw new StartException("failed to create context", (Throwable)e);
            }
            try {
                this.context.start();
            }
            catch (LifecycleException e) {
                throw new StartException("failed to start context", (Throwable)e);
            }
        }
    }

    public synchronized void stop(StopContext stopContext) {
        JUDDIConfiguration config = (JUDDIConfiguration)this.injectedConfig.getValue();
        if (config.getDataSourceBinding() != null) {
            try {
                ((VirtualHost)this.hostInjector.getValue()).getHost().removeChild((Container)this.context);
                this.context.stop();
            }
            catch (LifecycleException e) {
                this.log.error((Object)"exception while stopping context", (Throwable)e);
            }
            try {
                this.context.destroy();
            }
            catch (Exception e) {
                this.log.error((Object)"exception while destroying context", (Throwable)e);
            }
        }
    }

    public synchronized Context getValue() throws IllegalStateException {
        return this.context;
    }

    private static class DirContextHack
    extends ProxyDirContext {
        private final JUDDIConfiguration config;

        DirContextHack(JUDDIConfiguration config, Hashtable<String, Object> env, DirContext dircontext) {
            super(env, dircontext);
            this.config = config;
        }

        public Object lookup(String name) throws NamingException {
            try {
                return super.lookup(name);
            }
            catch (NamingException ex) {
                NamingException namingExeption = ex;
                InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(name);
                if (stream == null) {
                    throw namingExeption;
                }
                if (name.equals("/WEB-INF/juddi.properties")) {
                    try {
                        Properties props = new Properties();
                        props.load(stream);
                        props.setProperty("juddi.dataSource", this.config.getDataSourceBinding());
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        props.store(out, "jUDDI Registry Properties");
                        stream = new ByteArrayInputStream(out.toByteArray());
                    }
                    catch (IOException ex2) {
                        NamingException namingException = new NamingException("Cannot append jUDDI datasource");
                        namingException.initCause(ex2);
                        throw namingException;
                    }
                }
                return new Resource(stream);
            }
        }
    }

    private static class LocalInstanceManager
    implements InstanceManager {
        private final HttpManagement httpManagement;

        LocalInstanceManager(HttpManagement httpManagement) {
            this.httpManagement = httpManagement;
        }

        public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            if (!className.equals(JUDDIServlet.class.getName())) {
                return Class.forName(className).newInstance();
            }
            JUDDIServlet servlet = new JUDDIServlet();
            return servlet;
        }

        public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(fqcn, false, classLoader).newInstance();
        }

        public Object newInstance(Class<?> c) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
            return c.newInstance();
        }

        public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
            throw new IllegalStateException();
        }

        public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        }
    }
}

