/*
 * Decompiled with CFR 0.152.
 */
package netty.utils;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import netty.listeners.ChannelLifecycleListener;
import netty.listeners.NettyReceiverListener;
import netty.utils.ReceiverHandler;

public class PipelineChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private NettyReceiverListener nettyReceiverListener;
    private ChannelLifecycleListener lifecycleListener;
    private EventExecutorGroup separateWorkerGroup;
    public final int MAX_FRAME_LENGTH = Integer.MAX_VALUE;
    public final int LENGTH_OF_FIELD = 4;

    public PipelineChannelInitializer(NettyReceiverListener nettyReceiverListener, ChannelLifecycleListener lifecycleListener, EventExecutorGroup separateWorkerGroup) {
        this.nettyReceiverListener = nettyReceiverListener;
        this.lifecycleListener = lifecycleListener;
        this.separateWorkerGroup = separateWorkerGroup;
    }

    protected void initChannel(SocketChannel ch) {
        ch.pipeline().addFirst(new ChannelHandler[]{new FlushConsolidationHandler(32000, true)});
        ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4)});
        ch.pipeline().addLast(this.separateWorkerGroup, "handlerThread", (ChannelHandler)new ReceiverHandler(this.nettyReceiverListener, this.lifecycleListener));
    }
}

