/*
 * Decompiled with CFR 0.152.
 */
package netty.utils;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import netty.listeners.ChannelLifecycleListener;
import netty.listeners.NettyReceiverListener;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

@ChannelHandler.Sharable
public class ReceiverHandler
extends ChannelInboundHandlerAdapter {
    private NettyReceiverListener nettyReceiverListener;
    private ChannelLifecycleListener lifecycleListener;
    private byte[] buffer = new byte[65200];

    public ReceiverHandler(NettyReceiverListener nettyReceiverListener, ChannelLifecycleListener lifecycleListener) {
        this.nettyReceiverListener = nettyReceiverListener;
        this.lifecycleListener = lifecycleListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf msgbuf = (ByteBuf)msg;
        int totalLength = msgbuf.readInt();
        int addrLen = msgbuf.readInt();
        int dataLen = totalLength - 4 - addrLen;
        msgbuf.readBytes(this.buffer, 0, addrLen);
        msgbuf.readBytes(this.buffer, addrLen, dataLen);
        IpAddress sender = new IpAddress();
        sender.readFrom((DataInput)new DataInputStream(new ByteArrayInputStream(this.buffer, 0, addrLen)));
        ReceiverHandler receiverHandler = this;
        synchronized (receiverHandler) {
            this.nettyReceiverListener.onReceive((Address)sender, this.buffer, addrLen, dataLen);
        }
        msgbuf.release();
        this.lifecycleListener.channelRead(ctx.channel(), sender);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.lifecycleListener.channelInactive(ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.nettyReceiverListener.onError(cause);
    }
}

