/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.Errors;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import netty.listeners.ChannelLifecycleListener;
import netty.listeners.NettyReceiverListener;
import netty.utils.PipelineChannelInitializer;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

public class NettyConnection {
    private final EventExecutorGroup separateWorkerGroup = new DefaultEventExecutorGroup(4);
    private final Bootstrap outgoingBootstrap = new Bootstrap();
    private final ServerBootstrap inboundBootstrap = new ServerBootstrap();
    private final Map<IpAddress, Channel> ipAddressChannelMap = new HashMap<IpAddress, Channel>();
    private byte[] replyAdder = null;
    private int port;
    private InetAddress bind_addr;
    private EventLoopGroup boss_group;
    private EventLoopGroup worker_group;
    private boolean isNativeTransport;
    private NettyReceiverListener callback;
    private ChannelLifecycleListener lifecycleListener;

    public NettyConnection(InetAddress bind_addr, int port, NettyReceiverListener callback, boolean isNativeTransport) {
        this.port = port;
        this.bind_addr = bind_addr;
        this.callback = callback;
        this.isNativeTransport = isNativeTransport;
        this.boss_group = isNativeTransport ? new EpollEventLoopGroup(1) : new NioEventLoopGroup(1);
        this.worker_group = isNativeTransport ? new EpollEventLoopGroup() : new NioEventLoopGroup();
        this.lifecycleListener = new ChannelLifecycleListener(){

            @Override
            public void channelInactive(Channel channel) {
                NettyConnection.this.ipAddressChannelMap.values().remove(channel);
            }

            @Override
            public void channelRead(Channel channel, IpAddress sender) {
                NettyConnection.this.updateMap(channel, sender);
            }
        };
        this.configureClient();
        this.configureServer();
    }

    public void run() throws InterruptedException, BindException, Errors.NativeIoException {
        this.inboundBootstrap.bind().sync();
        try {
            ByteArrayOutputStream replyAddByteStream = new ByteArrayOutputStream();
            DataOutputStream dStream = new DataOutputStream(replyAddByteStream);
            new IpAddress(this.bind_addr, this.port).writeTo((DataOutput)dStream);
            this.replyAdder = replyAddByteStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void send(IpAddress destAddr, byte[] data, int offset, int length) {
        Channel opened = this.ipAddressChannelMap.getOrDefault(destAddr, null);
        if (opened != null) {
            this.writeToChannel(opened, data, offset, length);
        } else {
            this.connectAndSend(destAddr, data, offset, length);
        }
    }

    public final void connectAndSend(IpAddress addr, byte[] data, int offset, int length) {
        ChannelFuture cf = this.outgoingBootstrap.connect((SocketAddress)new InetSocketAddress(addr.getIpAddress(), addr.getPort()));
        ByteBuf packed = NettyConnection.pack(cf.channel().alloc(), data, offset, length, this.replyAdder);
        cf.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (channelFuture.isSuccess()) {
                Channel ch = channelFuture.channel();
                this.writeToChannel(ch, packed);
                this.updateMap(ch, addr);
            }
        }));
    }

    public final void connectAndSend(IpAddress addr) {
        this.connectAndSend(addr, null, 0, 0);
    }

    public Address getLocalAddress() {
        return new IpAddress(this.bind_addr, this.port);
    }

    public void shutdown() throws InterruptedException {
        this.boss_group.shutdownGracefully();
        this.worker_group.shutdownGracefully();
        this.separateWorkerGroup.shutdownGracefully();
    }

    private void writeToChannel(Channel ch, byte[] data, int offset, int length) {
        ByteBuf packed = NettyConnection.pack(ch.alloc(), data, offset, length, this.replyAdder);
        this.writeToChannel(ch, packed);
    }

    private void writeToChannel(Channel ch, ByteBuf data) {
        ch.eventLoop().execute(() -> ch.writeAndFlush((Object)data, ch.voidPromise()));
    }

    private void updateMap(Channel connected, IpAddress destAddr) {
        Channel channel = this.ipAddressChannelMap.get(destAddr);
        if (channel != null && channel.id() == connected.id()) {
            return;
        }
        if (channel != null) {
            if (connected.remoteAddress().equals(new InetSocketAddress(destAddr.getIpAddress(), destAddr.getPort()))) {
                connected.close();
            }
            return;
        }
        this.ipAddressChannelMap.put(destAddr, connected);
    }

    private void configureClient() {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.outgoingBootstrap.group(this.worker_group)).handler((ChannelHandler)new PipelineChannelInitializer(this.callback, this.lifecycleListener, this.separateWorkerGroup))).localAddress(this.bind_addr, 0)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.TCP_NODELAY, (Object)true);
        if (this.isNativeTransport) {
            this.outgoingBootstrap.channel(EpollSocketChannel.class);
        } else {
            this.outgoingBootstrap.channel(NioSocketChannel.class);
        }
    }

    private void configureServer() {
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.inboundBootstrap.group(this.boss_group, this.worker_group).localAddress(this.bind_addr, this.port)).childHandler((ChannelHandler)new PipelineChannelInitializer(this.callback, this.lifecycleListener, this.separateWorkerGroup)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, (Object)true);
        if (this.isNativeTransport) {
            this.inboundBootstrap.channel(EpollServerSocketChannel.class);
        } else {
            this.inboundBootstrap.channel(NioServerSocketChannel.class);
        }
    }

    private static ByteBuf pack(ByteBufAllocator allocator, byte[] data, int offset, int length, byte[] replyAdder) {
        int allocSize = 4 + length + 4 + replyAdder.length;
        ByteBuf buf = allocator.buffer(allocSize);
        buf.writeInt(length + replyAdder.length + 4);
        buf.writeInt(replyAdder.length);
        buf.writeBytes(replyAdder);
        if (data != null) {
            buf.writeBytes(data, offset, length);
        }
        return buf;
    }
}

