/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.netty;

import io.netty.channel.unix.Errors;
import io.netty.util.ResourceLeakDetector;
import java.net.BindException;
import netty.listeners.NettyReceiverListener;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.cs.netty.NettyConnection;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;

public class Netty
extends TP {
    @Property(description="Use Native packages when available")
    protected boolean use_native_transport;
    @Property(description="Use Native packages when available")
    protected String resource_leak_detector_level;
    private NettyConnection server;
    private IpAddress selfAddress = null;

    public boolean supportsMulticasting() {
        return false;
    }

    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        this.sendToMembers(this.members, data, offset, length);
    }

    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        this._send((Address)dest, data, offset, length);
    }

    public String getInfo() {
        return null;
    }

    public void start() throws Exception {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.valueOf((String)this.resource_leak_detector_level));
        boolean isServerCreated = this.createServer();
        while (!isServerCreated && this.bind_port < this.bind_port + this.port_range) {
            ++this.bind_port;
            isServerCreated = this.createServer();
        }
        if (!isServerCreated) {
            throw new BindException("No port found to bind within port range");
        }
        super.start();
    }

    public void stop() {
        try {
            this.server.shutdown();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.log.error("Failed to shutdown server");
        }
        super.stop();
    }

    protected PhysicalAddress getPhysicalAddress() {
        return this.server != null ? (PhysicalAddress)this.server.getLocalAddress() : null;
    }

    private void _send(Address dest, byte[] data, int offset, int length) throws Exception {
        IpAddress destAddr;
        IpAddress ipAddress = destAddr = dest != null ? (IpAddress)dest : null;
        if (destAddr != this.selfAddress) {
            this.server.send(destAddr, data, offset, length);
        }
    }

    private boolean createServer() throws InterruptedException {
        try {
            this.server = new NettyConnection(this.bind_addr, this.bind_port, new NettyReceiverListener(){

                @Override
                public void onReceive(Address sender, byte[] msg, int offset, int length) {
                    Netty.this.receive(sender, msg, offset, length);
                }

                @Override
                public void onError(Throwable ex) {
                    Netty.this.log.error("Error Received at Netty transport " + ex.toString());
                }
            }, this.use_native_transport);
            this.server.run();
            this.selfAddress = (IpAddress)this.server.getLocalAddress();
        }
        catch (Errors.NativeIoException | InterruptedException | BindException exception) {
            this.server.shutdown();
            return false;
        }
        return true;
    }
}

