/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.kubernetes;

import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.dmr.ModelNode;
import org.jgroups.logging.Log;
import org.jgroups.protocols.kubernetes.Utils;
import org.jgroups.protocols.kubernetes.stream.StreamProvider;

public class Client {
    protected final String masterUrl;
    protected final Map<String, String> headers;
    protected final int connectTimeout;
    protected final int readTimeout;
    protected final int operationAttempts;
    protected final long operationSleep;
    protected final StreamProvider streamProvider;
    protected final String info;
    protected final Log log;

    public Client(String masterUrl, Map<String, String> headers, int connectTimeout, int readTimeout, int operationAttempts, long operationSleep, StreamProvider streamProvider, Log log) {
        this.masterUrl = masterUrl;
        this.headers = headers;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.operationAttempts = operationAttempts;
        this.operationSleep = operationSleep;
        this.streamProvider = streamProvider;
        this.log = log;
        TreeMap<String, String> maskedHeaders = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                String key = header.getKey();
                String value = header.getValue();
                if ("Authorization".equalsIgnoreCase(key) && value != null) {
                    value = "#MASKED:" + value.length() + "#";
                }
                maskedHeaders.put(key, value);
            }
        }
        this.info = String.format("%s[masterUrl=%s, headers=%s, connectTimeout=%s, readTimeout=%s, operationAttempts=%s, operationSleep=%s, streamProvider=%s]", this.getClass().getSimpleName(), masterUrl, maskedHeaders, connectTimeout, readTimeout, operationAttempts, operationSleep, streamProvider);
    }

    public final String info() {
        return this.info;
    }

    protected ModelNode getNode(String op, String namespace, String labels) throws Exception {
        String url = this.masterUrl;
        if (namespace != null && !namespace.isEmpty()) {
            url = url + "/namespaces/" + Utils.urlencode(namespace);
        }
        url = url + "/" + op;
        if (labels != null && !labels.isEmpty()) {
            url = url + "?labelSelector=" + Utils.urlencode(labels);
        }
        try (InputStream stream = Utils.openStream(url, this.headers, this.connectTimeout, this.readTimeout, this.operationAttempts, this.operationSleep, this.streamProvider);){
            ModelNode modelNode = ModelNode.fromJSONStream((InputStream)stream);
            return modelNode;
        }
    }

    public final List<InetAddress> getPods(String namespace, String labels) throws Exception {
        ModelNode root = this.getNode("pods", namespace, labels);
        ArrayList<InetAddress> pods = new ArrayList<InetAddress>();
        List itemNodes = root.get("items").asList();
        for (ModelNode itemNode : itemNodes) {
            ModelNode podIPNode;
            ModelNode specNode = itemNode.get("spec");
            ModelNode statusNode = itemNode.get("status");
            ModelNode phaseNode = statusNode.get("phase");
            if (!phaseNode.isDefined() || !"Running".equals(phaseNode.asString()) || !(podIPNode = statusNode.get("podIP")).isDefined()) continue;
            String podIP = podIPNode.asString();
            try {
                pods.add(InetAddress.getByName(podIP));
            }
            catch (Exception ex) {
                this.log.error("failed converting podIP (%s) to InetAddress: %s", new Object[]{podIP, ex});
            }
        }
        this.log.trace("getPods(%s, %s) = %s", new Object[]{namespace, labels, pods});
        return pods;
    }
}

