/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.kubernetes;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.TCPPING;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.kubernetes.Client;
import org.jgroups.protocols.kubernetes.Utils;
import org.jgroups.protocols.kubernetes.stream.BaseStreamProvider;
import org.jgroups.protocols.kubernetes.stream.CertificateStreamProvider;
import org.jgroups.protocols.kubernetes.stream.InsecureStreamProvider;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Responses;

@MBean(description="Kubernetes based discovery protocol")
public class KUBE_PING
extends TCPPING {
    protected static final short KUBERNETES_PING_ID = 2017;
    @Property(description="Max time (in millis) to wait for a connection to the Kubernetes server. If exceeded, an exception will be thrown", systemProperty={"KUBERNETES_CONNECT_TIMEOUT"})
    protected int connectTimeout = 5000;
    @Property(description="Max time (in millis) to wait for a response from the Kubernetes server", systemProperty={"KUBERNETES_READ_TIMEOUT"})
    protected int readTimeout = 30000;
    @Property(description="Max number of attempts to send discovery requests", systemProperty={"KUBERNETES_OPERATION_ATTEMPTS"})
    protected int operationAttempts = 3;
    @Property(description="Time (in millis) between operation attempts", systemProperty={"KUBERNETES_OPERATION_SLEEP"})
    protected long operationSleep = 1000L;
    @Property(description="http (default) or https. Used to send the initial discovery request to the Kubernetes server", systemProperty={"KUBERNETES_MASTER_PROTOCOL"})
    protected String masterProtocol = "https";
    @Property(description="The URL of the Kubernetes server", systemProperty={"KUBERNETES_SERVICE_HOST"})
    protected String masterHost;
    @Property(description="The port on which the Kubernetes server is listening", systemProperty={"KUBERNETES_SERVICE_PORT"})
    protected int masterPort;
    @Property(description="The version of the protocol to the Kubernetes server", systemProperty={"KUBERNETES_API_VERSION"})
    protected String apiVersion = "v1";
    @Property(description="namespace", systemProperty={"OPENSHIFT_KUBE_PING_NAMESPACE"})
    protected String namespace;
    @Property(description="The labels to use in the discovery request to the Kubernetes server", systemProperty={"KUBERNETES_LABELS"})
    protected String labels;
    @Property(description="Certificate to access the Kubernetes server", systemProperty={"KUBERNETES_CLIENT_CERTIFICATE_FILE"})
    protected String clientCertFile;
    @Property(description="Client key file (store)", systemProperty={"KUBERNETES_CLIENT_KEY_FILE"})
    protected String clientKeyFile;
    @Property(description="The password to access the client key store", systemProperty={"KUBERNETES_CLIENT_KEY_PASSWORD"})
    protected String clientKeyPassword;
    @Property(description="The algorithm used by the client", systemProperty={"KUBERNETES_CLIENT_KEY_ALGO"})
    protected String clientKeyAlgo = "RSA";
    @Property(description="Client CA certificate", systemProperty={"KUBERNETES_CA_CERTIFICATE_FILE"})
    protected String caCertFile;
    @Property(description="Token file", systemProperty={"SA_TOKEN_FILE"})
    protected String saTokenFile = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    protected Client client;
    protected int tp_bind_port;

    public void setMasterHost(String masterMost) {
        this.masterHost = masterMost;
    }

    public void setMasterPort(int masterPort) {
        this.masterPort = masterPort;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected boolean isClusteringEnabled() {
        return this.namespace != null;
    }

    public void init() throws Exception {
        BaseStreamProvider streamProvider;
        super.init();
        TP transport = this.getTransport();
        this.tp_bind_port = transport.getBindPort();
        if (this.tp_bind_port <= 0) {
            throw new IllegalArgumentException(String.format("%s only works with  %s.bind_port > 0", KUBE_PING.class.getSimpleName(), transport.getClass().getSimpleName()));
        }
        if (this.namespace == null) {
            this.log.warn("namespace not set; clustering disabled");
            return;
        }
        this.log.info("namespace %s set; clustering enabled", new Object[]{this.namespace});
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.clientCertFile != null) {
            if (this.masterProtocol == null) {
                this.masterProtocol = "http";
            }
            streamProvider = new CertificateStreamProvider(this.clientCertFile, this.clientKeyFile, this.clientKeyPassword, this.clientKeyAlgo, this.caCertFile);
        } else {
            String saToken = Utils.readFileToString(this.saTokenFile);
            if (saToken != null) {
                headers.put("Authorization", "Bearer " + saToken);
            }
            streamProvider = new InsecureStreamProvider();
        }
        String url = String.format("%s://%s:%s/api/%s", this.masterProtocol, this.masterHost, this.masterPort, this.apiVersion);
        this.client = new Client(url, headers, this.connectTimeout, this.readTimeout, this.operationAttempts, this.operationSleep, streamProvider, this.log);
        this.log.debug("KubePING configuration: " + this.toString());
        this.populateInitialHosts();
    }

    public void destroy() {
        this.client = null;
        super.destroy();
    }

    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        if (!initial_discovery) {
            this.populateInitialHosts();
        }
        super.findMembers(members, initial_discovery, responses);
    }

    protected void populateInitialHosts() {
        List<InetAddress> hosts = this.readAll();
        if (hosts == null || hosts.isEmpty()) {
            this.log.warn("initial_hosts could not be populated with information from Kubernetes");
            return;
        }
        List tcpping_hosts = this.getInitialHosts();
        for (InetAddress host : hosts) {
            for (int i = 0; i <= this.getPortRange(); ++i) {
                IpAddress addr = new IpAddress(host, this.tp_bind_port + i);
                if (tcpping_hosts.contains(addr)) continue;
                tcpping_hosts.add(addr);
                this.log.debug("added %s to initial_hosts", new Object[]{addr});
            }
        }
    }

    protected List<InetAddress> readAll() {
        if (this.isClusteringEnabled()) {
            return this.doReadAll(this.cluster_name);
        }
        return Collections.emptyList();
    }

    protected List<InetAddress> readAllTest() {
        if (this.isClusteringEnabled()) {
            try {
                return Collections.singletonList(InetAddress.getByName("127.0.0.1"));
            }
            catch (UnknownHostException e) {
                this.log.error("failed reading IP address", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    protected List<InetAddress> doReadAll(String clusterName) {
        try {
            if (this.client != null) {
                return this.client.getPods(this.namespace, this.labels);
            }
        }
        catch (Exception e) {
            this.log.warn("Problem getting Pod json from Kubernetes %s for cluster [%s], namespace [%s], labels [%s]; encountered [%s: %s]", new Object[]{this.client.info(), clusterName, this.namespace, this.labels, e.getClass().getName(), e.getMessage()});
        }
        return Collections.emptyList();
    }

    public String toString() {
        return String.format("KubePing{namespace='%s', labels='%s'}", this.namespace, this.labels);
    }

    static {
        ClassConfigurator.addProtocol((short)2017, KUBE_PING.class);
    }
}

