/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.kubernetes;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mjson.Json;
import org.jgroups.logging.Log;
import org.jgroups.protocols.kubernetes.Utils;
import org.jgroups.protocols.kubernetes.stream.StreamProvider;
import org.jgroups.util.Util;

public class Client {
    protected final String masterUrl;
    protected final Map<String, String> headers;
    protected final int connectTimeout;
    protected final int readTimeout;
    protected final int operationAttempts;
    protected final long operationSleep;
    protected final StreamProvider streamProvider;
    protected final String info;
    protected final Log log;

    public Client(String masterUrl, Map<String, String> headers, int connectTimeout, int readTimeout, int operationAttempts, long operationSleep, StreamProvider streamProvider, Log log) {
        this.masterUrl = masterUrl;
        this.headers = headers;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.operationAttempts = operationAttempts;
        this.operationSleep = operationSleep;
        this.streamProvider = streamProvider;
        this.log = log;
        TreeMap<String, String> maskedHeaders = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                String key = header.getKey();
                String value = header.getValue();
                if ("Authorization".equalsIgnoreCase(key) && value != null) {
                    value = "#MASKED:" + value.length() + "#";
                }
                maskedHeaders.put(key, value);
            }
        }
        this.info = String.format("%s[masterUrl=%s, headers=%s, connectTimeout=%s, readTimeout=%s, operationAttempts=%s, operationSleep=%s, streamProvider=%s]", this.getClass().getSimpleName(), masterUrl, maskedHeaders, connectTimeout, readTimeout, operationAttempts, operationSleep, streamProvider);
    }

    public String info() {
        return this.info;
    }

    protected String fetchFromKubernetes(String op, String namespace, String labels, boolean dump_requests) throws Exception {
        String url = this.masterUrl;
        if (namespace != null && !namespace.isEmpty()) {
            url = url + "/namespaces/" + Utils.urlencode(namespace);
        }
        url = url + "/" + op;
        if (labels != null && !labels.isEmpty()) {
            url = url + "?labelSelector=" + Utils.urlencode(labels);
        }
        if (dump_requests) {
            System.out.printf("--> %s\n", url);
        }
        try (InputStream stream = Utils.openStream(url, this.headers, this.connectTimeout, this.readTimeout, this.operationAttempts, this.operationSleep, this.streamProvider);){
            String string = Util.readContents((InputStream)stream);
            return string;
        }
    }

    public List<String> getPods(String namespace, String labels, boolean dump_requests) throws Exception {
        String result = this.fetchFromKubernetes("pods", namespace, labels, dump_requests);
        if (result == null) {
            return Collections.emptyList();
        }
        return this.parseJsonResult(result, namespace, labels);
    }

    protected List<String> parseJsonResult(String input, String namespace, String labels) {
        if (input == null) {
            return Collections.emptyList();
        }
        Json json = Json.read(input);
        if (json == null || !json.isObject()) {
            this.log.error("JSON is not a map: %s", new Object[]{json});
            return Collections.emptyList();
        }
        if (!json.has("items")) {
            this.log.error("JSON object is missing property \"items\": %s", new Object[]{json});
            return Collections.emptyList();
        }
        List<Json> items = json.at("items").asJsonList();
        ArrayList<String> pods = new ArrayList<String>();
        for (Json obj : items) {
            Json phase;
            Json status;
            if (!obj.isObject() || !obj.has("status") || !(status = obj.at("status")).isObject() || !status.has("podIP")) continue;
            String podIP = status.at("podIP").asString();
            if (status.has("phase") && (phase = status.at("phase")) != null && phase.isString() && !"Running".equals(phase.asString())) {
                this.log.trace("skipped pod with IP=%s as it is not running (%s)", new Object[]{podIP, phase});
                continue;
            }
            if (pods.contains(podIP)) continue;
            pods.add(podIP);
        }
        this.log.trace("getPods(%s, %s) = %s", new Object[]{namespace, labels, pods});
        return pods;
    }
}

