/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.util;

import org.kie.wb.selenium.util.BusyPopup;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObstructedClickExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BusyPopup.class);

    public static void retryClickUntilNotObstructed(WebElement element) {
        int triesRemaining = 100;
        boolean firstTime = true;
        while (triesRemaining > 0) {
            try {
                element.click();
                return;
            }
            catch (WebDriverException e) {
                if (ObstructedClickExceptionHandler.isClickObstructedByPopupPanelGlass(e) || ObstructedClickExceptionHandler.isClickObstructedByAlert(e)) {
                    --triesRemaining;
                    if (firstTime) {
                        firstTime = false;
                        String firstLineOfExceptionMessage = e.getMessage().split("\n")[0];
                        LOG.warn("Clicking element {} failed: {}", (Object)element, (Object)firstLineOfExceptionMessage);
                    } else {
                        LOG.debug("Retrying click, {} tries remaining.", (Object)triesRemaining);
                    }
                    Waits.pause(100);
                    continue;
                }
                throw e;
            }
        }
    }

    private static boolean isClickObstructedByPopupPanelGlass(WebDriverException e) {
        return e.getMessage().contains("gwt-PopupPanelGlass");
    }

    private static boolean isClickObstructedByAlert(WebDriverException e) {
        return e.getMessage().contains("alert-dismissable");
    }
}

