/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.util;

import java.util.function.Function;
import org.kie.wb.selenium.util.GrapheneUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Waits {
    private static final int DEFAULT_TIMEOUT = 15;

    public static void elementInvisible(By locator, int timeoutSeconds) {
        new WebDriverWait(GrapheneUtil.getDriver(), (long)timeoutSeconds).until((Function)ExpectedConditions.invisibilityOfElementLocated((By)locator));
    }

    public static WebElement elementPresent(By locator, int timeoutSeconds) {
        return (WebElement)new WebDriverWait(GrapheneUtil.getDriver(), (long)timeoutSeconds).until((Function)ExpectedConditions.presenceOfElementLocated((By)locator));
    }

    public static WebElement elementPresent(By locator) {
        return Waits.elementPresent(locator, 15);
    }

    public static void elementAbsent(By locator) {
        new WebDriverWait(GrapheneUtil.getDriver(), 15L).until((Function)ExpectedConditions.numberOfElementsToBe((By)locator, (Integer)0));
    }

    public static WebElement elementClickable(By locator) {
        return Waits.elementClickable(locator, 15);
    }

    public static WebElement elementClickable(By locator, int timeoutSeconds) {
        return (WebElement)new WebDriverWait(GrapheneUtil.getDriver(), (long)timeoutSeconds).until((Function)ExpectedConditions.elementToBeClickable((By)locator));
    }

    public static boolean isElementPresent(By locator, int timeoutSeconds) {
        try {
            Waits.elementPresent(locator, timeoutSeconds);
            return true;
        }
        catch (NoSuchElementException | TimeoutException nse) {
            return false;
        }
    }

    public static boolean isElementPresent(By locator) {
        return Waits.isElementPresent(locator, 15);
    }

    public static void pause(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            System.err.println("Pause interrupted");
        }
    }
}

