/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.security;

import org.guvnor.rest.client.CreateProjectRequest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.wb.test.rest.AccessRestTestBase;
import org.kie.wb.test.rest.User;

@RunWith(value=Parameterized.class)
public class ProjectAccessIntegrationTest
extends AccessRestTestBase {
    private static final String SPACE_NAME = "projectAccessTestSpace";
    private static final String PROJECT_NAME = "projectAccessTestRepository";

    public ProjectAccessIntegrationTest(User user) {
        super(user);
    }

    @BeforeClass
    public static void createRepository() {
        ProjectAccessIntegrationTest.createSpace(SPACE_NAME);
        ProjectAccessIntegrationTest.createNewProject(SPACE_NAME, PROJECT_NAME, "my.team", "1.0.0");
    }

    @Test
    public void testCreateProject() {
        String name = "createProjectWith" + this.user.getUserName();
        CreateProjectRequest createProjectRequest = new CreateProjectRequest();
        createProjectRequest.setGroupId("org.myteam");
        createProjectRequest.setVersion("1.0.0");
        createProjectRequest.setName(name);
        this.assertOperation(() -> this.roleClient.createProject(SPACE_NAME, createProjectRequest));
    }

    @Test
    public void testDeleteProject() {
        String name = "deleteProjectWith" + this.user.getUserName();
        this.createProject(name);
        this.assertOperation(() -> this.roleClient.deleteProject(SPACE_NAME, name));
    }

    @Test
    public void testGetProjects() {
        this.assertOperation(() -> this.roleClient.getProjects(SPACE_NAME));
    }

    @Test
    public void testCompileProject() {
        String name = "compileProjectWith" + this.user.getUserName();
        this.createProject(name);
        this.assertOperation(() -> this.roleClient.compileProject(SPACE_NAME, name));
    }

    @Test
    public void testTestProject() {
        String name = "testProjectWith" + this.user.getUserName();
        this.createProject(name);
        this.assertOperation(() -> this.roleClient.testProject(SPACE_NAME, name));
    }

    @Test
    public void testInstallProject() {
        String name = "installProjectWith" + this.user.getUserName() + Math.random();
        this.createProject(name);
        this.assertOperation(() -> this.roleClient.installProject(SPACE_NAME, name));
    }

    @Test
    public void testDeployProject() {
        String name = "deployProjectWith" + this.user.getUserName() + Math.random();
        this.createProject(name);
        this.assertOperation(() -> this.roleClient.deployProject(SPACE_NAME, name));
    }

    private void createProject(String name) {
        CreateProjectRequest createProjectRequest = new CreateProjectRequest();
        createProjectRequest.setGroupId("org.myteam");
        createProjectRequest.setVersion("1.0.0");
        createProjectRequest.setName(name);
        client.createProject(SPACE_NAME, createProjectRequest);
    }
}

