/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.functional;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.wb.test.rest.RestTestBase;
import org.kie.wb.test.rest.client.SpacesScreenLibraryPreference;
import org.kie.workbench.common.screens.library.api.SpacesScreenService;

public class SpacesScreenServiceIntegrationTest
extends RestTestBase {
    @Before
    public void before() {
        SpacesScreenServiceIntegrationTest.deleteAllSpaces();
    }

    @Test
    public void testGetSpaces() {
        Assert.assertEquals((long)0L, (long)((List)client.spacesScreen_getSpaces().readEntity(List.class)).size());
        SpacesScreenServiceIntegrationTest.createSpace("ASpace");
        Assert.assertEquals((long)1L, (long)((List)client.spacesScreen_getSpaces().readEntity(List.class)).size());
    }

    @Test
    public void testGetSpace() {
        SpacesScreenServiceIntegrationTest.createSpace("ASpace");
        Assert.assertEquals((long)200L, (long)client.spacesScreen_getSpace("ASpace").getStatus());
    }

    @Test
    public void testSaveLibraryPreference() {
        SpacesScreenServiceIntegrationTest.createSpace("ASpace");
        SpacesScreenServiceIntegrationTest.createNewProject("ASpace", "AProject", "com.AProject", "1.0.0");
        Assert.assertEquals((long)200L, (long)client.spacesScreen_savePreference(new SpacesScreenLibraryPreference(false, "AProject")).getStatus());
    }

    @Test
    public void testValidGroupId() {
        Assert.assertTrue((boolean)client.spacesScreen_isValidGroupId("foo.bar"));
    }

    @Test
    public void testPostSpace() {
        SpacesScreenService.NewSpace newSpace = new SpacesScreenService.NewSpace();
        newSpace.groupId = "foo.bar";
        newSpace.name = "ASpace";
        Assert.assertEquals((long)201L, (long)client.spacesScreen_postSpace(newSpace).getStatus());
    }
}

