/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.wb.test.rest.security;

import org.guvnor.rest.client.CloneProjectRequest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.wb.test.rest.AccessRestTestBase;
import org.kie.wb.test.rest.User;

@RunWith(Parameterized.class)
public class RepositoryAccessIntegrationTest extends AccessRestTestBase {

    private static final String SPACE_NAME = "repositoryAccessTestSpace";

    public RepositoryAccessIntegrationTest(User user) {
        super(user);
    }

    @BeforeClass
    public static void createSpace() {
        createSpace(SPACE_NAME);
    }

    @Test
    public void testCloneRepository() {
        final CloneProjectRequest cloneProjectRequest = new CloneProjectRequest();
        cloneProjectRequest.setName("cloneRepositoryWith" + user.getUserName());
        cloneProjectRequest.setGitURL(getLocalGitRepositoryUrl());

        assertOperation(() -> roleClient.cloneRepository(SPACE_NAME, cloneProjectRequest));
    }

    @Test
    public void testGetRepository() {
        final String name = "getRepositoryWith" + user.getUserName();
        createNewProject(SPACE_NAME, name, "org.myteam", "1.1.0");

        assertOperation(() -> roleClient.getProject(SPACE_NAME, name));
    }
}
