/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.functional;

import java.util.Collection;
import javax.ws.rs.NotFoundException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.guvnor.rest.client.CreateProjectRequest;
import org.guvnor.rest.client.Entity;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.ProjectResponse;
import org.guvnor.rest.client.Space;
import org.guvnor.rest.client.SpaceRequest;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.wb.test.rest.RestTestBase;
import org.kie.wb.test.rest.client.NotSuccessException;

public class SpaceIntegrationTest
extends RestTestBase {
    private static final String DESCRIPTION = "Testing space";
    private static final String GROUP_ID = "org.kie.wb.test";
    private static final String OWNER = USER_ID;

    @Test
    public void testCreateEmptyName() {
        Space space = new Space();
        space.setOwner(OWNER);
        try {
            client.createSpace(space);
            Assertions.fail((String)"NotSuccessException should have been thrown");
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.BAD_REQUEST);
            Assertions.assertThat((String)ex.getJobResult().getResult()).contains(new CharSequence[]{"name"});
        }
    }

    @Test
    public void testCreateEmptyOwner() {
        Space space = new Space();
        space.setName("emptyOwnerSpace");
        try {
            client.createSpace(space);
            Assertions.fail((String)"NotSuccessException should have been thrown");
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.BAD_REQUEST);
            Assertions.assertThat((String)ex.getJobResult().getResult()).contains(new CharSequence[]{"owner"});
        }
    }

    @Test
    public void testCreateMinimal() {
        Space space = new Space();
        space.setName("minimalSpace");
        space.setOwner(OWNER);
        this.testCreate(space);
    }

    @Test
    @Ignore(value="GUVNOR-2542")
    public void testCreateWithDescription() {
        Space space = new Space();
        space.setName("spaceWithDescription");
        space.setOwner(OWNER);
        space.setDescription(DESCRIPTION);
        this.testCreate(space);
    }

    @Test
    public void testCreateWithGroupId() {
        Space space = new Space();
        space.setName("spaceWithGroupId");
        space.setOwner(OWNER);
        space.setDefaultGroupId(GROUP_ID);
        this.testCreate(space);
    }

    @Test
    public void testDeleteNotExisting() {
        try {
            client.deleteSpace("notExistingSpace");
            Assertions.fail((String)"Space should have not been deleted");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteExisting() {
        String name = "spaceToBeDeleted";
        this.prepareSpace("spaceToBeDeleted");
        client.deleteSpace("spaceToBeDeleted");
        try {
            client.getSpace("spaceToBeDeleted");
            Assertions.fail((String)"Space should have been deleted");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test(expected=NotFoundException.class)
    public void testGetNotExisting() {
        client.getSpace("notExistingSpace");
    }

    @Test
    public void testGetExisting() {
        String name = "getExistingSpace";
        this.prepareSpace("getExistingSpace");
        Space space = client.getSpace("getExistingSpace");
        Assertions.assertThat((String)space.getName()).isEqualTo("getExistingSpace");
    }

    @Test
    public void testGetAll() {
        String name = "oneOfManySpace";
        this.prepareSpace("oneOfManySpace");
        Collection spaces = client.getSpaces();
        Assertions.assertThat((Iterable)spaces).extracting(Entity::getName).contains((Object[])new String[]{"oneOfManySpace"});
    }

    @Test
    public void testAddProjectToNotExistingSpace() {
        String spaceName = "notExistingSpace";
        CreateProjectRequest createProjectRequest = new CreateProjectRequest();
        createProjectRequest.setGroupId("org.myteam");
        createProjectRequest.setVersion("1.0.0");
        createProjectRequest.setName("addToNotExistingSpaceRepo");
        try {
            client.createProject("notExistingSpace", createProjectRequest);
            Assertions.fail((String)"The operation should have failed because space does not exist");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private Space prepareSpace(String name) {
        Space space = new Space();
        space.setName(name);
        space.setOwner(OWNER);
        space.setDescription(DESCRIPTION);
        space.setDefaultGroupId(GROUP_ID);
        client.createSpace(space);
        Space storedSpace = client.getSpace(name);
        Assertions.assertThat((Object)storedSpace).isNotNull();
        return space;
    }

    private void assertCreateSpaceRequest(SpaceRequest request, Space space) {
        SoftAssertions assertions = new SoftAssertions();
        assertions.assertThat(request.getSpaceName()).isEqualTo(space.getName());
        assertions.assertThat(request.getDescription()).isEqualTo(space.getDescription());
        assertions.assertThat(request.getOwner()).isEqualTo(space.getOwner());
        assertions.assertThat(request.getDefaultGroupId()).isEqualTo(space.getDefaultGroupId());
        assertions.assertAll();
    }

    private void assertSpace(Space actual, Space expected) {
        if (expected.getDefaultGroupId() == null) {
            expected.setDefaultGroupId(expected.getName());
        }
        SoftAssertions assertions = new SoftAssertions();
        assertions.assertThat(actual.getName()).isEqualTo(expected.getName());
        assertions.assertThat(actual.getDescription()).isEqualTo(expected.getDescription());
        assertions.assertThat(actual.getOwner()).isEqualTo(expected.getOwner());
        assertions.assertThat(actual.getDefaultGroupId()).isEqualTo(expected.getDefaultGroupId());
        if (expected.getProjects() != null) {
            assertions.assertThat(actual.getProjects()).containsOnly((Object[])expected.getProjects().toArray(new ProjectResponse[0]));
        }
        assertions.assertAll();
    }

    private void testCreate(Space space) {
        SpaceRequest request = client.createSpace(space);
        this.assertCreateSpaceRequest(request, space);
        Space clientSpace = client.getSpace(space.getName());
        this.assertSpace(clientSpace, space);
    }
}

