/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobStatus;
import org.junit.runners.Parameterized;
import org.kie.wb.test.rest.RestTestBase;
import org.kie.wb.test.rest.User;
import org.kie.wb.test.rest.client.RestWorkbenchClient;
import org.kie.wb.test.rest.client.WorkbenchClient;

public abstract class AccessRestTestBase
extends RestTestBase {
    protected final WorkbenchClient roleClient;
    protected final User user;

    @Parameterized.Parameters(name="user: {0}")
    public static Collection<Object[]> remoteController() {
        return Arrays.asList({User.NO_REST}, {User.REST_PROJECT});
    }

    public AccessRestTestBase(User user) {
        this.user = user;
        int fiveMinutes = 300;
        this.roleClient = RestWorkbenchClient.createWorkbenchClient((String)URL, (String)user.getUserName(), (String)user.getPassword(), (int)fiveMinutes, (int)fiveMinutes, (int)fiveMinutes);
    }

    private void assertOperationDoesNotFail(Operation operation) {
        Object result = operation.execute();
        if (result instanceof JobRequest) {
            JobRequest request = (JobRequest)result;
            Assertions.assertThat((Comparable)request.getStatus()).isIn(new Object[]{JobStatus.ACCEPTED, JobStatus.APPROVED, JobStatus.SUCCESS});
        }
    }

    private void assertOperationFails(Operation operation) {
        try {
            operation.execute();
            Assertions.fail((String)"Operation should have failed");
        }
        catch (Exception ex) {
            Assertions.assertThat((Throwable)ex).hasMessageContaining("Forbidden");
        }
    }

    protected void assertOperation(Operation operation) {
        if (this.user.isAuthorized()) {
            this.assertOperationDoesNotFail(operation);
        } else {
            this.assertOperationFails(operation);
        }
    }

    @FunctionalInterface
    protected static interface Operation {
        public Object execute();
    }
}

