/*
 * Decompiled with CFR 0.152.
 */
package org.kie.bc.client;

import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.cms.screen.explorer.NavigationExplorerScreen;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.event.NavTreeChangedEvent;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.kie.bc.client.home.HomeConfiguration;
import org.kie.bc.client.navigation.NavTreeDefinitions;
import org.kie.workbench.common.workbench.client.admin.DefaultAdminPageHelper;
import org.kie.workbench.common.workbench.client.authz.PermissionTreeSetup;
import org.kie.workbench.common.workbench.client.entrypoint.DefaultWorkbenchEntryPoint;
import org.kie.workbench.common.workbench.client.error.DefaultWorkbenchErrorCallback;
import org.kie.workbench.common.workbench.client.menu.DefaultWorkbenchFeaturesMenusHelper;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.SaveRoleEvent;
import org.uberfire.jsbridge.client.AppFormerJsBridge;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@EntryPoint
public class KieWorkbenchEntryPoint
extends DefaultWorkbenchEntryPoint {
    protected DefaultWorkbenchFeaturesMenusHelper menusHelper;
    protected ClientUserSystemManager userSystemManager;
    protected WorkbenchMegaMenuPresenter menuBar;
    protected Workbench workbench;
    protected PermissionTreeSetup permissionTreeSetup;
    protected DefaultAdminPageHelper adminPageHelper;
    protected NavTreeDefinitions navTreeDefinitions;
    protected NavigationManager navigationManager;
    protected NavigationExplorerScreen navigationExplorerScreen;
    protected AppFormerJsBridge appFormerJsBridge;
    private HomeConfiguration homeConfiguration;

    @Inject
    public KieWorkbenchEntryPoint(Caller<AppConfigService> appConfigService, ActivityBeansCache activityBeansCache, DefaultWorkbenchFeaturesMenusHelper menusHelper, ClientUserSystemManager userSystemManager, WorkbenchMegaMenuPresenter menuBar, Workbench workbench, PermissionTreeSetup permissionTreeSetup, DefaultAdminPageHelper adminPageHelper, NavTreeDefinitions navTreeDefinitions, NavigationManager navigationManager, NavigationExplorerScreen navigationExplorerScreen, DefaultWorkbenchErrorCallback defaultWorkbenchErrorCallback, AppFormerJsBridge appFormerJsBridge, HomeConfiguration homeConfiguration) {
        super(appConfigService, activityBeansCache, defaultWorkbenchErrorCallback);
        this.menusHelper = menusHelper;
        this.userSystemManager = userSystemManager;
        this.menuBar = menuBar;
        this.workbench = workbench;
        this.permissionTreeSetup = permissionTreeSetup;
        this.adminPageHelper = adminPageHelper;
        this.navTreeDefinitions = navTreeDefinitions;
        this.navigationManager = navigationManager;
        this.navigationExplorerScreen = navigationExplorerScreen;
        this.appFormerJsBridge = appFormerJsBridge;
        this.homeConfiguration = homeConfiguration;
    }

    @PostConstruct
    public void init() {
        this.appFormerJsBridge.init("org.kie.bc.KIEWebapp");
        this.homeConfiguration.setMonitoring(true);
        this.workbench.addStartupBlocker(KieWorkbenchEntryPoint.class);
        this.navigationExplorerScreen.getNavTreeEditor().setMaxLevels("wb_group", 2);
    }

    protected void initializeWorkbench() {
        this.permissionTreeSetup.configureTree();
        super.initializeWorkbench();
    }

    public void setupMenu() {
        this.navigationManager.init(() -> this.navTreeDefinitions.initialize(() -> {
            NavTree navTree = this.navTreeDefinitions.buildDefaultNavTree();
            this.navigationManager.setDefaultNavTree(navTree);
            this.initMenuBar();
            this.workbench.removeStartupBlocker(KieWorkbenchEntryPoint.class);
        }));
    }

    protected void setupAdminPage() {
        this.adminPageHelper.setup(false, true, false);
    }

    protected void initMenuBar() {
        this.refreshMenuBar();
    }

    protected void refreshMenuBar() {
        NavTree workbenchNavTree = this.navigationManager.getNavTree().getItemAsTree("wb_group");
        MenuFactory.TopLevelMenusBuilder builder = this.menusHelper.buildMenusFromNavTree(workbenchNavTree);
        if (builder != null) {
            Menus menus = builder.build();
            this.menuBar.clear();
            this.menuBar.addMenus(menus);
            this.menusHelper.addUtilitiesMenuItems();
        }
    }

    public void onNavTreeChanged(@Observes NavTreeChangedEvent event) {
        this.refreshMenuBar();
    }

    public void onAuthzPolicyChanged(@Observes SaveRoleEvent event) {
        this.refreshMenuBar();
    }

    public void onAuthzPolicyChanged(@Observes SaveGroupEvent event) {
        this.refreshMenuBar();
    }
}

