/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bi;

import java.util.ArrayList;
import java.util.function.Function;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.impl.score.stream.bi.CompositeBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.NoneBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.SingleBiJoiner;
import org.optaplanner.core.impl.score.stream.common.AbstractJoiner;

public abstract class AbstractBiJoiner<A, B>
extends AbstractJoiner
implements BiJoiner<A, B> {
    @SafeVarargs
    public static final <A, B> AbstractBiJoiner<A, B> merge(BiJoiner<A, B> ... joiners) {
        ArrayList joinerList = new ArrayList(joiners.length);
        for (BiJoiner<A, B> joiner : joiners) {
            if (joiner instanceof NoneBiJoiner) continue;
            if (joiner instanceof SingleBiJoiner) {
                joinerList.add((SingleBiJoiner)joiner);
                continue;
            }
            if (joiner instanceof CompositeBiJoiner) {
                joinerList.addAll(((CompositeBiJoiner)joiner).getJoinerList());
                continue;
            }
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        if (joinerList.isEmpty()) {
            return new NoneBiJoiner();
        }
        if (joinerList.size() == 1) {
            return (AbstractBiJoiner)joinerList.get(0);
        }
        return new CompositeBiJoiner(joinerList);
    }

    public abstract Function<A, Object> getLeftMapping(int var1);

    public abstract Function<A, Object[]> getLeftCombinedMapping();

    public abstract Function<B, Object> getRightMapping(int var1);

    public abstract Function<B, Object[]> getRightCombinedMapping();
}

