/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.tri;

import java.math.BigDecimal;
import java.util.List;
import org.drools.model.Global;
import org.drools.model.RuleItemBuilder;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsAbstractTriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriCondition;

public final class DroolsScoringTriConstraintStream<Solution_, A, B, C>
extends DroolsAbstractTriConstraintStream<Solution_, A, B, C> {
    private final boolean noMatchWeigher;
    private final ToIntTriFunction<A, B, C> intMatchWeigher;
    private final ToLongTriFunction<A, B, C> longMatchWeigher;
    private final TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher;

    public DroolsScoringTriConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractTriConstraintStream<Solution_, A, B, C> parent) {
        this(constraintFactory, parent, true, null, null, null);
    }

    public DroolsScoringTriConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractTriConstraintStream<Solution_, A, B, C> parent, ToIntTriFunction<A, B, C> intMatchWeigher) {
        this(constraintFactory, parent, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public DroolsScoringTriConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractTriConstraintStream<Solution_, A, B, C> parent, ToLongTriFunction<A, B, C> longMatchWeigher) {
        this(constraintFactory, parent, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public DroolsScoringTriConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractTriConstraintStream<Solution_, A, B, C> parent, TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private DroolsScoringTriConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractTriConstraintStream<Solution_, A, B, C> parent, boolean noMatchWeigher, ToIntTriFunction<A, B, C> intMatchWeigher, ToLongTriFunction<A, B, C> longMatchWeigher, TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory, parent);
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public List<RuleItemBuilder<?>> createRuleItemBuilders(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        DroolsAbstractTriConstraintStream actualParent = (DroolsAbstractTriConstraintStream)this.parent;
        DroolsTriCondition<A, B, C> condition = actualParent.getCondition();
        if (this.intMatchWeigher != null) {
            return condition.completeWithScoring(scoreHolderGlobal, this.intMatchWeigher);
        }
        if (this.longMatchWeigher != null) {
            return condition.completeWithScoring(scoreHolderGlobal, this.longMatchWeigher);
        }
        if (this.bigDecimalMatchWeigher != null) {
            return condition.completeWithScoring(scoreHolderGlobal, this.bigDecimalMatchWeigher);
        }
        if (this.noMatchWeigher) {
            return condition.completeWithScoring(scoreHolderGlobal);
        }
        throw new IllegalStateException("Impossible state: noMatchWeigher (" + this.noMatchWeigher + ").");
    }

    @Override
    public DroolsTriCondition<A, B, C> getCondition() {
        throw new UnsupportedOperationException("Scoring stream does not have its own TriCondition.");
    }

    public String toString() {
        return "TriScoring()";
    }
}

