/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.common;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.kie.server.controller.websocket.common.WebSocketClient;
import org.kie.server.controller.websocket.common.auth.WebSocketAuthConfigurator;
import org.kie.server.controller.websocket.common.config.WebSocketClientConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocketClientImpl<T extends MessageHandler>
extends Endpoint
implements WebSocketClient<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketClientImpl.class);
    private WebSocketContainer container = null;
    private Session session = null;
    private ClientEndpointConfig config = null;
    protected T messageHandler;
    private AtomicBoolean closed = new AtomicBoolean(true);
    private Thread reconnectThread = null;
    private Consumer<WebSocketClient> onReconnect;

    public WebSocketClientImpl() {
    }

    public WebSocketClientImpl(Consumer<WebSocketClient> onReconnect) {
        this();
        this.onReconnect = onReconnect;
    }

    public void onClose(Session session, CloseReason reason) {
        if (!session.getId().equals(this.session.getId())) {
            LOGGER.info("Session closed does not match this session... ignoring");
            return;
        }
        LOGGER.info("Session {} is closed due to {}", (Object)session.getId(), (Object)reason);
        if (!this.closed.get()) {
            this.reconnectThread = new Thread(() -> {
                while (!session.isOpen()) {
                    try {
                        LOGGER.debug("Waiting 10 seconds before attempting to reconnect to controller {}", (Object)session.getRequestURI());
                        Thread.sleep(10000L);
                        this.session = this.container.connectToServer((Endpoint)this, this.config, session.getRequestURI());
                        if (this.onReconnect == null) break;
                        this.onReconnect.accept(this);
                        break;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (IOException | RuntimeException | DeploymentException e) {
                        LOGGER.warn("Unable to reconnect to controller over Web Socket {} due to {}", (Object)session.getRequestURI(), (Object)e.getMessage());
                    }
                }
            }, "Kie Server - Web Socket reconnect");
            this.reconnectThread.start();
        }
    }

    @Override
    public void init(WebSocketClientConfiguration clientConfig) {
        try {
            if (this.container == null) {
                this.container = ContainerProvider.getWebSocketContainer();
                this.container.setDefaultMaxSessionIdleTimeout(clientConfig.getMaxSessionIdleTimeout().longValue());
                this.container.setAsyncSendTimeout(clientConfig.getAsyncSendTimeout().longValue());
            }
            this.config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)new WebSocketAuthConfigurator(clientConfig.getUserName(), clientConfig.getPassword(), clientConfig.getToken())).encoders(clientConfig.getEncoders()).decoders(clientConfig.getDecoders()).build();
            this.session = this.container.connectToServer((Endpoint)this, this.config, URI.create(clientConfig.getControllerUrl()));
            LOGGER.info("New Web Socket Session with id: {}, started", (Object)this.session.getId());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        LOGGER.debug("Closing Web Socket connection to controller");
        this.closed.set(true);
        if (this.reconnectThread != null) {
            this.reconnectThread.interrupt();
        }
        try {
            this.messageHandler = null;
            this.session.close();
        }
        catch (IOException e) {
            LOGGER.warn("Unexpected error while closing Web Socket connection to controller", (Throwable)e);
        }
    }

    @Override
    public void sendTextWithHandler(String content, Consumer<T> handler) throws IOException {
        if (!this.session.isOpen()) {
            throw new RuntimeException("No connection to controller");
        }
        if (handler != null && this.messageHandler != null) {
            handler.accept(this.messageHandler);
        }
        LOGGER.debug("Sending text message using Web Socket Session with id: {}", (Object)this.session.getId());
        this.session.getBasicRemote().sendText(content);
    }

    @Override
    public boolean isActive() {
        return this.session != null && this.session.isOpen();
    }

    public void onOpen(Session session, EndpointConfig config) {
        LOGGER.info("Connection to Kie Controller over Web Socket is now open with session id: {}", (Object)session.getId());
        if (this.messageHandler != null) {
            session.addMessageHandler(this.messageHandler);
        }
        this.closed.set(false);
    }

    public void onError(Session session, Throwable thr) {
        LOGGER.error("Error received on session id: {}, message: {}", new Object[]{session.getId(), thr.getMessage(), thr});
    }
}

