/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.common.handlers;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;

public class WebSocketServiceResponse
extends ServiceResponse
implements InternalMessageHandler {
    private CountDownLatch latch;
    private KieServiceResponse<?> result;
    private Function<String, KieServiceResponse<?>> handler;

    public WebSocketServiceResponse(boolean isBlocking, Function<String, KieServiceResponse<?>> handler) {
        this.handler = handler;
        if (isBlocking) {
            this.latch = new CountDownLatch(1);
        }
    }

    public KieServiceResponse.ResponseType getType() {
        return this.getWrapperResult().getType();
    }

    public String getMsg() {
        return this.getWrapperResult().getMsg();
    }

    public Object getResult() {
        return this.getWrapperResult().getResult();
    }

    @Override
    public String onMessage(String message) {
        this.result = this.handler.apply(message);
        if (this.latch != null) {
            this.latch.countDown();
        }
        return null;
    }

    protected KieServiceResponse<?> getWrapperResult() {
        if (this.latch != null) {
            try {
                this.latch.await(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.result == null) {
            throw new RuntimeException("Service response not received");
        }
        return this.result;
    }

    public String toString() {
        return "WebSocketServiceResponse{latch=" + this.latch + ", result=" + this.result + ", handler=" + this.handler + "} " + super.toString();
    }
}

