/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.access;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

@JsonIgnoreType
public final class OpenShiftRuntimeId {
    private static final String PROJECT = "prj";
    private static final String SERVICE = "svc";
    private static final String APPLICATION = "app";
    private final String project;
    private final String service;
    private final String application;

    public OpenShiftRuntimeId(String project, String service, String application) {
        if (OpenShiftRuntimeId.trimToNull(project) == null || OpenShiftRuntimeId.trimToNull(service) == null || OpenShiftRuntimeId.trimToNull(application) == null) {
            throw new IllegalArgumentException(String.format("OpenShiftRuntimeId requires all parameters: project[%s], service[%s], application[%s]", project, service, application));
        }
        this.project = project;
        this.service = service;
        this.application = application;
    }

    public String project() {
        return this.project;
    }

    public String service() {
        return this.service;
    }

    public String application() {
        return this.application;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenShiftRuntimeId other = (OpenShiftRuntimeId)obj;
        if (this.project == null ? other.project != null : !this.project.equals(other.project)) {
            return false;
        }
        if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
            return false;
        }
        return !(this.application == null ? other.application != null : !this.application.equals(other.application));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            JsonWriter jw = new JsonWriter((Writer)sw);
            jw.beginObject();
            if (this.project != null) {
                jw.name(PROJECT).value(this.project);
            }
            if (this.service != null) {
                jw.name(SERVICE).value(this.service);
            }
            if (this.application != null) {
                jw.name(APPLICATION).value(this.application);
            }
            jw.endObject();
            jw.flush();
            jw.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return sw.toString();
    }

    public static OpenShiftRuntimeId fromString(String s) {
        String project = null;
        String service = null;
        String application = null;
        try {
            JsonReader jr = new JsonReader((Reader)new StringReader(s));
            jr.beginObject();
            while (jr.hasNext()) {
                String n = jr.nextName();
                if (PROJECT.equals(n)) {
                    project = jr.nextString();
                    continue;
                }
                if (SERVICE.equals(n)) {
                    service = jr.nextString();
                    continue;
                }
                if (APPLICATION.equals(n)) {
                    application = jr.nextString();
                    continue;
                }
                jr.skipValue();
            }
            jr.endObject();
            jr.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return new OpenShiftRuntimeId(project, service, application);
    }

    private static String trimToNull(String s) {
        if (s != null && (s = s.trim()).isEmpty()) {
            s = null;
        }
        return s;
    }
}

