/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.AbstractMastersListener;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public abstract class AbstractMastersSlavesListener
extends AbstractMastersListener {
    private volatile long secondaryHostFailNanos = 0L;
    private AtomicBoolean secondaryHostFail = new AtomicBoolean();
    protected AtomicReference<Protocol> waitNewSecondaryProtocol = new AtomicReference();
    protected AtomicReference<Protocol> waitNewMasterProtocol = new AtomicReference();

    protected AbstractMastersSlavesListener(UrlParser urlParser) {
        super(urlParser);
        this.secondaryHostFail.set(true);
    }

    @Override
    public HandleErrorResult handleFailover(Method method, Object[] args) throws Throwable {
        if (this.isExplicitClosed()) {
            throw new QueryException("Connection has been closed !");
        }
        if (this.currentProtocol.mustBeMasterConnection()) {
            if (this.setMasterHostFail()) {
                this.addToBlacklist(this.currentProtocol.getHostAddress());
            }
            return this.primaryFail(method, args);
        }
        if (this.setSecondaryHostFail()) {
            this.addToBlacklist(this.currentProtocol.getHostAddress());
        }
        return this.secondaryFail(method, args);
    }

    @Override
    protected void resetMasterFailoverData() {
        super.resetMasterFailoverData();
        if (!this.secondaryHostFail.get()) {
            this.currentConnectionAttempts.set(0);
            this.lastRetry = 0L;
        }
    }

    protected void resetSecondaryFailoverData() {
        if (this.secondaryHostFail.compareAndSet(true, false)) {
            this.secondaryHostFailNanos = 0L;
        }
        if (!this.isMasterHostFail()) {
            this.currentConnectionAttempts.set(0);
            this.lastRetry = 0L;
        }
    }

    public long getSecondaryHostFailNanos() {
        return this.secondaryHostFailNanos;
    }

    public boolean setSecondaryHostFail() {
        if (this.secondaryHostFail.compareAndSet(false, true)) {
            this.secondaryHostFailNanos = System.nanoTime();
            this.currentConnectionAttempts.set(0);
            return true;
        }
        return false;
    }

    public boolean isSecondaryHostFail() {
        return this.secondaryHostFail.get();
    }

    public boolean isSecondaryHostFailReconnect() {
        return this.secondaryHostFail.get() && this.waitNewSecondaryProtocol.get() == null;
    }

    public boolean isMasterHostFailReconnect() {
        return this.isMasterHostFail() && this.waitNewMasterProtocol.get() == null;
    }

    @Override
    public boolean hasHostFail() {
        return this.isSecondaryHostFailReconnect() || this.isMasterHostFailReconnect();
    }

    @Override
    public SearchFilter getFilterForFailedHost() {
        return new SearchFilter(this.isMasterHostFail(), this.isSecondaryHostFail());
    }

    public abstract HandleErrorResult secondaryFail(Method var1, Object[] var2) throws Throwable;

    public abstract void foundActiveSecondary(Protocol var1) throws QueryException;
}

