/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.URIish;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;

public class JGitSSHConfigSessionFactory
extends JschConfigSessionFactory {
    private final JGitFileSystemProviderConfiguration config;

    public JGitSSHConfigSessionFactory(JGitFileSystemProviderConfiguration config) {
        this.config = config;
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
        CredentialsProvider provider = new CredentialsProvider(){

            public boolean isInteractive() {
                return false;
            }

            public boolean supports(CredentialItem ... items) {
                return true;
            }

            public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
                for (CredentialItem item : items) {
                    if (item instanceof CredentialItem.YesNoType) {
                        ((CredentialItem.YesNoType)item).setValue(true);
                        continue;
                    }
                    if (!(item instanceof CredentialItem.StringType)) continue;
                    ((CredentialItem.StringType)item).setValue(JGitSSHConfigSessionFactory.this.config.getSshPassphrase());
                }
                return true;
            }
        };
        CredentialsProviderUserInfo userInfo = new CredentialsProviderUserInfo(session, provider);
        session.setUserInfo((UserInfo)userInfo);
        if (this.config.isSshOverHttpProxy() || this.config.isSshOverHttpsProxy()) {
            session.setProxy((Proxy)this.buildProxy(this.config));
        }
    }

    ProxyHTTP buildProxy(JGitFileSystemProviderConfiguration config) {
        int port;
        String host;
        String user = null;
        String passw = null;
        if (config.isSshOverHttpProxy()) {
            host = config.getHttpProxyHost();
            port = config.getHttpProxyPort();
            user = config.getHttpProxyUser();
            passw = config.getHttpProxyPassword();
        } else {
            host = config.getHttpsProxyHost();
            port = config.getHttpsProxyPort();
            user = config.getHttpsProxyUser();
            passw = config.getHttpsProxyPassword();
        }
        ProxyHTTP proxyHTTP = new ProxyHTTP(host, port);
        if (user != null) {
            proxyHTTP.setUserPasswd(user, passw);
        }
        return proxyHTTP;
    }
}

