/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.executor;

import java.util.Optional;
import javax.inject.Inject;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.config.RuntimeConfig;
import org.guvnor.ala.exceptions.ProvisioningException;
import org.guvnor.ala.exceptions.RuntimeOperationException;
import org.guvnor.ala.openshift.access.OpenShiftAccessInterface;
import org.guvnor.ala.openshift.access.OpenShiftClient;
import org.guvnor.ala.openshift.access.exceptions.OpenShiftClientException;
import org.guvnor.ala.openshift.config.OpenShiftRuntimeConfig;
import org.guvnor.ala.openshift.model.OpenShiftProvider;
import org.guvnor.ala.openshift.model.OpenShiftRuntime;
import org.guvnor.ala.openshift.model.OpenShiftRuntimeEndpoint;
import org.guvnor.ala.openshift.model.OpenShiftRuntimeInfo;
import org.guvnor.ala.openshift.model.OpenShiftRuntimeState;
import org.guvnor.ala.pipeline.FunctionConfigExecutor;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeBuilder;
import org.guvnor.ala.runtime.RuntimeDestroyer;
import org.guvnor.ala.runtime.RuntimeEndpoint;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.RuntimeInfo;
import org.guvnor.ala.runtime.RuntimeState;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.util.RuntimeConfigHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftRuntimeExecExecutor<T extends OpenShiftRuntimeConfig>
implements RuntimeBuilder<T, OpenShiftRuntime>,
RuntimeDestroyer,
FunctionConfigExecutor<T, OpenShiftRuntime> {
    private final RuntimeRegistry runtimeRegistry;
    private final OpenShiftAccessInterface openshift;
    private static final Logger LOG = LoggerFactory.getLogger(OpenShiftRuntimeExecExecutor.class);

    @Inject
    public OpenShiftRuntimeExecExecutor(RuntimeRegistry runtimeRegistry, OpenShiftAccessInterface openshift) {
        this.runtimeRegistry = runtimeRegistry;
        this.openshift = openshift;
    }

    public Optional<OpenShiftRuntime> apply(OpenShiftRuntimeConfig config) {
        Optional<OpenShiftRuntime> runtime = this.create(config);
        if (runtime.isPresent()) {
            this.runtimeRegistry.registerRuntime((Runtime)runtime.get());
        }
        return runtime;
    }

    private Optional<OpenShiftRuntime> create(OpenShiftRuntimeConfig runtimeConfig) throws ProvisioningException {
        OpenShiftRuntimeState runtimeState;
        Optional _openshiftProvider = this.runtimeRegistry.getProvider(runtimeConfig.getProviderId(), OpenShiftProvider.class);
        if (!_openshiftProvider.isPresent()) {
            return Optional.empty();
        }
        OpenShiftProvider openshiftProvider = (OpenShiftProvider)_openshiftProvider.get();
        OpenShiftClient openshiftClient = this.openshift.getOpenShiftClient((ProviderId)openshiftProvider);
        LOG.info("Creating runtime...");
        try {
            runtimeState = openshiftClient.create(runtimeConfig);
        }
        catch (OpenShiftClientException ex) {
            throw new ProvisioningException(ex.getMessage(), (Throwable)ex);
        }
        String id = runtimeConfig.getRuntimeId().toString();
        LOG.info("Created runtime: " + id);
        OpenShiftRuntimeEndpoint endpoint = openshiftClient.getRuntimeEndpoint(id);
        return Optional.of(new OpenShiftRuntime(id, RuntimeConfigHelper.buildRuntimeName((RuntimeConfig)runtimeConfig, (String)id), runtimeConfig, (ProviderId)openshiftProvider, (RuntimeEndpoint)endpoint, (RuntimeInfo)new OpenShiftRuntimeInfo(runtimeConfig), (RuntimeState)runtimeState));
    }

    public Class<? extends Config> executeFor() {
        return OpenShiftRuntimeConfig.class;
    }

    public String outputId() {
        return "openshift-runtime";
    }

    public boolean supports(RuntimeConfig config) {
        return config instanceof OpenShiftRuntimeConfig;
    }

    public boolean supports(RuntimeId runtimeId) {
        return runtimeId instanceof OpenShiftRuntime || this.runtimeRegistry.getRuntimeById(runtimeId.getId()) instanceof OpenShiftRuntime;
    }

    public void destroy(RuntimeId runtimeId) {
        Optional _openshiftProvider = this.runtimeRegistry.getProvider(runtimeId.getProviderId(), OpenShiftProvider.class);
        if (!_openshiftProvider.isPresent()) {
            return;
        }
        OpenShiftProvider openshiftProvider = (OpenShiftProvider)_openshiftProvider.get();
        try {
            LOG.info("Destroying runtime: " + runtimeId.getId());
            this.openshift.getOpenShiftClient((ProviderId)openshiftProvider).destroy(runtimeId.getId());
            LOG.info("Destroyed runtime: " + runtimeId.getId());
        }
        catch (OpenShiftClientException ex) {
            throw new RuntimeOperationException("Error Destroying runtime: " + runtimeId.getId(), (Throwable)ex);
        }
        this.runtimeRegistry.deregisterRuntime(runtimeId);
    }
}

