/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.kie.api.fluent.NodeContainerBuilder;

abstract class AbstractCompositeNodeFactory<T extends NodeContainerBuilder<T, P>, P extends NodeContainerBuilder<P, ?>>
extends RuleFlowNodeContainerFactory<T, P> {
    private long linkedIncomingNodeId = -1L;
    private long linkedOutgoingNodeId = -1L;

    protected AbstractCompositeNodeFactory(P nodeContainerFactory, NodeContainer nodeContainer, NodeContainer node, Object id) {
        super(nodeContainerFactory, nodeContainer, node, id);
    }

    protected CompositeContextNode getCompositeNode() {
        return (CompositeContextNode)this.node;
    }

    public T variable(String name, DataType type) {
        return this.variable(name, type, null);
    }

    public T variable(String name, DataType type, Object value) {
        Variable variable = new Variable();
        variable.setName(name);
        variable.setType(type);
        variable.setValue(value);
        VariableScope variableScope = (VariableScope)this.getCompositeNode().getDefaultContext("VariableScope");
        if (variableScope == null) {
            variableScope = new VariableScope();
            this.getCompositeNode().addContext(variableScope);
            this.getCompositeNode().setDefaultContext(variableScope);
        }
        variableScope.getVariables().add(variable);
        return (T)this;
    }

    public T linkIncomingConnections(long nodeId) {
        this.linkedIncomingNodeId = nodeId;
        return (T)this;
    }

    public T linkOutgoingConnections(long nodeId) {
        this.linkedOutgoingNodeId = nodeId;
        return (T)this;
    }

    @Override
    public P done() {
        if (this.linkedIncomingNodeId != -1L) {
            this.getCompositeNode().linkIncomingConnections("DROOLS_DEFAULT", this.linkedIncomingNodeId, "DROOLS_DEFAULT");
        }
        if (this.linkedOutgoingNodeId != -1L) {
            this.getCompositeNode().linkOutgoingConnections(this.linkedOutgoingNodeId, "DROOLS_DEFAULT", "DROOLS_DEFAULT");
        }
        return super.done();
    }
}

