/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.http.server.GitSmartHttpTools;
import org.eclipse.jgit.http.server.HttpServerText;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.http.server.SmartOutputStream;
import org.eclipse.jgit.http.server.SmartServiceInfoRefs;
import org.eclipse.jgit.http.server.UploadPackErrorHandler;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.InternalHttpServerGlue;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.UploadPackInternalServerErrorException;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;

class UploadPackServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final UploadPackErrorHandler handler;

    UploadPackServlet(@Nullable UploadPackErrorHandler handler) {
        this.handler = handler != null ? handler : this::defaultUploadPackHandler;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        if (!"application/x-git-upload-pack-request".equals(req.getContentType())) {
            rsp.sendError(415);
            return;
        }
        UploadPackErrorHandler.UploadPackRunnable r = () -> {
            UploadPack up = (UploadPack)req.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            SmartOutputStream out = new SmartOutputStream(req, rsp, false){

                public void flush() throws IOException {
                    this.doFlush();
                }
            };
            up.setBiDirectionalPipe(false);
            rsp.setContentType("application/x-git-upload-pack-result");
            try {
                up.uploadWithExceptionPropagation(ServletUtils.getInputStream(req), (OutputStream)((Object)out), null);
                out.close();
            }
            catch (ServiceMayNotContinueException e) {
                if (e.isOutput()) {
                    ServletUtils.consumeRequestBody(req);
                    out.close();
                }
                throw e;
            }
            catch (UploadPackInternalServerErrorException e) {
                this.log(up.getRepository(), e.getCause());
                ServletUtils.consumeRequestBody(req);
                out.close();
            }
        };
        this.handler.upload(req, rsp, r);
    }

    private void defaultUploadPackHandler(HttpServletRequest req, HttpServletResponse rsp, UploadPackErrorHandler.UploadPackRunnable r) throws IOException {
        block4: {
            try {
                r.upload();
            }
            catch (ServiceMayNotContinueException e) {
                if (!e.isOutput() && !rsp.isCommitted()) {
                    rsp.reset();
                    GitSmartHttpTools.sendError(req, rsp, e.getStatusCode(), e.getMessage());
                }
            }
            catch (Throwable e) {
                UploadPack up = (UploadPack)req.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
                this.log(up.getRepository(), e);
                if (rsp.isCommitted()) break block4;
                rsp.reset();
                String msg = e instanceof PackProtocolException ? e.getMessage() : null;
                GitSmartHttpTools.sendError(req, rsp, 500, msg);
            }
        }
    }

    private void log(Repository git, Throwable e) {
        this.getServletContext().log(MessageFormat.format(HttpServerText.get().internalErrorDuringUploadPack, ServletUtils.identify(git)), e);
    }

    static class Factory
    implements Filter {
        private final UploadPackFactory<HttpServletRequest> uploadPackFactory;

        Factory(UploadPackFactory<HttpServletRequest> uploadPackFactory) {
            this.uploadPackFactory = uploadPackFactory;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            UploadPack rp;
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse rsp = (HttpServletResponse)response;
            try {
                rp = this.uploadPackFactory.create((Object)req, ServletUtils.getRepository((ServletRequest)req));
            }
            catch (ServiceNotAuthorizedException e) {
                rsp.sendError(401, e.getMessage());
                return;
            }
            catch (ServiceNotEnabledException e) {
                GitSmartHttpTools.sendError(req, rsp, 403, e.getMessage());
                return;
            }
            try {
                req.setAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack", (Object)rp);
                chain.doFilter((ServletRequest)req, (ServletResponse)rsp);
            }
            finally {
                req.removeAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            }
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void destroy() {
        }
    }

    static class InfoRefs
    extends SmartServiceInfoRefs {
        private final UploadPackFactory<HttpServletRequest> uploadPackFactory;

        InfoRefs(UploadPackFactory<HttpServletRequest> uploadPackFactory, List<Filter> filters) {
            super("git-upload-pack", filters);
            this.uploadPackFactory = uploadPackFactory;
        }

        @Override
        protected void begin(HttpServletRequest req, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
            UploadPack up = this.uploadPackFactory.create((Object)req, db);
            InternalHttpServerGlue.setPeerUserAgent((UploadPack)up, (String)req.getHeader("User-Agent"));
            req.setAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack", (Object)up);
        }

        @Override
        protected void advertise(HttpServletRequest req, RefAdvertiser.PacketLineOutRefAdvertiser pck) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
            UploadPack up = (UploadPack)req.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            try {
                up.setBiDirectionalPipe(false);
                up.sendAdvertisedRefs((RefAdvertiser)pck);
            }
            finally {
                up.getRevWalk().close();
            }
        }

        @Override
        protected void respond(HttpServletRequest req, PacketLineOut pckOut, String serviceName) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
            UploadPack up = (UploadPack)req.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            try {
                up.setBiDirectionalPipe(false);
                up.sendAdvertisedRefs((RefAdvertiser)new RefAdvertiser.PacketLineOutRefAdvertiser(pckOut), serviceName);
            }
            finally {
                up.getRevWalk().close();
            }
        }
    }
}

