/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ParentBulkByScrollTask;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.slice.SliceBuilder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;

class BulkByScrollParallelizationHelper {
    private BulkByScrollParallelizationHelper() {
    }

    public static <Request extends AbstractBulkByScrollRequest<Request>> void startSlices(Client client, TaskManager taskManager, Action<Request, BulkByScrollResponse, ?> action, String localNodeId, ParentBulkByScrollTask task, Request request, ActionListener<BulkByScrollResponse> listener) {
        TaskId parentTaskId = new TaskId(localNodeId, task.getId());
        for (SearchRequest slice : BulkByScrollParallelizationHelper.sliceIntoSubRequests(request.getSearchRequest(), "_uid", request.getSlices())) {
            AbstractBulkByScrollRequest requestForSlice = request.forSlice(parentTaskId, slice);
            ActionListener sliceListener = ActionListener.wrap(r -> task.onSliceResponse(listener, slice.source().slice().getId(), r), e -> task.onSliceFailure(listener, slice.source().slice().getId(), e));
            client.execute(action, (ActionRequest)requestForSlice, sliceListener);
        }
    }

    static SearchRequest[] sliceIntoSubRequests(SearchRequest request, String field, int times) {
        SearchRequest[] slices = new SearchRequest[times];
        for (int slice = 0; slice < times; ++slice) {
            SearchSourceBuilder slicedSource;
            SliceBuilder sliceBuilder = new SliceBuilder(field, slice, times);
            if (request.source() == null) {
                slicedSource = new SearchSourceBuilder().slice(sliceBuilder);
            } else {
                if (request.source().slice() != null) {
                    throw new IllegalStateException("Can't slice a request that already has a slice configuration");
                }
                slicedSource = request.source().copyWithNewSlice(sliceBuilder);
            }
            slices[slice] = new SearchRequest().source(slicedSource).searchType(request.searchType()).indices(request.indices()).types(request.types()).routing(request.routing()).preference(request.preference()).requestCache(request.requestCache()).scroll(request.scroll()).indicesOptions(request.indicesOptions());
        }
        return slices;
    }
}

