/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.kie.commons.io.CommonIOExceptionsServiceDotFileTest;
import org.kie.commons.java.nio.file.Path;

public class SimpleFSIOServiceDotFileTest
extends CommonIOExceptionsServiceDotFileTest {
    protected static final Map<String, Object> EMPTY_ENV = Collections.emptyMap();

    @Override
    protected int testFileAttrSize4() {
        return 7;
    }

    @Override
    protected int testFileAttrSize3() {
        return 10;
    }

    @Override
    protected int testFileAttrSize2() {
        return 11;
    }

    @Override
    protected int testFileAttrSize1() {
        return 10;
    }

    @Override
    protected int testDirectoryAttrSize4() {
        return 7;
    }

    @Override
    protected int testDirectoryAttrSize3() {
        return 10;
    }

    @Override
    protected int testDirectoryAttrSize2() {
        return 11;
    }

    @Override
    protected int testDirectoryAttrSize1() {
        return 10;
    }

    @Override
    protected int createDirectoriesAttrSize() {
        return 8;
    }

    @Override
    protected int testNewByteChannelAttrSize() {
        return 8;
    }

    @Override
    public Path getFilePath() {
        try {
            File dir = SimpleFSIOServiceDotFileTest.createTempDirectory();
            return this.ioService().get(dir.toURI()).resolve("myTempFile.txt");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path getTargetPath() {
        try {
            File dir = SimpleFSIOServiceDotFileTest.createTempDirectory();
            return this.ioService().get(dir.toURI()).resolve("myTargetFile.txt");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path getDirectoryPath() {
        try {
            File dir = SimpleFSIOServiceDotFileTest.createTempDirectory();
            return this.ioService().get(dir.toURI()).resolve("myDir");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path getComposedDirectoryPath() {
        try {
            File dir = SimpleFSIOServiceDotFileTest.createTempDirectory();
            return this.ioService().get(dir.toURI()).resolve("path/to/myDir");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File tempFile(String content) throws IOException {
        File file = File.createTempFile("bar", "foo");
        tempFiles.add(file);
        FileOutputStream out = new FileOutputStream(file);
        if (content != null && !content.isEmpty()) {
            ((OutputStream)out).write(content.getBytes());
            out.flush();
        }
        ((OutputStream)out).close();
        return file;
    }
}

