/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.file;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceConfigurationError;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.FileSystemAlreadyExistsException;
import org.kie.commons.java.nio.file.FileSystemNotFoundException;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.ProviderNotFoundException;
import org.kie.commons.java.nio.file.api.FileSystemProviders;
import org.kie.commons.validation.PortablePreconditions;

public final class FileSystems {
    private FileSystems() {
    }

    public static FileSystem getDefault() {
        return DefaultFileSystemHolder.defaultFileSystem;
    }

    public static FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, ProviderNotFoundException, SecurityException {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        return FileSystemProviders.resolveProvider(uri).getFileSystem(uri);
    }

    public static FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        PortablePreconditions.checkNotNull((String)"env", env);
        return FileSystems.newFileSystem(uri, env, null);
    }

    public static FileSystem newFileSystem(Path path, ClassLoader loader) throws IllegalArgumentException, ProviderNotFoundException, ServiceConfigurationError, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        Map env = Collections.emptyMap();
        return FileSystems.newFileSystem(path.toUri(), env, null);
    }

    public static FileSystem newFileSystem(URI uri, Map<String, ?> env, ClassLoader loader) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, ServiceConfigurationError, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        PortablePreconditions.checkNotNull((String)"env", env);
        return FileSystemProviders.resolveProvider(uri).newFileSystem(uri, env);
    }

    private static class DefaultFileSystemHolder {
        static final FileSystem defaultFileSystem = DefaultFileSystemHolder.getDefaultFileSystem();

        private DefaultFileSystemHolder() {
        }

        private static FileSystem getDefaultFileSystem() {
            return FileSystemProviders.getDefaultProvider().getFileSystem(URI.create("default:///"));
        }
    }
}

