/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.file;

import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.file.FileVisitResult;
import org.kie.commons.java.nio.file.FileVisitor;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributes;
import org.kie.commons.validation.PortablePreconditions;

public class SimpleFileVisitor<T>
implements FileVisitor<T> {
    protected SimpleFileVisitor() {
    }

    public FileVisitResult preVisitDirectory(T dir, BasicFileAttributes attrs) throws IOException {
        PortablePreconditions.checkNotNull((String)"dir", dir);
        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
        return FileVisitResult.CONTINUE;
    }

    public FileVisitResult visitFile(T file, BasicFileAttributes attrs) throws IOException {
        PortablePreconditions.checkNotNull((String)"file", file);
        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
        return FileVisitResult.CONTINUE;
    }

    public FileVisitResult visitFileFailed(T file, IOException exc) throws IOException {
        PortablePreconditions.checkNotNull((String)"file", file);
        PortablePreconditions.checkNotNull((String)"exc", (Object)exc);
        throw exc;
    }

    public FileVisitResult postVisitDirectory(T dir, IOException exc) throws IOException {
        PortablePreconditions.checkNotNull((String)"dir", dir);
        if (exc != null) {
            throw exc;
        }
        return FileVisitResult.CONTINUE;
    }
}

