/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.file;

import java.util.Collections;
import org.junit.Test;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.file.AbstractBaseTest;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.FileAlreadyExistsException;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.NoSuchFileException;
import org.kie.commons.java.nio.file.NotDirectoryException;
import org.kie.commons.java.nio.file.NotLinkException;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.Paths;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.commons.java.nio.file.attribute.UserPrincipal;

public class FilesUnsupportedOpsTest
extends AbstractBaseTest {
    @Test(expected=NotDirectoryException.class)
    public void newDirectoryStreamGlobNotDirectoryException() {
        Files.newDirectoryStream((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (String)"*.*");
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamGlobNull() {
        Files.newDirectoryStream(null, (String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamGlobNull2() {
        Files.newDirectoryStream((Path)this.newTempDir(), (String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamGlobNull3() {
        Files.newDirectoryStream(null, (String)"*.*");
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamGlobEmpty() {
        Files.newDirectoryStream((Path)this.newTempDir(), (String)"");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void probeContentType() {
        Files.probeContentType((Path)Files.createTempFile(null, null, (FileAttribute[])new FileAttribute[0]));
    }

    @Test(expected=NoSuchFileException.class)
    public void probeContentTypeDir() {
        Files.probeContentType((Path)this.newTempDir());
    }

    @Test(expected=NoSuchFileException.class)
    public void probeContentTypeNonExistent() {
        Files.probeContentType((Path)Paths.get((String)"/path/to/some/plaxe.txt", (String[])new String[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void probeContentTypeNull() {
        Files.probeContentType(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getPosixFilePermissions() {
        Files.getPosixFilePermissions((Path)this.newTempDir(), (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=NoSuchFileException.class)
    public void getPosixFilePermissionsNoSuchFileException() {
        Files.getPosixFilePermissions((Path)Paths.get((String)"/some/path", (String[])new String[0]), (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getPosixFilePermissionsNull() {
        Files.getPosixFilePermissions(null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getOwner() {
        Files.getOwner((Path)this.newTempDir(), (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=NoSuchFileException.class)
    public void getOwnerNoSuchFileException() {
        Files.getOwner((Path)Paths.get((String)"/some/path", (String[])new String[0]), (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getOwnerNull() {
        Files.getOwner(null, (LinkOption[])new LinkOption[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void setOwner() {
        Files.setOwner((Path)this.newTempDir(), (UserPrincipal)new UserPrincipal(){

            public String getName() {
                return "name";
            }
        });
    }

    @Test(expected=NoSuchFileException.class)
    public void setOwnerNoSuchFileException() {
        Files.setOwner((Path)Paths.get((String)"/some/path", (String[])new String[0]), (UserPrincipal)new UserPrincipal(){

            public String getName() {
                return "name";
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void setOwnerNull() {
        Files.setOwner((Path)this.newTempDir(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setOwnerNull2() {
        Files.setOwner(null, (UserPrincipal)new UserPrincipal(){

            public String getName() {
                return "name";
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void setOwnerNull3() {
        Files.setOwner(null, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void setPosixFilePermissions() {
        Files.setPosixFilePermissions((Path)this.newTempDir(), Collections.emptySet());
    }

    @Test(expected=NoSuchFileException.class)
    public void setPosixFilePermissionsNoSuchFileException() {
        Files.setPosixFilePermissions((Path)Paths.get((String)"/some/path", (String[])new String[0]), Collections.emptySet());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setPosixFilePermissionsNull() {
        Files.setPosixFilePermissions((Path)this.newTempDir(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setPosixFilePermissionsNull2() {
        Files.setPosixFilePermissions(null, Collections.emptySet());
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull() {
        Files.newDirectoryStream(null);
    }

    @Test(expected=NotDirectoryException.class)
    public void newDirectoryStreamNonDirecotory() {
        Files.newDirectoryStream((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull2() {
        Files.newDirectoryStream(null, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return true;
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull3() {
        Files.newDirectoryStream((Path)this.newTempDir(), (DirectoryStream.Filter)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull4() {
        Files.newDirectoryStream(null, (DirectoryStream.Filter)null);
    }

    @Test(expected=NotDirectoryException.class)
    public void newDirectoryStreamNotDirecotory2() {
        Files.newDirectoryStream((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return false;
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull5() {
        Files.newDirectoryStream(null, (String)"*.*");
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull6() {
        Files.newDirectoryStream((Path)this.newTempDir(), (String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamEmpty() {
        Files.newDirectoryStream((Path)this.newTempDir(), (String)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDirectoryStreamNull7() {
        Files.newDirectoryStream(null, (String)null);
    }

    @Test(expected=NotDirectoryException.class)
    public void newDirectoryStreamNotDirecotory3() {
        Files.newDirectoryStream((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (String)"*.*");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void createSymbolicLink() {
        Files.createSymbolicLink((Path)Paths.get((String)"/path/some/place.link", (String[])new String[0]), (Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (FileAttribute[])new FileAttribute[0]);
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void createSymbolicLinkIllegalStateException1() {
        Files.createSymbolicLink((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (FileAttribute[])new FileAttribute[0]);
    }

    @Test(expected=IllegalStateException.class)
    public void createSymbolicLinkIllegalStateException2() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.createSymbolicLink((Path)path, (Path)path, (FileAttribute[])new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createSymbolicLinkNull1() {
        Files.createSymbolicLink(null, (Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (FileAttribute[])new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createSymbolicLinkNull2() {
        Files.createSymbolicLink((Path)Paths.get((String)"/path/some/place.link", (String[])new String[0]), null, (FileAttribute[])new FileAttribute[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createSymbolicLinkNull3() {
        Files.createSymbolicLink(null, null, (FileAttribute[])new FileAttribute[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void createLink() {
        Files.createLink((Path)Paths.get((String)"/path/some/place.link", (String[])new String[0]), (Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]));
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void createLinkIllegalStateException1() {
        Files.createLink((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]), (Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]));
    }

    @Test(expected=IllegalStateException.class)
    public void createLinkIllegalStateException2() {
        Path path = Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.createLink((Path)path, (Path)path);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createLinkNull1() {
        Files.createLink(null, (Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void createLinkNull2() {
        Files.createLink((Path)Paths.get((String)"/path/some/place.link", (String[])new String[0]), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createLinkNull3() {
        Files.createSymbolicLink(null, null, (FileAttribute[])new FileAttribute[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void readSymbolicLink() {
        Files.readSymbolicLink((Path)Files.createTempFile((String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]));
    }

    @Test(expected=NotLinkException.class)
    public void readSymbolicLinkNotLink() {
        Files.readSymbolicLink((Path)Paths.get((String)"/some/file/link.lnk", (String[])new String[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void readSymbolicLinkNull() {
        Files.readSymbolicLink(null);
    }
}

