/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.file;

import java.net.URI;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.Paths;

public class PathsTest {
    @Test
    public void simpleGet() {
        Path path = Paths.get((String)"/path/to/file.txt", (String[])new String[0]);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/file.txt");
    }

    @Test
    public void simplePartitionedGet() {
        Path path = Paths.get((String)"/path", (String[])new String[]{"to", "file.txt"});
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/file.txt");
        Assertions.assertThat((Iterable)path).isEqualTo((Object)Paths.get((String)"/path/to/file.txt", (String[])new String[0]));
    }

    @Test
    public void simpleWindowsGet() {
        Path path = Paths.get((String)"c:\\path\\to\\file.txt", (String[])new String[0]);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"c:\\path\\to\\file.txt");
    }

    @Test
    public void simplePartitionedWindowsGet() {
        Path path = Paths.get((String)"c:\\path", (String[])new String[]{"to", "file.txt"});
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)("c:\\path" + this.separator() + "to" + this.separator() + "file.txt"));
    }

    @Test
    public void simpleGetButUsingURIAsString() {
        Path path = Paths.get((String)"file:///path/to/file.txt", (String[])new String[0]);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/file.txt");
        Assertions.assertThat((Iterable)path).isEqualTo((Object)Paths.get((String)"/path/to/file.txt", (String[])new String[0]));
    }

    @Test
    public void simpleGetButUsingURIAsStringAndDefaultScheme() {
        Path path = Paths.get((String)"default:///path/to/file.txt", (String[])new String[0]);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/file.txt");
        Assertions.assertThat((Iterable)path).isEqualTo((Object)Paths.get((String)"/path/to/file.txt", (String[])new String[0]));
    }

    @Test
    public void simpleGetURI() {
        Path path = Paths.get((URI)URI.create("file:///path/to/file.txt"));
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/file.txt");
        Assertions.assertThat((Iterable)path).isEqualTo((Object)Paths.get((String)"/path/to/file.txt", (String[])new String[0]));
    }

    @Test
    public void simpleGetEmpty() {
        Path path = Paths.get((String)"", (String[])new String[0]);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isFalse();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void simpleGetNull1() {
        Paths.get((String)null, (String[])new String[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void simpleGetNull2() {
        Paths.get((URI)null);
    }

    private String separator() {
        return System.getProperty("file.separator", "/");
    }
}

