/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.jgit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.ThreeWayMergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.kie.commons.data.Pair;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.base.FileTimeImpl;
import org.kie.commons.java.nio.file.NoSuchFileException;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributes;
import org.kie.commons.java.nio.file.attribute.FileTime;
import org.kie.commons.java.nio.fs.jgit.JGitFileAttributes;
import org.kie.commons.validation.PortablePreconditions;

public final class JGitUtil {
    private JGitUtil() {
    }

    public static Git newRepository(File repoFolder) throws IOException {
        PortablePreconditions.checkNotNull((String)"repoFolder", (Object)repoFolder);
        try {
            return Git.init().setBare(true).setDirectory(repoFolder).call();
        }
        catch (GitAPIException e) {
            throw new IOException((Exception)((Object)e));
        }
    }

    public static List<Ref> branchList(Git git) {
        PortablePreconditions.checkNotNull((String)"git", (Object)git);
        return JGitUtil.branchList(git, null);
    }

    public static List<Ref> branchList(Git git, ListBranchCommand.ListMode listMode) {
        PortablePreconditions.checkNotNull((String)"git", (Object)git);
        try {
            return git.branchList().setListMode(listMode).call();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream resolveInputStream(Git git, String treeRef, String path) {
        PortablePreconditions.checkNotNull((String)"git", (Object)git);
        PortablePreconditions.checkNotEmpty((String)"treeRef", (String)treeRef);
        PortablePreconditions.checkNotEmpty((String)"path", (String)path);
        String gitPath = JGitUtil.fixPath(path);
        RevWalk rw = null;
        TreeWalk tw = null;
        try {
            ObjectId tree = git.getRepository().resolve(treeRef + "^{tree}");
            rw = new RevWalk(git.getRepository());
            tw = new TreeWalk(git.getRepository());
            tw.setFilter(PathFilterGroup.createFromStrings(Collections.singleton(gitPath)));
            tw.reset((AnyObjectId)tree);
            while (tw.next()) {
                if (tw.isSubtree() && !gitPath.equals(tw.getPathString())) {
                    tw.enterSubtree();
                    continue;
                }
                ObjectId entid = tw.getObjectId(0);
                FileMode entmode = tw.getFileMode(0);
                RevObject ro = rw.lookupAny((AnyObjectId)entid, entmode.getObjectType());
                rw.parseBody(ro);
                ObjectLoader ldr = git.getRepository().open((AnyObjectId)ro.getId(), 3);
                ObjectStream objectStream = ldr.openStream();
                return objectStream;
            }
        }
        catch (Throwable t) {
            throw new NoSuchFileException("Can't find '" + gitPath + "' in tree '" + treeRef + "'");
        }
        finally {
            if (rw != null) {
                rw.dispose();
            }
            if (tw != null) {
                tw.release();
            }
        }
        throw new NoSuchFileException("");
    }

    private static String fixPath(String path) {
        if (path.equals("/")) {
            return "";
        }
        boolean startsWith = path.startsWith("/");
        boolean endsWith = path.endsWith("/");
        if (startsWith && endsWith) {
            return path.substring(1, path.length() - 1);
        }
        if (startsWith) {
            return path.substring(1);
        }
        if (endsWith) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static Git cloneRepository(File repoFolder, String fromURI, CredentialsProvider credentialsProvider) {
        if (!repoFolder.getName().endsWith(".git")) {
            throw new RuntimeException("Invalid name");
        }
        try {
            Git git;
            FileRepository repository;
            File gitDir = RepositoryCache.FileKey.resolve((File)repoFolder, (FS)FS.DETECTED);
            if (gitDir != null && gitDir.exists()) {
                repository = new FileRepository(gitDir);
                git = new Git((Repository)repository);
            } else {
                git = ((CloneCommand)Git.cloneRepository().setBare(true).setCloneAllBranches(true).setURI(fromURI).setDirectory(repoFolder).setCredentialsProvider(credentialsProvider)).call();
                repository = git.getRepository();
            }
            JGitUtil.fetchRepository(git, credentialsProvider, new RefSpec[0]);
            repository.close();
            return git;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void fetchRepository(Git git, CredentialsProvider credentialsProvider, RefSpec ... refSpecs) throws InvalidRemoteException {
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>();
        if (refSpecs == null || refSpecs.length == 0) {
            specs.add(new RefSpec("+refs/heads/*:refs/remotes/origin/*"));
            specs.add(new RefSpec("+refs/tags/*:refs/tags/*"));
            specs.add(new RefSpec("+refs/notes/*:refs/notes/*"));
        } else {
            specs.addAll(Arrays.asList(refSpecs));
        }
        try {
            ((FetchCommand)git.fetch().setCredentialsProvider(credentialsProvider)).setRefSpecs(specs).call();
        }
        catch (InvalidRemoteException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void delete(Git git, String branchName, String path, String name, String email, String message, TimeZone timeZone, Date when) {
        JGitUtil.commit(git, branchName, path, null, name, email, message, timeZone, when);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void commit(Git git, String branchName, String path, File file, String name, String email, String message, TimeZone timeZone, Date when) {
        String gitPath = JGitUtil.fixPath(path);
        PersonIdent author = JGitUtil.buildPersonIdent(git, name, email, timeZone, when);
        try {
            ObjectInserter odi = git.getRepository().newObjectInserter();
            try {
                ObjectId headId = git.getRepository().resolve(branchName + "^{commit}");
                DirCache index = JGitUtil.createTemporaryIndex(git, headId, gitPath, file);
                ObjectId indexTreeId = index.writeTree(odi);
                CommitBuilder commit = new CommitBuilder();
                commit.setAuthor(author);
                commit.setCommitter(author);
                commit.setEncoding("UTF-8");
                commit.setMessage(message);
                if (headId != null) {
                    commit.setParentId((AnyObjectId)headId);
                }
                commit.setTreeId((AnyObjectId)indexTreeId);
                ObjectId commitId = odi.insert(commit);
                odi.flush();
                RevWalk revWalk = new RevWalk(git.getRepository());
                try {
                    RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commitId);
                    RefUpdate ru = git.getRepository().updateRef("refs/heads/" + branchName);
                    if (headId == null) {
                        ru.setExpectedOldObjectId((AnyObjectId)ObjectId.zeroId());
                    } else {
                        ru.setExpectedOldObjectId((AnyObjectId)headId);
                    }
                    ru.setNewObjectId((AnyObjectId)commitId);
                    ru.setRefLogMessage("commit: " + revCommit.getShortMessage(), false);
                    RefUpdate.Result rc = ru.forceUpdate();
                    switch (rc) {
                        case NEW: 
                        case FORCED: 
                        case FAST_FORWARD: {
                            return;
                        }
                        case REJECTED: 
                        case LOCK_FAILURE: {
                            throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                        }
                        default: {
                            throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, "HEAD", commitId.toString(), rc));
                        }
                    }
                }
                finally {
                    revWalk.release();
                }
            }
            finally {
                odi.release();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static PersonIdent buildPersonIdent(Git git, String name, String email, TimeZone timeZone, Date when) {
        TimeZone tz;
        TimeZone timeZone2 = tz = timeZone == null ? TimeZone.getDefault() : timeZone;
        if (name != null) {
            if (when != null) {
                return new PersonIdent(name, email, when, tz);
            }
            return new PersonIdent(name, email);
        }
        return new PersonIdent(git.getRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirCache createTemporaryIndex(Git git, ObjectId headId, String path, File file) {
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheBuilder dcBuilder = inCoreIndex.builder();
        ObjectInserter inserter = git.getRepository().newObjectInserter();
        try {
            if (file != null) {
                DirCacheEntry dcEntry = new DirCacheEntry(path);
                dcEntry.setLength(file.length());
                dcEntry.setLastModified(file.lastModified());
                dcEntry.setFileMode(FileMode.REGULAR_FILE);
                FileInputStream inputStream = new FileInputStream(file);
                try {
                    dcEntry.setObjectId((AnyObjectId)inserter.insert(3, file.length(), (InputStream)inputStream));
                }
                finally {
                    ((InputStream)inputStream).close();
                }
                dcBuilder.add(dcEntry);
            }
            if (headId != null) {
                TreeWalk treeWalk = new TreeWalk(git.getRepository());
                int hIdx = treeWalk.addTree((AnyObjectId)new RevWalk(git.getRepository()).parseTree((AnyObjectId)headId));
                treeWalk.setRecursive(true);
                while (treeWalk.next()) {
                    String walkPath = treeWalk.getPathString();
                    CanonicalTreeParser hTree = (CanonicalTreeParser)treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                    if (walkPath.equals(path)) continue;
                    DirCacheEntry dcEntry = new DirCacheEntry(walkPath);
                    dcEntry.setObjectId((AnyObjectId)hTree.getEntryObjectId());
                    dcEntry.setFileMode(hTree.getEntryFileMode());
                    dcBuilder.add(dcEntry);
                }
                treeWalk.release();
            }
            dcBuilder.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            inserter.release();
        }
        if (file == null) {
            DirCacheEditor editor = inCoreIndex.editor();
            editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(path));
            editor.finish();
        }
        return inCoreIndex;
    }

    public static Ref getBranch(Git git, String name) {
        try {
            return git.getRepository().getRefDatabase().getRef("refs/heads/" + name);
        }
        catch (java.io.IOException iOException) {
            return null;
        }
    }

    public static void deleteBranch(Git git, Ref branch) {
        try {
            git.branchDelete().setBranchNames(new String[]{branch.getName()}).setForce(true).call();
        }
        catch (GitAPIException e) {
            throw new IOException((Exception)((Object)e));
        }
    }

    public static BasicFileAttributes buildBasicFileAttributes(Git git, String branchName, String path) {
        long createDate = Long.MAX_VALUE;
        long lastModified = Long.MIN_VALUE;
        JGitPathInfo pathInfo = JGitUtil.resolvePath(git, branchName, path);
        if (pathInfo == null) {
            throw new NoSuchFileException(path);
        }
        String gPath = JGitUtil.fixPath(path);
        try {
            LogCommand logCommand = git.log().add((AnyObjectId)JGitUtil.getBranch(git, branchName).getObjectId());
            if (!gPath.isEmpty()) {
                logCommand.addPath(gPath);
            }
            for (RevCommit commit : logCommand.call()) {
                if (commit.getAuthorIdent().getWhen().getTime() < createDate) {
                    createDate = commit.getAuthorIdent().getWhen().getTime();
                }
                if (commit.getAuthorIdent().getWhen().getTime() <= lastModified) continue;
                lastModified = commit.getAuthorIdent().getWhen().getTime();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new JGitFileAttributes(pathInfo.getObjectId() == null ? null : pathInfo.getObjectId().toString(), (FileTime)new FileTimeImpl(lastModified), (FileTime)new FileTimeImpl(createDate), pathInfo.getSize(), pathInfo.getPathType().equals((Object)PathType.FILE), pathInfo.getPathType().equals((Object)PathType.DIRECTORY));
    }

    public static void createBranch(Git git, String source, String target) {
        try {
            git.branchCreate().setName(target).setStartPoint(source).call();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasBranch(Git git, String branchName) {
        PortablePreconditions.checkNotNull((String)"git", (Object)git);
        PortablePreconditions.checkNotEmpty((String)"branchName", (String)branchName);
        return JGitUtil.getBranch(git, branchName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<PathType, ObjectId> checkPath(Git git, String branchName, String path) {
        PortablePreconditions.checkNotNull((String)"git", (Object)git);
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotEmpty((String)"branchName", (String)branchName);
        String gitPath = JGitUtil.fixPath(path);
        if (gitPath.isEmpty()) {
            return Pair.newPair((Object)((Object)PathType.DIRECTORY), null);
        }
        TreeWalk tw = null;
        try {
            ObjectId tree = git.getRepository().resolve(branchName + "^{tree}");
            tw = new TreeWalk(git.getRepository());
            tw.setFilter((TreeFilter)PathFilter.create((String)gitPath));
            tw.reset((AnyObjectId)tree);
            while (tw.next()) {
                if (tw.getPathString().equals(gitPath)) {
                    if (tw.getFileMode(0).equals(16384)) {
                        Pair pair = Pair.newPair((Object)((Object)PathType.DIRECTORY), (Object)tw.getObjectId(0));
                        return pair;
                    }
                    if (tw.getFileMode(0).equals(32768)) {
                        Pair pair = Pair.newPair((Object)((Object)PathType.FILE), (Object)tw.getObjectId(0));
                        return pair;
                    }
                }
                if (!tw.isSubtree()) continue;
                tw.enterSubtree();
            }
        }
        catch (Throwable t) {
        }
        finally {
            if (tw != null) {
                tw.release();
            }
        }
        return Pair.newPair((Object)((Object)PathType.NOT_FOUND), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JGitPathInfo resolvePath(Git git, String branchName, String path) {
        PortablePreconditions.checkNotNull((String)"git", (Object)git);
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotEmpty((String)"branchName", (String)branchName);
        String gitPath = JGitUtil.fixPath(path);
        if (gitPath.isEmpty()) {
            return new JGitPathInfo(null, "/", FileMode.TREE);
        }
        TreeWalk tw = null;
        try {
            ObjectId tree = git.getRepository().resolve(branchName + "^{tree}");
            tw = new TreeWalk(git.getRepository());
            tw.setFilter((TreeFilter)PathFilter.create((String)gitPath));
            tw.reset((AnyObjectId)tree);
            while (tw.next()) {
                if (tw.getPathString().equals(gitPath)) {
                    if (tw.getFileMode(0).equals(FileMode.TREE)) {
                        JGitPathInfo jGitPathInfo = new JGitPathInfo(tw.getObjectId(0), tw.getPathString(), FileMode.TREE);
                        return jGitPathInfo;
                    }
                    if (tw.getFileMode(0).equals(FileMode.REGULAR_FILE) || tw.getFileMode(0).equals(FileMode.EXECUTABLE_FILE)) {
                        long size = tw.getObjectReader().getObjectSize((AnyObjectId)tw.getObjectId(0), 3);
                        JGitPathInfo jGitPathInfo = new JGitPathInfo(tw.getObjectId(0), tw.getPathString(), FileMode.REGULAR_FILE, size);
                        return jGitPathInfo;
                    }
                }
                if (!tw.isSubtree()) continue;
                tw.enterSubtree();
            }
        }
        catch (Throwable t) {
        }
        finally {
            if (tw != null) {
                tw.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JGitPathInfo> listPathContent(Git git, String branchName, String path) {
        PortablePreconditions.checkNotNull((String)"git", (Object)git);
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotEmpty((String)"branchName", (String)branchName);
        String gitPath = JGitUtil.fixPath(path);
        TreeWalk tw = null;
        ArrayList<JGitPathInfo> result = new ArrayList<JGitPathInfo>();
        try {
            ObjectId tree = git.getRepository().resolve(branchName + "^{tree}");
            tw = new TreeWalk(git.getRepository());
            boolean found = false;
            if (gitPath.isEmpty()) {
                found = true;
            } else {
                tw.setFilter((TreeFilter)PathFilter.create((String)gitPath));
            }
            tw.reset((AnyObjectId)tree);
            while (tw.next()) {
                if (!found && tw.isSubtree()) {
                    tw.enterSubtree();
                }
                if (tw.getPathString().equals(gitPath)) {
                    found = true;
                    continue;
                }
                if (!found) continue;
                result.add(new JGitPathInfo(tw.getObjectId(0), tw.getPathString(), tw.getFileMode(0)));
            }
        }
        catch (Throwable t) {
        }
        finally {
            if (tw != null) {
                tw.release();
            }
        }
        return result;
    }

    public static MergeResult mergeBranches(Git git, String source, String target) throws Exception {
        Repository repo = git.getRepository();
        ThreeWayMergeStrategy mergeStrategy = MergeStrategy.RESOLVE;
        LinkedList commits = new LinkedList();
        boolean squash = false;
        RevWalk revWalk = null;
        DirCacheCheckout dco = null;
        try {
            MergeResult msg;
            List unmergedPaths;
            Map failingPaths;
            Map lowLevelResults;
            boolean noProblems;
            Ref head = repo.getRef("HEAD");
            if (head == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            StringBuilder refLogMessage = new StringBuilder("merge ");
            revWalk = new RevWalk(repo);
            Ref ref = (Ref)commits.get(0);
            refLogMessage.append(ref.getName());
            ObjectId objectId = ref.getPeeledObjectId();
            if (objectId == null) {
                objectId = ref.getObjectId();
            }
            RevCommit srcCommit = revWalk.lookupCommit((AnyObjectId)objectId);
            ObjectId headId = head.getObjectId();
            if (headId == null) {
                revWalk.parseHeaders((RevObject)srcCommit);
                dco = new DirCacheCheckout(repo, repo.lockDirCache(), (ObjectId)srcCommit.getTree());
                dco.setFailOnConflict(true);
                dco.checkout();
                RefUpdate refUpdate = repo.updateRef(head.getTarget().getName());
                refUpdate.setNewObjectId((AnyObjectId)objectId);
                refUpdate.setExpectedOldObjectId(null);
                refUpdate.setRefLogMessage("initial pull", false);
                if (refUpdate.update() != RefUpdate.Result.NEW) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                MergeResult mergeResult = new MergeResult((ObjectId)srcCommit, (ObjectId)srcCommit, new ObjectId[]{null, srcCommit}, MergeResult.MergeStatus.FAST_FORWARD, (MergeStrategy)mergeStrategy, null, null);
                return mergeResult;
            }
            RevCommit headCommit = revWalk.lookupCommit((AnyObjectId)headId);
            if (revWalk.isMergedInto(srcCommit, headCommit)) {
                MergeResult mergeResult = new MergeResult((ObjectId)headCommit, (ObjectId)srcCommit, new ObjectId[]{headCommit, srcCommit}, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, (MergeStrategy)mergeStrategy, null, null);
                return mergeResult;
            }
            if (revWalk.isMergedInto(headCommit, srcCommit)) {
                refLogMessage.append(": " + MergeResult.MergeStatus.FAST_FORWARD);
                dco = new DirCacheCheckout(repo, (ObjectId)headCommit.getTree(), repo.lockDirCache(), (ObjectId)srcCommit.getTree());
                dco.setFailOnConflict(true);
                dco.checkout();
                String msg2 = null;
                RevCommit base = null;
                JGitUtil.updateHead(git, refLogMessage, (ObjectId)srcCommit, headId);
                RevCommit newHead = base = srcCommit;
                MergeResult.MergeStatus mergeStatus = MergeResult.MergeStatus.FAST_FORWARD;
                MergeResult mergeResult = new MergeResult((ObjectId)newHead, (ObjectId)base, new ObjectId[]{headCommit, srcCommit}, mergeStatus, (MergeStrategy)mergeStrategy, null, msg2);
                return mergeResult;
            }
            String mergeMessage = "";
            mergeMessage = new MergeMessageFormatter().format(commits, head);
            repo.writeMergeCommitMsg(mergeMessage);
            repo.writeMergeHeads(Arrays.asList(ref.getObjectId()));
            Merger merger = mergeStrategy.newMerger(repo);
            if (merger instanceof ResolveMerger) {
                ResolveMerger resolveMerger = (ResolveMerger)merger;
                resolveMerger.setCommitNames(new String[]{"BASE", "HEAD", ref.getName()});
                resolveMerger.setWorkingTreeIterator((WorkingTreeIterator)new FileTreeIterator(repo));
                noProblems = merger.merge(new AnyObjectId[]{headCommit, srcCommit});
                lowLevelResults = resolveMerger.getMergeResults();
                failingPaths = resolveMerger.getFailingPaths();
                unmergedPaths = resolveMerger.getUnmergedPaths();
            } else {
                noProblems = merger.merge(new AnyObjectId[]{headCommit, srcCommit});
                lowLevelResults = Collections.emptyMap();
                failingPaths = Collections.emptyMap();
                unmergedPaths = Collections.emptyList();
            }
            refLogMessage.append(": Merge made by ");
            refLogMessage.append(mergeStrategy.getName());
            refLogMessage.append('.');
            if (noProblems) {
                dco = new DirCacheCheckout(repo, (ObjectId)headCommit.getTree(), repo.lockDirCache(), merger.getResultTreeId());
                dco.setFailOnConflict(true);
                dco.checkout();
                msg = null;
                RevCommit newHead = null;
                MergeResult.MergeStatus mergeStatus = null;
                newHead = new Git(repo).commit().setReflogComment(refLogMessage.toString()).call();
                mergeStatus = MergeResult.MergeStatus.MERGED;
                MergeResult mergeResult = new MergeResult(newHead.getId(), null, new ObjectId[]{headCommit.getId(), srcCommit.getId()}, mergeStatus, (MergeStrategy)mergeStrategy, null, (String)msg);
                return mergeResult;
            }
            if (failingPaths != null && !failingPaths.isEmpty()) {
                repo.writeMergeCommitMsg(null);
                repo.writeMergeHeads(null);
                msg = new MergeResult(null, (ObjectId)merger.getBaseCommit(0, 1), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.FAILED, (MergeStrategy)mergeStrategy, lowLevelResults, failingPaths, null);
                return msg;
            }
            String mergeMessageWithConflicts = new MergeMessageFormatter().formatWithConflicts(mergeMessage, unmergedPaths);
            repo.writeMergeCommitMsg(mergeMessageWithConflicts);
            MergeResult mergeResult = new MergeResult(null, (ObjectId)merger.getBaseCommit(0, 1), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.CONFLICTING, (MergeStrategy)mergeStrategy, lowLevelResults, null);
            return mergeResult;
        }
        catch (CheckoutConflictException e) {
            List conflicts = dco == null ? Collections.emptyList() : dco.getConflicts();
            throw new org.eclipse.jgit.api.errors.CheckoutConflictException(conflicts, e);
        }
        catch (java.io.IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfMergeCommand, e), (Throwable)e);
        }
        finally {
            if (revWalk != null) {
                revWalk.release();
            }
        }
    }

    private static void updateHead(Git git, StringBuilder refLogMessage, ObjectId newHeadId, ObjectId oldHeadID) throws java.io.IOException, ConcurrentRefUpdateException {
        RefUpdate refUpdate = git.getRepository().updateRef("HEAD");
        refUpdate.setNewObjectId((AnyObjectId)newHeadId);
        refUpdate.setRefLogMessage(refLogMessage.toString(), false);
        refUpdate.setExpectedOldObjectId((AnyObjectId)oldHeadID);
        RefUpdate.Result rc = refUpdate.update();
        switch (rc) {
            case NEW: 
            case FAST_FORWARD: {
                return;
            }
            case REJECTED: 
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), rc);
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, "HEAD", newHeadId.toString(), rc));
    }

    public static class JGitPathInfo {
        private final ObjectId objectId;
        private final String path;
        private final long size;
        private final PathType pathType;

        public JGitPathInfo(ObjectId objectId, String path, FileMode fileMode) {
            this(objectId, path, fileMode, -1L);
        }

        public JGitPathInfo(ObjectId objectId, String path, FileMode fileMode, long size) {
            this.objectId = objectId;
            this.size = size;
            this.path = path;
            this.pathType = fileMode.equals(16384) ? PathType.DIRECTORY : (fileMode.equals(32768) ? PathType.FILE : null);
        }

        public ObjectId getObjectId() {
            return this.objectId;
        }

        public String getPath() {
            return this.path;
        }

        public PathType getPathType() {
            return this.pathType;
        }

        public long getSize() {
            return this.size;
        }
    }

    public static enum PathType {
        NOT_FOUND,
        DIRECTORY,
        FILE;

    }
}

