/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.jgit;

import java.net.URI;
import java.net.URISyntaxException;
import org.fest.assertions.api.Assertions;
import org.junit.Test;

public class URITest {
    @Test
    public void testURI() throws URISyntaxException {
        URI uri = new URI("git://branch@repo-name/path/to/file.txt");
        Assertions.assertThat((String)uri.getScheme()).isEqualTo((Object)"git");
        Assertions.assertThat((String)uri.getAuthority()).isEqualTo((Object)"branch@repo-name");
        Assertions.assertThat((String)uri.getPath()).isEqualTo((Object)"/path/to/file.txt");
        Assertions.assertThat((String)uri.getQuery()).isNull();
        URI uri2 = new URI("git://repo-name");
        Assertions.assertThat((Object)uri2).isNotNull();
        Assertions.assertThat((String)uri2.getAuthority()).isEqualTo((Object)"repo-name");
        URI uri3 = URI.create("git://branch@repo-name/path/to/file.txt");
        Assertions.assertThat((Object)uri3).isNotNull();
        Assertions.assertThat((String)uri3.getScheme()).isEqualTo((Object)"git");
        Assertions.assertThat((String)uri3.getAuthority()).isEqualTo((Object)"branch@repo-name");
        Assertions.assertThat((String)uri3.getPath()).isEqualTo((Object)"/path/to/file.txt");
        Assertions.assertThat((String)uri3.getQuery()).isNull();
        URI uri4 = URI.create("git://master@my-repo/:path/to/some/place.txt");
        Assertions.assertThat((Object)uri4).isNotNull();
        Assertions.assertThat((String)uri4.getScheme()).isEqualTo((Object)"git");
        Assertions.assertThat((String)uri4.getAuthority()).isEqualTo((Object)"master@my-repo");
        Assertions.assertThat((String)uri4.getPath()).isEqualTo((Object)"/:path/to/some/place.txt");
        Assertions.assertThat((String)uri4.getQuery()).isNull();
        URI uri5 = URI.create("git://origin/master@my-repo/:path/to/some/place.txt");
        Assertions.assertThat((Object)uri5).isNotNull();
        Assertions.assertThat((String)uri5.getScheme()).isEqualTo((Object)"git");
        Assertions.assertThat((String)uri5.getAuthority()).isEqualTo((Object)"origin");
        Assertions.assertThat((String)uri5.getPath()).isEqualTo((Object)"/master@my-repo/:path/to/some/place.txt");
        Assertions.assertThat((String)uri5.getQuery()).isNull();
        URI uri6 = URI.create("git://origin/master@my-repo/path/to/some/place.txt");
        Assertions.assertThat((Object)uri6).isNotNull();
        Assertions.assertThat((String)uri6.getScheme()).isEqualTo((Object)"git");
        Assertions.assertThat((String)uri6.getAuthority()).isEqualTo((Object)"origin");
        Assertions.assertThat((String)uri6.getPath()).isEqualTo((Object)"/master@my-repo/path/to/some/place.txt");
        Assertions.assertThat((String)uri6.getQuery()).isNull();
    }
}

