/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kieora.backend.lucene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.Version;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.kieora.backend.lucene.LuceneSetup;
import org.kie.kieora.backend.lucene.util.KObjectUtil;
import org.kie.kieora.model.KObject;
import org.kie.kieora.search.ClusterSegment;
import org.kie.kieora.search.DateRange;
import org.kie.kieora.search.SearchIndex;

public class LuceneSearchIndex
implements SearchIndex {
    private final LuceneSetup lucene;
    private final QueryParser queryParser;

    public LuceneSearchIndex(LuceneSetup lucene) {
        this.lucene = (LuceneSetup)PortablePreconditions.checkNotNull((String)"lucene", (Object)lucene);
        this.queryParser = new QueryParser(Version.LUCENE_40, "fullText", lucene.getAnalyzer());
    }

    public List<KObject> searchByAttrs(Map<String, ?> attrs, int pageSize, int startIndex, ClusterSegment ... clusterSegments) {
        if (attrs == null || attrs.size() == 0) {
            return Collections.emptyList();
        }
        return this.search(this.buildQuery(attrs, clusterSegments), pageSize, startIndex);
    }

    public List<KObject> fullTextSearch(String term, int pageSize, int startIndex, ClusterSegment ... clusterSegments) {
        return this.search(this.buildQuery(term, clusterSegments), pageSize, startIndex);
    }

    public int searchByAttrsHits(Map<String, ?> attrs, ClusterSegment ... clusterSegments) {
        if (attrs == null || attrs.size() == 0) {
            return 0;
        }
        return this.searchHits(this.buildQuery(attrs, clusterSegments));
    }

    public int fullTextSearchHits(String term, ClusterSegment ... clusterSegments) {
        return this.searchHits(this.buildQuery(term, clusterSegments));
    }

    private int searchHits(Query query) {
        IndexSearcher index = this.lucene.nrtSearcher();
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            index.search(query, (Collector)collector);
            int n = collector.getTotalHits();
            return n;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
        finally {
            this.lucene.nrtRelease(index);
        }
    }

    private List<KObject> search(Query query, int pageSize, int startIndex) {
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)((startIndex + 1) * pageSize), (boolean)true);
        IndexSearcher index = this.lucene.nrtSearcher();
        ArrayList<KObject> result = new ArrayList<KObject>(pageSize);
        try {
            index.search(query, (Collector)collector);
            ScoreDoc[] hits = collector.topDocs((int)startIndex).scoreDocs;
            int iterations = hits.length > pageSize ? pageSize : hits.length;
            for (int i = 0; i < iterations; ++i) {
                result.add(KObjectUtil.toKObject(index.doc(hits[i].doc)));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error during Query!", ex);
        }
        finally {
            this.lucene.nrtRelease(index);
        }
        return result;
    }

    private Query buildQuery(Map<String, ?> attrs, ClusterSegment ... clusterSegments) {
        BooleanQuery query = new BooleanQuery();
        for (Map.Entry<String, ?> entry : attrs.entrySet()) {
            if (entry.getValue() instanceof DateRange) {
                Long from = ((DateRange)entry.getValue()).after().getTime();
                Long to = ((DateRange)entry.getValue()).before().getTime();
                query.add((Query)NumericRangeQuery.newLongRange((String)entry.getKey(), (Long)from, (Long)to, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
                continue;
            }
            if (entry.getValue() instanceof String) {
                query.add((Query)new WildcardQuery(new Term(entry.getKey(), entry.getValue().toString())), BooleanClause.Occur.MUST);
                continue;
            }
            if (!(entry.getValue() instanceof Boolean)) continue;
            query.add((Query)new TermQuery(new Term(entry.getKey(), (Boolean)entry.getValue() != false ? "0" : "1")), BooleanClause.Occur.MUST);
        }
        return this.composeQuery((Query)query, clusterSegments);
    }

    private Query buildQuery(String term, ClusterSegment ... clusterSegments) {
        Query fullText;
        try {
            fullText = this.queryParser.parse(term);
        }
        catch (ParseException ex) {
            fullText = new WildcardQuery(new Term("fullText", this.format(term)));
        }
        return this.composeQuery(fullText, clusterSegments);
    }

    private Query composeQuery(Query query, ClusterSegment ... clusterSegments) {
        if (clusterSegments != null && clusterSegments.length > 0) {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add(query, BooleanClause.Occur.MUST);
            BooleanQuery complement = clusterSegments.length == 1 ? booleanQuery : new BooleanQuery();
            for (ClusterSegment clusterSegment : clusterSegments) {
                BooleanQuery clusterBoolean = new BooleanQuery();
                if (clusterSegment.getClusterId() != null) {
                    TermQuery cluster = new TermQuery(new Term("cluster.id", clusterSegment.getClusterId()));
                    clusterBoolean.add((Query)cluster, BooleanClause.Occur.MUST);
                }
                if (clusterSegment.segmentIds() != null && clusterSegment.segmentIds().length > 0) {
                    if (clusterSegment.segmentIds().length == 1) {
                        TermQuery segment = new TermQuery(new Term("segment.id", clusterSegment.segmentIds()[0]));
                        clusterBoolean.add((Query)segment, BooleanClause.Occur.MUST);
                    } else {
                        BooleanQuery segments = new BooleanQuery();
                        for (String segmentId : clusterSegment.segmentIds()) {
                            TermQuery segment = new TermQuery(new Term("segment.id", segmentId));
                            segments.add((Query)segment, BooleanClause.Occur.SHOULD);
                        }
                        clusterBoolean.add((Query)segments, BooleanClause.Occur.MUST);
                    }
                }
                complement.add((Query)clusterBoolean, BooleanClause.Occur.MUST);
            }
            if (clusterSegments.length == 1) {
                return complement;
            }
            booleanQuery.add((Query)complement, BooleanClause.Occur.MUST);
            return booleanQuery;
        }
        return query;
    }

    private String format(String term) {
        return term.toLowerCase();
    }
}

